/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.jobgrade;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tdc.tdcs.common.constants.JobGradeAssessConstants;

public class JobGradeDomainService {
    private static final Log LOGGER = LogFactory.getLog(JobGradeDomainService.class);
    private static final HRBaseServiceHelper TDCS_TJGARECORD_HELPER = new HRBaseServiceHelper("tdcs_tjgarecord");

    public List<Map<String, Object>> queryTjgaRecordInfos(Map<String, Object> paramMap) throws ParseException {
        QFilter[] queryQFilter;
        if (CollectionUtils.isEmpty(paramMap)) {
            LOGGER.info("JobGradeDomainService-queryTjgaRecordInfos-paramMap-isnull.");
            return new ArrayList<Map<String, Object>>(1);
        }
        Long employeeId = (Long)paramMap.get("employeeId");
        Date startEnableDate = (Date)paramMap.get("startEnableDate");
        Date endEnableDate = (Date)paramMap.get("endEnableDate");
        LOGGER.info("JobGradeDomainService-queryTjgaRecordInfos:employeeId={},startEnableDate={},endEnableDate={}.", new Object[]{String.valueOf(employeeId), HRDateTimeUtils.getTrancateDateFromDate((Date)startEnableDate), HRDateTimeUtils.getTrancateDateFromDate((Date)endEnableDate)});
        if (null == employeeId || 0L == employeeId) {
            return new ArrayList<Map<String, Object>>(1);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QFilter employeeQFilter = new QFilter("employee.id", "=", (Object)employeeId);
        employeeQFilter.and(new QFilter("appealresult", "in", (Object)JobGradeAssessConstants.APPEALRESULT_VALID_LIST));
        if (null == startEnableDate && endEnableDate != null) {
            endEnableDate = dateFormat.parse(dateFormat.format(endEnableDate));
            queryQFilter = new QFilter[]{employeeQFilter, new QFilter("enabledate", ">=", (Object)HRDateTimeUtils.parseDate((String)"1900-01-01", (String)"yyyy-MM-dd")), new QFilter("enabledate", "<", (Object)HRDateTimeUtils.getNextDay((Date)endEnableDate))};
        } else if (null != startEnableDate && endEnableDate == null) {
            startEnableDate = dateFormat.parse(dateFormat.format(startEnableDate));
            queryQFilter = new QFilter[]{employeeQFilter, new QFilter("enabledate", ">=", (Object)startEnableDate), new QFilter("enabledate", "<=", (Object)timeFormat.parse("2999-12-31 23:59:59"))};
        } else if (null != startEnableDate && endEnableDate != null) {
            startEnableDate = dateFormat.parse(dateFormat.format(startEnableDate));
            endEnableDate = dateFormat.parse(dateFormat.format(endEnableDate));
            queryQFilter = new QFilter[]{employeeQFilter, new QFilter("enabledate", ">=", (Object)startEnableDate), new QFilter("enabledate", "<", (Object)HRDateTimeUtils.getNextDay((Date)endEnableDate))};
        } else {
            queryQFilter = new QFilter[]{employeeQFilter};
        }
        DynamicObject[] recordInfosDbs = TDCS_TJGARECORD_HELPER.loadDynamicObjectArray(queryQFilter);
        ArrayList<Map<String, Object>> recordInfoListMap = new ArrayList<Map<String, Object>>(recordInfosDbs.length);
        for (int i = 0; i < recordInfosDbs.length; ++i) {
            DynamicObject recordInfosDb = recordInfosDbs[i];
            HashMap<String, Object> recordInfoMap = this.formatRecordInfo(recordInfosDb);
            recordInfoListMap.add(recordInfoMap);
        }
        LOGGER.info("JobGradeDomainService.queryTjgaRecordInfos-finished-and-size=:{}", (Object)recordInfoListMap.size());
        return recordInfoListMap;
    }

    private HashMap<String, Object> formatRecordInfo(DynamicObject recordInfosDb) {
        DynamicObject creator;
        DynamicObject chgAction;
        DynamicObject applyGrade;
        DynamicObject applyJob;
        DynamicObject grade;
        DynamicObject talentFile;
        DynamicObject department;
        DynamicObject person;
        HashMap<String, Object> recordInfoMap = new HashMap<String, Object>(16);
        DynamicObject employee = recordInfosDb.getDynamicObject("employee");
        if (null != employee) {
            recordInfoMap.put("employeeId", employee.getLong("id"));
        }
        if (null != (person = recordInfosDb.getDynamicObject("person"))) {
            recordInfoMap.put("personId", person.getLong("id"));
        }
        if (null != (department = recordInfosDb.getDynamicObject("department"))) {
            recordInfoMap.put("departmentId", department.getLong("id"));
        }
        if (null != (talentFile = recordInfosDb.getDynamicObject("talentfile"))) {
            recordInfoMap.put("talentFileId", talentFile.getLong("id"));
        }
        recordInfoMap.put("applyBillId", recordInfosDb.getLong("applybillid"));
        recordInfoMap.put("assessPlanId", recordInfosDb.getLong("assessplanid"));
        recordInfoMap.put("assessPlanNumber", recordInfosDb.getString("assessplannumber"));
        ILocaleString assessPlanName = recordInfosDb.getLocaleString("assessplanname");
        if (null != assessPlanName) {
            recordInfoMap.put("assessPlanName", assessPlanName.getLocaleValue());
        }
        recordInfoMap.put("enableDate", recordInfosDb.getDate("enabledate"));
        recordInfoMap.put("resGenDate", recordInfosDb.getDate("resgendate"));
        recordInfoMap.put("submitTime", recordInfosDb.getDate("submittime"));
        DynamicObject job = recordInfosDb.getDynamicObject("job");
        if (null != job) {
            recordInfoMap.put("currJobId", job.getLong("id"));
        }
        if (null != (grade = recordInfosDb.getDynamicObject("grade"))) {
            recordInfoMap.put("currGradeId", grade.getLong("id"));
        }
        if (null != (applyJob = recordInfosDb.getDynamicObject("applyjob"))) {
            recordInfoMap.put("applyJobId", applyJob.getLong("id"));
        }
        if (null != (applyGrade = recordInfosDb.getDynamicObject("applygrade"))) {
            recordInfoMap.put("applyGradeId", applyGrade.getLong("id"));
        }
        recordInfoMap.put("appealResult", recordInfosDb.getString("appealresult"));
        recordInfoMap.put("applyType", recordInfosDb.getString("applytype"));
        DynamicObject chgCategory = recordInfosDb.getDynamicObject("chgcategory");
        if (null != chgCategory) {
            recordInfoMap.put("chgCategoryId", chgCategory.getLong("id"));
        }
        if (null != (chgAction = recordInfosDb.getDynamicObject("chgaction"))) {
            recordInfoMap.put("chgActionId", chgAction.getLong("id"));
        }
        if (null != (creator = recordInfosDb.getDynamicObject("creator"))) {
            recordInfoMap.put("creatorId", creator.getLong("id"));
        }
        recordInfoMap.put("createTime", recordInfosDb.getDate("createtime"));
        DynamicObject modifier = recordInfosDb.getDynamicObject("modifier");
        if (null != modifier) {
            recordInfoMap.put("modifierId", modifier.getLong("id"));
        }
        recordInfoMap.put("modifyTime", recordInfosDb.getDate("modifytime"));
        return recordInfoMap;
    }
}

