/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.reviewresult;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;

public class ReviewResultDomainService {
    private static final Log logger = LogFactory.getLog(ReviewResultDomainService.class);
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("tdcs_reviewresult");

    public DynamicObject[] queryReviewResultDBData(List<Map<String, Object>> talentReviewData) {
        List<Long> talentFileIds = this.getTalentFileId(talentReviewData);
        List<Long> activityIds = this.getActivityId(talentReviewData);
        logger.info("ReviewResultDomainService.queryReviewResultDBData params: talentFileIds = {}, activityIds = {}", (Object)SerializationUtils.toJsonString(talentFileIds), (Object)SerializationUtils.toJsonString(activityIds));
        return this.queryReviewResult(talentFileIds, activityIds);
    }

    public DynamicObject[] queryReviewResultByEmployeeId(Long employeeId) {
        return this.queryReviewResultByEmployeeId(employeeId, null);
    }

    public DynamicObject[] queryReviewResultByEmployeeId(Long employeeId, Date actFinishDate) {
        QFilter employeeIdFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter[] qFilters = new QFilter[]{employeeIdFilter};
        if (actFinishDate != null) {
            QFilter finishDateFilter = new QFilter("actfinishdate", "<=", (Object)actFinishDate);
            qFilters = new QFilter[]{employeeIdFilter, finishDateFilter};
        }
        return REPOSITORY.query("id,person,employee,talentfile,activityid,activitynumber,activityname,sessionid,reviewtypename,actfinishdate,xdimname,ydimname,positionnumber,reviewposition,gridmap_tag", qFilters);
    }

    public DynamicObject[] queryReviewResult(List<Long> talentFileIds, List<Long> activityIds) {
        QFilter fileIdFilter = new QFilter("talentfile", "in", talentFileIds);
        QFilter actIdFilter = new QFilter("activityid", "in", activityIds);
        return REPOSITORY.query("id,person,employee,talentfile,activityid,activitynumber,activityname,mapkey,reviewtypename,actfinishdate,xdimname,ydimname,positionnumber,reviewposition,gridmap_tag,modifytime,modifier", new QFilter[]{fileIdFilter, actIdFilter});
    }

    public void addNewReviewResult(List<Map<String, Object>> talentReviewData, DynamicObject[] reviewResultDBData) {
        Map<String, Map<String, Object>> talentReviewDataMap = this.getTalentReviewDataMap(talentReviewData);
        Map<String, DynamicObject> reviewResultDBDataMap = this.getReviewResultDBDataMap(reviewResultDBData);
        List<Map<String, Object>> addNewTalentReviewData = this.filterAddNewTalentReviewData(talentReviewDataMap, reviewResultDBDataMap);
        ArrayList reviewResultList = Lists.newArrayListWithExpectedSize((int)addNewTalentReviewData.size());
        for (Map<String, Object> reviewDataMap : addNewTalentReviewData) {
            DynamicObject resultObj;
            boolean setFieldSuccess = this.setBizField(reviewDataMap, resultObj = REPOSITORY.generateEmptyDynamicObject());
            if (!setFieldSuccess) continue;
            HRBaseUtils.setSysField((DynamicObject)resultObj);
            reviewResultList.add(resultObj);
        }
        REPOSITORY.save(reviewResultList.toArray(new DynamicObject[0]));
    }

    public void updateReviewResult(List<Map<String, Object>> talentReviewData, DynamicObject[] reviewResultDBData) {
        Map<String, Map<String, Object>> talentReviewDataMap = this.getTalentReviewDataMap(talentReviewData);
        Map<String, DynamicObject> reviewResultDBDataMap = this.getReviewResultDBDataMap(reviewResultDBData);
        Set<String> updateReviewDataKeySet = this.filterUpdateTalentReviewData(talentReviewDataMap, reviewResultDBDataMap);
        ArrayList reviewResultList = Lists.newArrayListWithExpectedSize((int)updateReviewDataKeySet.size());
        for (String key : updateReviewDataKeySet) {
            Map<String, Object> reviewDataMap = talentReviewDataMap.get(key);
            DynamicObject resultDBData = reviewResultDBDataMap.get(key);
            Date actFinishDate = resultDBData.getDate("actfinishdate");
            boolean setFieldSuccess = this.setBizField(reviewDataMap, resultDBData);
            resultDBData.set("actfinishdate", (Object)actFinishDate);
            if (!setFieldSuccess) continue;
            HRBaseUtils.setModifyField((DynamicObject)resultDBData);
            reviewResultList.add(resultDBData);
        }
        REPOSITORY.update(reviewResultList.toArray(new DynamicObject[0]));
    }

    private boolean setBizField(Map<String, Object> talentReviewDataMap, DynamicObject resultObj) {
        Long personId = this.getLongValueOrNull(talentReviewDataMap.get("person"));
        Long employeeId = this.getLongValueOrNull(talentReviewDataMap.get("employee"));
        Long talentFileId = this.getLongValueOrNull(talentReviewDataMap.get("talentfile"));
        Long activityId = this.getLongValueOrNull(talentReviewDataMap.get("activityid"));
        Long sessionId = this.getLongValueOrNull(talentReviewDataMap.get("sessionid"));
        if (talentFileId == 0L || activityId == 0L) {
            logger.error("ReviewResultService.setBizField: talentFileId is null or activityId is null, talentFileId={}, activityId={}", (Object)talentFileId, (Object)activityId);
            return false;
        }
        String activityNumber = this.getStringValue(talentReviewDataMap.get("activitynumber"));
        ILocaleString activityName = this.getLocaleStringValue(talentReviewDataMap.get("activityname"));
        ILocaleString reviewTypeName = this.getLocaleStringValue(talentReviewDataMap.get("reviewtypename"));
        Date activityFinishDate = this.getDateValue(talentReviewDataMap.get("actfinishdate"));
        ILocaleString xDimName = this.getLocaleStringValue(talentReviewDataMap.get("xdimname"));
        ILocaleString yDimName = this.getLocaleStringValue(talentReviewDataMap.get("ydimname"));
        String positionNumber = this.getStringValue(talentReviewDataMap.get("positionnumber"));
        String reviewPosition = this.getStringValue(talentReviewDataMap.get("reviewposition"));
        String gridMap = this.getStringValue(talentReviewDataMap.get("gridmap_tag"));
        String mapKey = this.getStringValue(talentReviewDataMap.get("mapkey"));
        this.setPropertyValue(resultObj, "person", personId);
        this.setPropertyValue(resultObj, "employee", employeeId);
        this.setPropertyValue(resultObj, "talentfile", talentFileId);
        this.setPropertyValue(resultObj, "activityid", activityId);
        this.setPropertyValue(resultObj, "sessionid", sessionId);
        this.setPropertyValue(resultObj, "activitynumber", activityNumber);
        this.setPropertyValue(resultObj, "activityname", activityName);
        this.setPropertyValue(resultObj, "reviewtypename", reviewTypeName);
        this.setPropertyValue(resultObj, "actfinishdate", activityFinishDate);
        this.setPropertyValue(resultObj, "xdimname", xDimName);
        this.setPropertyValue(resultObj, "ydimname", yDimName);
        this.setPropertyValue(resultObj, "positionnumber", positionNumber);
        this.setPropertyValue(resultObj, "reviewposition", reviewPosition);
        this.setPropertyValue(resultObj, "gridmap_tag", gridMap);
        this.setPropertyValue(resultObj, "mapkey", mapKey);
        return true;
    }

    private List<Long> getActivityId(List<Map<String, Object>> talentReviewData) {
        return talentReviewData.stream().map(dataMap -> this.getLongValue(dataMap.get("activityid"))).filter(activityId -> !activityId.equals(0L)).collect(Collectors.toList());
    }

    private List<Long> getTalentFileId(List<Map<String, Object>> talentReviewData) {
        return talentReviewData.stream().map(dataMap -> this.getLongValue(dataMap.get("talentfile"))).filter(fileId -> !fileId.equals(0L)).collect(Collectors.toList());
    }

    private void setPropertyValue(DynamicObject dyObject, String propertyName, Object value) {
        if (dyObject.getDynamicObjectType().getProperties().containsKey((Object)propertyName)) {
            if (value instanceof Long && (Long)value == 0L) {
                return;
            }
            dyObject.set(propertyName, value);
        }
    }

    private String getStringValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private Long getLongValue(Object value) {
        if (value == null) {
            return 0L;
        }
        return Long.valueOf(value.toString());
    }

    private Long getLongValueOrNull(Object value) {
        if (value == null) {
            return null;
        }
        return Long.valueOf(value.toString());
    }

    private Date getDateValue(Object value) {
        if (value == null) {
            return new Date();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        Date date = new Date();
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value.toString());
        }
        catch (ParseException exception) {
            logger.error("ReviewResultService.getDateValue: parse date error.", (Throwable)exception);
        }
        return date;
    }

    private ILocaleString getLocaleStringValue(Object value) {
        if (value == null) {
            return new LocaleString();
        }
        if (value instanceof ILocaleString) {
            return (ILocaleString)value;
        }
        Map valueMap = (Map)SerializationUtils.fromJsonString((String)value.toString(), Map.class);
        LocaleString localeString = new LocaleString();
        for (Map.Entry entry : valueMap.entrySet()) {
            localeString.setItem((String)entry.getKey(), entry.getValue());
        }
        return localeString;
    }

    private Map<String, DynamicObject> getReviewResultDBDataMap(DynamicObject[] reviewResultDBData) {
        return Arrays.stream(reviewResultDBData).collect(Collectors.toMap(resultData -> resultData.getString("talentfile.id") + resultData.getString("activityid") + resultData.getString("mapkey"), resultData -> resultData, (v1, v2) -> v1));
    }

    private Map<String, Map<String, Object>> getTalentReviewDataMap(List<Map<String, Object>> talentReviewData) {
        return talentReviewData.stream().collect(Collectors.toMap(dataMap -> this.getLongValue(dataMap.get("talentfile")) + String.valueOf(this.getLongValue(dataMap.get("activityid"))) + this.getStringValue(dataMap.get("mapkey")), dataMap -> dataMap, (v1, v2) -> v1));
    }

    private List<Map<String, Object>> filterAddNewTalentReviewData(Map<String, Map<String, Object>> talentReviewDataMap, Map<String, DynamicObject> reviewResultDBDataMap) {
        Set<String> reviewDataKeySet = talentReviewDataMap.keySet();
        Set<String> resultDBDataKeySet = reviewResultDBDataMap.keySet();
        reviewDataKeySet.removeAll(resultDBDataKeySet);
        ArrayList addNewTalentReviewData = Lists.newArrayListWithExpectedSize((int)reviewDataKeySet.size());
        reviewDataKeySet.forEach(key -> addNewTalentReviewData.add(talentReviewDataMap.get(key)));
        return addNewTalentReviewData;
    }

    private Set<String> filterUpdateTalentReviewData(Map<String, Map<String, Object>> talentReviewDataMap, Map<String, DynamicObject> reviewResultDBDataMap) {
        Set<String> reviewDataKeySet = talentReviewDataMap.keySet();
        Set<String> resultDBDataKeySet = reviewResultDBDataMap.keySet();
        reviewDataKeySet.retainAll(resultDBDataKeySet);
        return reviewDataKeySet;
    }
}

