/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.talentfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;

public class TalentFileDomainService {
    private static final Log LOG = LogFactory.getLog(TalentFileDomainService.class);
    private static final HRBaseServiceHelper FILE_HELPER = new HRBaseServiceHelper("tdcs_talentfile");
    private static final String IS_PRIMARY = "isPrimary";
    private static final String LAST_ID = "lastId";
    private static final String SIZE = "size";
    private static final Integer DEFAULT_SIZE = 1000;
    private static final Integer LIMIT_SIZE = 5000;

    public List<Map<String, Object>> queryTalentFileInfo(List<Long> buIds, List<Long> adminOrgIds, Map<String, Object> paramMap) {
        Integer size;
        Long lastId;
        Boolean isPrimary;
        String orderBy = Objects.isNull(paramMap.get(LAST_ID)) ? null : "id asc";
        try {
            isPrimary = (Boolean)paramMap.get(IS_PRIMARY);
            lastId = Objects.isNull(paramMap.get(LAST_ID)) ? null : Long.valueOf(Long.parseLong(paramMap.get(LAST_ID).toString()));
            size = (Integer)paramMap.get(SIZE);
            if (Objects.isNull(size)) {
                size = DEFAULT_SIZE;
            } else if (size > LIMIT_SIZE) {
                size = LIMIT_SIZE;
            }
        }
        catch (Exception exception) {
            LOG.error("parse-paramMap-exception,paramMap:{}", paramMap, (Object)exception);
            return Lists.newArrayList();
        }
        ArrayList qFilters = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(adminOrgIds)) {
            qFilters.add(new QFilter("affiliateadminorg", "in", adminOrgIds));
        }
        if (!CollectionUtils.isEmpty(buIds)) {
            qFilters.add(new QFilter("org", "in", buIds));
        }
        if (!Objects.isNull(lastId)) {
            qFilters.add(new QFilter("id", ">", (Object)lastId));
        }
        qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilters.add(new QFilter("datastatus", "=", (Object)"1"));
        if (!Objects.isNull(isPrimary)) {
            qFilters.add(new QFilter("isprimary", "=", (Object)(isPrimary != false ? "1" : "0")));
        }
        String selectFields = "id,name,number,employee,isprimary,org,affiliateadminorg,sourcevid";
        DynamicObjectCollection talentFileInfo = QueryServiceHelper.query((String)"tdcs_talentfile", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)orderBy, (int)size);
        ArrayList resultList = Lists.newArrayListWithCapacity((int)talentFileInfo.size());
        if (!CollectionUtils.isEmpty((Collection)talentFileInfo)) {
            String[] split = selectFields.split(",");
            talentFileInfo.forEach(item -> {
                HashMap talentFileInfoMap = Maps.newHashMap();
                Arrays.stream(split).forEach(fieldName -> talentFileInfoMap.put(fieldName, item.get(fieldName)));
                resultList.add(talentFileInfoMap);
            });
        }
        return resultList;
    }

    public Map<Long, Long> queryTalentFileByEmpIds(List<Long> empIds) {
        DynamicObject[] talentFileInfo = FILE_HELPER.queryOriginalArray("id,employee", new QFilter[]{new QFilter("employee", "in", empIds), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1"), new QFilter("isprimary", "=", (Object)"1")});
        return Arrays.stream(talentFileInfo).collect(Collectors.toMap(item -> item.getLong("employee"), item -> item.getLong("id"), (v1, v2) -> v1));
    }

    public Map<Long, Map<String, Long>> queryTalentFileByEmpIds(Long orgId, List<Long> empIds) {
        ArrayList qFilters = Lists.newArrayList();
        if (Objects.isNull(orgId) || orgId == 0L) {
            qFilters.add(new QFilter("employee", "in", empIds));
            qFilters.add(new QFilter("isprimary", "=", (Object)"1"));
        } else {
            qFilters.add(new QFilter("org", "=", (Object)orgId));
            qFilters.add(new QFilter("employee", "in", empIds));
        }
        qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilters.add(new QFilter("datastatus", "=", (Object)"1"));
        Object[] talentFileInfo = FILE_HELPER.queryOriginalArray("id,employee,org,adminorg,position,stdposition,job", qFilters.toArray(new QFilter[0]));
        if (HRArrayUtils.isEmpty((Object[])talentFileInfo)) {
            return Maps.newHashMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)talentFileInfo.length);
        Arrays.stream(talentFileInfo).forEach(item -> {
            HashMap idMapping = Maps.newHashMap();
            idMapping.put("id", item.getLong("id"));
            idMapping.put("org", item.getLong("org"));
            idMapping.put("adminorg", item.getLong("adminorg"));
            idMapping.put("position", item.getLong("position"));
            idMapping.put("stdposition", item.getLong("stdposition"));
            idMapping.put("job", item.getLong("job"));
            resultMap.put(item.getLong("employee"), idMapping);
        });
        return resultMap;
    }

    public void updateTalentFileNumberByPersonId(String number, Long personId) {
        QFilter idQFilter = new QFilter("person.id", "=", (Object)personId);
        QFilter diffNumberQFilter = new QFilter("number", "!=", (Object)number);
        DynamicObject[] result = FILE_HELPER.query("id,person.id,number", new QFilter[]{idQFilter, diffNumberQFilter});
        if (result.length > 0) {
            Arrays.stream(result).forEach(p -> p.set("number", (Object)number));
            FILE_HELPER.save(result);
        }
    }

    public void updateTalentFileNameByPersonId(String name, Long personId) {
        QFilter idQFilter = new QFilter("person.id", "=", (Object)personId);
        QFilter diffNameQFilter = new QFilter("name", "!=", (Object)name);
        DynamicObject[] result = FILE_HELPER.query("id,person.id,name", new QFilter[]{idQFilter, diffNameQFilter});
        if (result.length > 0) {
            Arrays.stream(result).forEach(p -> p.set("name", (Object)name));
            FILE_HELPER.save(result);
        }
    }

    public DynamicObject[] query(String selectProperties, QFilter[] qFilters) {
        return FILE_HELPER.query(selectProperties, qFilters);
    }
}

