/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.talentpool.pool;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;

public class TalentPoolDomainService {
    private static final HRBaseServiceHelper POOL_HELPER = new HRBaseServiceHelper("tdcs_talentpool");

    public void checkAndAddInPoolNum(long pooId, int inPoolTalentNum) {
        DynamicObject poolDy = POOL_HELPER.queryOne((Object)pooId);
        if (!Objects.isNull(poolDy)) {
            int inPoolNum = poolDy.getInt("inpoolnum");
            if (inPoolNum != inPoolTalentNum) {
                inPoolNum = inPoolTalentNum;
            }
            poolDy.set("inpoolnum", (Object)(inPoolNum + 1));
            POOL_HELPER.saveOne(poolDy);
        }
    }

    public void batchAddInPoolNum(Map<Long, List<DynamicObject>> poolSubtractNumMap) {
        Set<Long> ids = poolSubtractNumMap.keySet();
        Object[] poolDys = POOL_HELPER.query("id,inpoolnum", new QFilter[]{new QFilter("id", "in", ids)});
        if (HRArrayUtils.isNotEmpty((Object[])poolDys)) {
            Arrays.stream(poolDys).forEach(poolDy -> {
                List subtractList = (List)poolSubtractNumMap.get(poolDy.getLong("id"));
                int subtractNum = poolDy.getInt("inpoolnum") + subtractList.size();
                poolDy.set("inpoolnum", (Object)subtractNum);
            });
            POOL_HELPER.updateDatas((DynamicObject[])poolDys);
        }
    }

    public void checkAndSubtractInPoolNum(long pooId, int inPoolTalentNum) {
        DynamicObject poolDy = POOL_HELPER.queryOne((Object)pooId);
        if (!Objects.isNull(poolDy)) {
            int inPoolNum = poolDy.getInt("inpoolnum");
            if (inPoolNum != inPoolTalentNum) {
                inPoolNum = inPoolTalentNum;
            }
            inPoolNum = Math.max(inPoolNum - 1, 0);
            poolDy.set("inpoolnum", (Object)inPoolNum);
            POOL_HELPER.saveOne(poolDy);
        }
    }

    public void batchSubtractInPoolNum(Map<Long, List<DynamicObject>> poolSubtractNumMap) {
        Set<Long> ids = poolSubtractNumMap.keySet();
        Object[] poolDys = POOL_HELPER.query("id,inpoolnum", new QFilter[]{new QFilter("id", "in", ids)});
        if (HRArrayUtils.isNotEmpty((Object[])poolDys)) {
            Arrays.stream(poolDys).forEach(poolDy -> {
                List subtractList = (List)poolSubtractNumMap.get(poolDy.getLong("id"));
                int subtractNum = poolDy.getInt("inpoolnum") - subtractList.size();
                subtractNum = Math.max(subtractNum, 0);
                poolDy.set("inpoolnum", (Object)subtractNum);
            });
            POOL_HELPER.updateDatas((DynamicObject[])poolDys);
        }
    }

    public void save(DynamicObject poolDy) {
        POOL_HELPER.saveOne(poolDy);
    }
}

