/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.talentpool.reservetalent;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.common.constants.talentpool.reservetalent.ReserveTalentConstant;
import kd.tdc.tdcs.common.util.CommonUtils;
import kd.tdc.tdcs.enums.talentpool.InPoolStatusEnum;

public class ReserveTalentDomainService
implements ReserveTalentConstant {
    private static final Log LOG = LogFactory.getLog(ReserveTalentDomainService.class);
    private static final HRBaseServiceHelper RESERVE_TALENT_HELPER = new HRBaseServiceHelper("tdcs_reservetalent");

    public DynamicObject generateEmptyDynamicObject() {
        return RESERVE_TALENT_HELPER.generateEmptyDynamicObject();
    }

    public DynamicObject[] queryInPoolReserveTalent() {
        return RESERVE_TALENT_HELPER.query("id,inpooltime,modifier,modifytime,intopooldate", new QFilter[]{new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.IN_POOL.getStatus())});
    }

    public DynamicObject[] queryInPoolTalentByEmp(Long employee) {
        QFilter qFilter = new QFilter("employee", "=", (Object)employee);
        QFilter inPoolStatusQFilter = new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.IN_POOL.getStatus());
        return RESERVE_TALENT_HELPER.query("id,group,talentpool,outofpooltype,outofpooldate,outofpoolreason,inpoolstatus", new QFilter[]{qFilter, inPoolStatusQFilter});
    }

    public void saveReserveTalent(DynamicObject[] reserveTalent) {
        RESERVE_TALENT_HELPER.save(reserveTalent);
    }

    public void updateReserveTalent(DynamicObject[] reserveTalent) {
        RESERVE_TALENT_HELPER.updateDatas(reserveTalent);
    }

    public DynamicObject[] queryReserveTalentByIds(String selectFields, Collection<Long> reserveTalentIds) {
        return RESERVE_TALENT_HELPER.query(selectFields, new QFilter[]{new QFilter("id", "in", reserveTalentIds)});
    }

    public void refreshInPoolTime() {
        DynamicObject[] inPoolReserveTalent = this.queryInPoolReserveTalent();
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        Arrays.stream(inPoolReserveTalent).forEach(reserveTalent -> {
            Date intoPoolDate = reserveTalent.getDate("intopooldate");
            long inPoolTime = CommonUtils.dayDiff((Date)intoPoolDate, (Date)currDate) + 1L;
            reserveTalent.set("inpooltime", (Object)Integer.parseInt(String.valueOf(inPoolTime)));
            reserveTalent.set("modifier", (Object)currUserId);
            reserveTalent.set("modifytime", (Object)currDate);
        });
        this.updateReserveTalent(inPoolReserveTalent);
    }

    public void generateReserveTalentColl(DynamicObject[] entryPoolBillColl) {
        Date currDate = HRDateTimeUtils.truncateDate((Date)new Date());
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        Arrays.stream(entryPoolBillColl).forEach(entryExitPoolBill -> {
            DynamicObject reserveTalent = this.generateEmptyDynamicObject();
            reserveTalent.set("name", (Object)entryExitPoolBill.getString("person.name"));
            reserveTalent.set("number", (Object)entryExitPoolBill.getString("person.number"));
            reserveTalent.set("creator", (Object)currUserId);
            reserveTalent.set("createtime", (Object)currDate);
            reserveTalent.set("modifier", (Object)currUserId);
            reserveTalent.set("modifytime", (Object)currDate);
            reserveTalent.set("talentfile", entryExitPoolBill.get("talentfile"));
            reserveTalent.set("person", entryExitPoolBill.get("person"));
            reserveTalent.set("employee", entryExitPoolBill.get("employee"));
            reserveTalent.set("adminorg", entryExitPoolBill.get("adminorg"));
            reserveTalent.set("position", entryExitPoolBill.get("position"));
            reserveTalent.set("stdposition", entryExitPoolBill.get("stdposition"));
            reserveTalent.set("job", entryExitPoolBill.get("job"));
            reserveTalent.set("enable", (Object)"1");
            reserveTalent.set("status", (Object)"C");
            Object talentPool = entryExitPoolBill.get("talentpool");
            reserveTalent.set("talentpool", talentPool);
            if (talentPool instanceof DynamicObject) {
                reserveTalent.set("org", ((DynamicObject)talentPool).get("createorg"));
                reserveTalent.set("group", ((DynamicObject)talentPool).get("group"));
            }
            reserveTalent.set("currmatchdegree", entryExitPoolBill.get("currmatchdegree"));
            reserveTalent.set("targetcompetency", entryExitPoolBill.get("targetcompetency"));
            reserveTalent.set("supervisor", entryExitPoolBill.get("supervisor"));
            reserveTalent.set("intopooltype", entryExitPoolBill.get("intopooltype"));
            reserveTalent.set("intobillno", entryExitPoolBill.get("billno"));
            reserveTalent.set("intopoolreason", entryExitPoolBill.get("intopoolreason"));
            Date intoPoolDate = entryExitPoolBill.getDate("intopooldate");
            reserveTalent.set("intopooldate", (Object)intoPoolDate);
            long inPoolTime = CommonUtils.dayDiff((Date)intoPoolDate, (Date)currDate) + 1L;
            reserveTalent.set("inpooltime", (Object)inPoolTime);
            reserveTalent.set("inpoolstatus", (Object)InPoolStatusEnum.IN_POOL.getStatus());
            DynamicObjectCollection recommendInfoEntity = entryExitPoolBill.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)recommendInfoEntity)) {
                DynamicObjectCollection entryEntity = reserveTalent.getDynamicObjectCollection("entryentity");
                recommendInfoEntity.forEach(item -> {
                    DynamicObject dynamicObject = entryEntity.addNew();
                    dynamicObject.set("recommendid", item.get("recommendid"));
                    dynamicObject.set("recommendsource", item.get("recommendsource"));
                    dynamicObject.set("recommendintopool", item.get("recommendintopool"));
                    dynamicObject.set("recommendemp", item.get("recommendemp"));
                    dynamicObject.set("recommenddate", item.get("recommenddate"));
                    dynamicObject.set("recommendreason", item.get("recommendreason"));
                });
            }
            collection.add((Object)reserveTalent);
        });
        this.saveReserveTalent((DynamicObject[])collection.toArray((Object[])new DynamicObject[0]));
    }

    public void updateReserveTalentColl(DynamicObject[] exitPoolBillColl) {
        Date currDate = HRDateTimeUtils.truncateDate((Date)new Date());
        long currUserId = RequestContext.get().getCurrUserId();
        Map<Long, DynamicObject> entryExitPoolBillMapping = Arrays.stream(exitPoolBillColl).collect(Collectors.toMap(item -> item.getLong("reservetalent_id"), item -> item, (v1, v2) -> v2));
        Set<Long> reserveTalentIds = entryExitPoolBillMapping.keySet();
        DynamicObject[] reserveTalentInfo = this.queryReserveTalentByIds("id,modifier,modifytime,outofpooltype,outofpooldate,outofbillno,outofpoolreason,inpooltime,inpoolstatus,intopooldate", reserveTalentIds);
        Arrays.stream(reserveTalentInfo).forEach(reserveTalent -> {
            DynamicObject entryExitPoolBill = (DynamicObject)entryExitPoolBillMapping.get(reserveTalent.getLong("id"));
            reserveTalent.set("modifier", (Object)currUserId);
            reserveTalent.set("modifytime", (Object)currDate);
            reserveTalent.set("outofbillno", entryExitPoolBill.get("billno"));
            reserveTalent.set("outofpooltype", entryExitPoolBill.get("outofpooltype"));
            reserveTalent.set("outofpooldate", entryExitPoolBill.get("outofpooldate"));
            reserveTalent.set("outofpoolreason", entryExitPoolBill.get("outofpoolreason"));
            Date outOfPoolDate = entryExitPoolBill.getDate("outofpooldate");
            Date intoPoolDate = reserveTalent.getDate("intopooldate");
            long inPoolTime = CommonUtils.dayDiff((Date)intoPoolDate, (Date)outOfPoolDate) + 1L;
            reserveTalent.set("inpooltime", (Object)Integer.parseInt(String.valueOf(inPoolTime)));
            reserveTalent.set("inpoolstatus", (Object)InPoolStatusEnum.OUT_POOL.getStatus());
        });
        this.updateReserveTalent(reserveTalentInfo);
    }

    public void updateReserveTalentNameByPersonId(String name, Long personId) {
        QFilter idQFilter = new QFilter("person.id", "=", (Object)personId);
        QFilter diffNameQFilter = new QFilter("name", "!=", (Object)name);
        DynamicObject[] result = RESERVE_TALENT_HELPER.query("id,person.id,name", new QFilter[]{idQFilter, diffNameQFilter});
        if (result.length > 0) {
            Arrays.stream(result).forEach(p -> p.set("name", (Object)name));
            RESERVE_TALENT_HELPER.save(result);
        }
    }

    public void updateReserveTalentNumberByPersonId(String number, Long personId) {
        QFilter idQFilter = new QFilter("person.id", "=", (Object)personId);
        QFilter diffNumberQFilter = new QFilter("number", "!=", (Object)number);
        DynamicObject[] result = RESERVE_TALENT_HELPER.query("id,person.id,number", new QFilter[]{idQFilter, diffNumberQFilter});
        if (result.length > 0) {
            Arrays.stream(result).forEach(p -> p.set("number", (Object)number));
            RESERVE_TALENT_HELPER.save(result);
        }
    }

    public void saveExitPoolInfo(DynamicObject[] dys, String billNo) {
        if (HRStringUtils.isEmpty((String)billNo)) {
            LOG.error("ReserveTalentDomainService.saveExitPoolInfo execute error : billNo is null");
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("htm_quitapplybasebill");
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
        DynamicObject leaveDy = serviceHelper.queryOriginalOne("contractenddate", qFilter.toArray());
        if (leaveDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79bb\u804c\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u3002", (String)"ReserveTalentDomainService_1", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        Date contractenddate = leaveDy.getDate("contractenddate");
        for (DynamicObject dy : dys) {
            dy.set("outofpooltype", (Object)1758889381785133056L);
            dy.set("outofpooldate", (Object)contractenddate);
            dy.set("outofpoolreason", (Object)ResManager.loadKDString((String)"\u5458\u5de5\u79bb\u804c\uff0c\u81ea\u52a8\u51fa\u6c60\u3002", (String)"ReserveTalentDomainService_0", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            dy.set("inpoolstatus", (Object)InPoolStatusEnum.OUT_POOL.getStatus());
        }
        LOG.info("ReserveTalentDomainService.saveExitPoolInfo execute info : dysIds = {}", Arrays.stream(dys).map(item -> item.getLong("id")).collect(Collectors.toList()));
        RESERVE_TALENT_HELPER.save(dys);
    }
}

