/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.talentsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class MyAttentionDomainService {
    private static HRBaseServiceHelper attentionServiceHelper = new HRBaseServiceHelper("tdcs_myattention");

    public static List<DynamicObject> getAttentionDynamicObjects(DynamicObject sourceDynamicObject, Long currentUserId, List<Long> employeeIds) {
        ArrayList<DynamicObject> attentions = new ArrayList<DynamicObject>(employeeIds.size());
        DynamicObject[] myattentions = MyAttentionDomainService.getAttention(employeeIds, currentUserId);
        List myemployeeIds = Arrays.stream(myattentions).map(o -> o.getLong("employeeid.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> myattentionMap = Arrays.stream(myattentions).collect(Collectors.toMap(obj -> obj.getLong("employeeid.id"), obj -> obj));
        for (Long employee : employeeIds) {
            DynamicObject row;
            if (!CollectionUtils.isEmpty(myemployeeIds) && myemployeeIds.contains(employee)) {
                row = myattentionMap.get(employee);
                if (Objects.nonNull(row)) {
                    MyAttentionDomainService.assignSource(sourceDynamicObject, row);
                    row.set("modifier", (Object)currentUserId);
                    row.set("modifytime", (Object)new Date());
                }
            } else {
                row = attentionServiceHelper.generateEmptyDynamicObject();
                if (sourceDynamicObject != null) {
                    HRDynamicObjectUtils.copy((DynamicObject)sourceDynamicObject, (DynamicObject)row);
                }
                row.set("userid", (Object)currentUserId);
                row.set("creator", (Object)currentUserId);
                row.set("createtime", (Object)new Date());
                row.set("employeeid", (Object)employee);
            }
            attentions.add(row);
        }
        return attentions;
    }

    private static void assignSource(DynamicObject sourceDynamicObject, DynamicObject row) {
        if (sourceDynamicObject != null) {
            DynamicObject empDy = row.getDynamicObject("employeeid");
            DynamicObject userDy = row.getDynamicObject("userid");
            long id = row.getLong("id");
            HRDynamicObjectUtils.copy((DynamicObject)sourceDynamicObject, (DynamicObject)row);
            row.set("id", (Object)id);
            row.set("userid", (Object)userDy);
            row.set("employeeid", (Object)empDy);
        } else {
            row.getDataEntityType().getProperties().forEach(property -> {
                if (!MyAttentionDomainService.getCommonField().contains(property.getName())) {
                    row.set(property.getName(), null);
                }
            });
        }
    }

    private static Set<String> getCommonField() {
        HashSet<String> ignoreFields = new HashSet<String>();
        ignoreFields.add("id");
        ignoreFields.add("userid");
        ignoreFields.add("userid_id");
        ignoreFields.add("employeeid");
        ignoreFields.add("employeeid_id");
        ignoreFields.add("creator");
        ignoreFields.add("creator_id");
        ignoreFields.add("createtime");
        ignoreFields.add("modifier");
        ignoreFields.add("modifier_id");
        ignoreFields.add("modifytime");
        return ignoreFields;
    }

    public static DynamicObject[] getAttention(List<Long> employeeList, Long currentUserId) {
        QFilter employeeQFilter = new QFilter("employeeid", "in", employeeList);
        QFilter userIdQFilter = new QFilter("userid", "=", (Object)currentUserId);
        return attentionServiceHelper.loadDynamicObjectArray(new QFilter[]{userIdQFilter, employeeQFilter});
    }

    public static DynamicObject[] getAttentionByUserId(Long currentUserId) {
        QFilter userIdQFilter = new QFilter("userid", "=", (Object)currentUserId);
        return attentionServiceHelper.query("id,employeeid,userid", new QFilter[]{userIdQFilter});
    }
}

