/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.tenure.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class TenureDomainService {
    private static final Log LOG = LogFactory.getLog(TenureDomainService.class);
    private static final HRBaseServiceHelper RELATIONAL_HELPER = new HRBaseServiceHelper("tdcs_relational");
    private static final HRBaseServiceHelper DISMISS_RELATION_HELPER = new HRBaseServiceHelper("tdcs_dismissrelation");
    private static final HRBaseServiceHelper RECORD_HELPER = new HRBaseServiceHelper("tdcs_appointrecord");

    public DynamicObject[] queryByEmpAndPosition(Object employee, Object position, Object positionType) {
        QFilter empQFilter = new QFilter("employee", "=", employee);
        QFilter positionQFilter = new QFilter("position", "=", position);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        return RELATIONAL_HELPER.query("id,modifier,modifytime,empposrel,appointid,employee,position,job,standardposition,positiontype,ispull", new QFilter[]{empQFilter, positionQFilter, positionTypeFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection queryByPersonAndOrgAndPosition4Message(Object personId, long orgId, Object position, Object positionType) {
        QFilter personQFilter = new QFilter("employee.person", "=", personId);
        QFilter adminOrgIdQFilter = new QFilter("position.adminorg", "=", (Object)orgId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("position", "=", position);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, adminOrgIdQFilter, positionFilter, positionTypeFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_relational_algo", "tdcs_relational", "id,empposrel,employee,employee.person,position.adminorg,position,positiontype", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            LOG.info("queryByPersonAndOrgAndPosition4Message idlist :{}", idList);
            dynamicObjectArray = RELATIONAL_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return Arrays.stream(dynamicObjectArray).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryDismissByPersonAndOrgAndPosition4Message(Object personId, Object orgId, Object position, Object positionType) {
        QFilter personQFilter = new QFilter("employee.person", "=", personId);
        QFilter adminOrgIdQFilter = new QFilter("position.adminorg", "=", orgId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("position", "=", position);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, adminOrgIdQFilter, positionFilter, positionTypeFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_dismissrelation_algo", "tdcs_dismissrelation", "id,empposrel,employee,employee.person,position.adminorg,position,positiontype", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            LOG.info("queryByPersonAndOrgAndPosition4Message idlist :{}", idList);
            dynamicObjectArray = DISMISS_RELATION_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryDismissByPersonAndOrgAndJob4Message(Object personId, Object adminOrgId, Object job, Object positionType) {
        QFilter personQFilter = new QFilter("employee.person", "=", personId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("job", "=", job);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_dismissrelation_algo", "tdcs_dismissrelation", "id,empposrel,employee.person,empposrel.adminorg,job,positiontype,dismissbillid", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            LOG.info("queryDismissByPersonAndOrgAndJob4Message idlist :{}", idList);
            dynamicObjectArray = DISMISS_RELATION_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryDismissByPersonAndOrgAndStdPosition4Message(Object personId, Object adminOrgId, Object stdposition, Object positionType) {
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("standardposition", "=", stdposition);
        QFilter personQFilter = new QFilter("employee.person", "=", personId);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_dismissrelation_algo", "tdcs_dismissrelation", "id,empposrel,employee.person,empposrel.adminorg,job,positiontype,dismissbillid", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            LOG.info("queryDismissByPersonAndOrgAndStdPosition4Message idlist :{}", idList);
            dynamicObjectArray = DISMISS_RELATION_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryByPersonAndOrgAndPosition(Object personId, long orgId, Object position, Object positionType) {
        QFilter personQFilter = new QFilter("empposrel.person", "=", personId);
        QFilter adminOrgIdQFilter = new QFilter("empposrel.adminorg", "=", (Object)orgId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("position", "=", position);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, adminOrgIdQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_relational_algo", "tdcs_relational", "id,empposrel,empposrel.person,empposrel.adminorg,position,positiontype", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            dynamicObjectArray = RELATIONAL_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryDismissByPersonAndOrgAndPosition(Object personId, long orgId, Object position, Object positionType) {
        QFilter personQFilter = new QFilter("empposrel.person", "=", personId);
        QFilter adminOrgIdQFilter = new QFilter("empposrel.adminorg", "=", (Object)orgId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("position", "=", position);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, adminOrgIdQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_dismissrelation_algo", "tdcs_dismissrelation", "id,empposrel,empposrel.person,empposrel.adminorg,position,positiontype", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            dynamicObjectArray = DISMISS_RELATION_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryDismissByPersonAndOrgAndJob(Object personId, long adminOrgId, Object job, Object positionType) {
        QFilter personQFilter = new QFilter("empposrel.person", "=", personId);
        QFilter adminOrgIdQFilter = new QFilter("empposrel.adminorg", "=", (Object)adminOrgId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("job", "=", job);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, adminOrgIdQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_dismissrelation_algo", "tdcs_dismissrelation", "id,empposrel,empposrel.person,empposrel.adminorg,position,positiontype", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            dynamicObjectArray = DISMISS_RELATION_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryDismissByPersonAndOrgAndStdPosition(Object personId, long adminOrgId, Object stdposition, Object positionType) {
        QFilter personQFilter = new QFilter("empposrel.person", "=", personId);
        QFilter adminOrgIdQFilter = new QFilter("empposrel.adminorg", "=", (Object)adminOrgId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("standardposition", "=", stdposition);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, adminOrgIdQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_dismissrelation_algo", "tdcs_dismissrelation", "id,empposrel,empposrel.person,empposrel.adminorg,position,positiontype", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            dynamicObjectArray = DISMISS_RELATION_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection queryByPersonAndOrgAndJob4Message(Object personId, long adminOrgId, Object job, Object positionType, Object empPosRelId) {
        QFilter personQFilter = new QFilter("employee.person", "=", personId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("job", "=", job);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_relational_algo", "tdcs_relational", "id,empposrel,employee.person,empposrel.adminorg,job,positiontype,appointid", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            LOG.info("queryByPersonAndOrgAndJob4Message idlist :{}", idList);
            dynamicObjectArray = RELATIONAL_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        List appointList = Arrays.stream(dynamicObjectArray).filter(dynamicObject -> dynamicObject.getLong("appointid") != 0L).map(dynamicObject -> dynamicObject.getLong("appointid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("appointid", "in", appointList);
        DynamicObject[] recordDyArray = RECORD_HELPER.query("fid,empposrel,adminorg,appointid", new QFilter[]{qFilter});
        if (recordDyArray == null || recordDyArray.length == 0) {
            LOG.error("queryByPersonAndOrgAndJob4Message cannot find record by appoint,appointList:{}", appointList);
            return new DynamicObjectCollection();
        }
        HashMap appointAdminMap = new HashMap(16);
        Arrays.stream(recordDyArray).forEach(dynamicObject -> {
            if (dynamicObject.get("empposrel") != null) {
                Map<Long, Long> map = Arrays.stream(recordDyArray).collect(Collectors.toMap(dy -> dy.getLong("appointid"), dy -> dy.getLong("empposrel.adminorg.id"), (a1, a2) -> a1));
                appointAdminMap.putAll(map);
            } else {
                Map<Long, Long> map = Arrays.stream(recordDyArray).collect(Collectors.toMap(dy -> dy.getLong("appointid"), dy -> dy.getLong("adminorg.boid"), (a1, a2) -> a1));
                appointAdminMap.putAll(map);
            }
        });
        LOG.error("queryByPersonAndOrgAndJob4Message appointAdminMap:{}", appointAdminMap);
        return Arrays.stream(dynamicObjectArray).filter(dynamicObject -> dynamicObject.getLong("appointid") != 0L).filter(dy -> adminOrgId == (Long)appointAdminMap.get(dy.getLong("appointid"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryByPersonAndOrgAndJob(Object personId, long orgId, Object job, Object positionType) {
        QFilter personQFilter = new QFilter("empposrel.person", "=", personId);
        QFilter adminOrgIdQFilter = new QFilter("empposrel.adminorg", "=", (Object)orgId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("job", "=", job);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, adminOrgIdQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_relational_algo", "tdcs_relational", "id,empposrel,empposrel.person,empposrel.adminorg,job,positiontype", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            dynamicObjectArray = RELATIONAL_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection queryByPersonAndOrgAndStdPosition4Message(Object personId, long adminOrgId, Object stdposition, Object positionType, Object empPosRelId) {
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("standardposition", "=", stdposition);
        QFilter personQFilter = new QFilter("employee.person", "=", personId);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_relational_algo", "tdcs_relational", "id,empposrel,employee.person,empposrel.adminorg,job,positiontype,appointid", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            LOG.info("queryByPersonAndOrgAndStdPosition4Message idlist :{}", idList);
            dynamicObjectArray = RELATIONAL_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        if (dynamicObjectArray == null || dynamicObjectArray.length == 0) {
            LOG.info("queryByPersonAndOrgAndStdPosition4Message is null");
            return new DynamicObjectCollection();
        }
        List appointList = Arrays.stream(dynamicObjectArray).filter(dynamicObject -> dynamicObject.getLong("appointid") != 0L).map(dynamicObject -> dynamicObject.getLong("appointid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("appointid", "in", appointList);
        DynamicObject[] recordDyArray = RECORD_HELPER.query("fid,adminorg,appointid,empposrel", new QFilter[]{qFilter});
        if (recordDyArray == null || recordDyArray.length == 0) {
            LOG.error("queryByPersonAndOrgAndStdPosition4Message cannot find record by appoint,appointList:{}", appointList);
            return new DynamicObjectCollection();
        }
        HashMap appointAdminMap = new HashMap(16);
        Arrays.stream(recordDyArray).forEach(dynamicObject -> {
            if (dynamicObject.get("empposrel") != null) {
                Map<Long, Long> map = Arrays.stream(recordDyArray).collect(Collectors.toMap(dy -> dy.getLong("appointid"), dy -> dy.getLong("empposrel.adminorg.id"), (a1, a2) -> a1));
                appointAdminMap.putAll(map);
            } else {
                Map<Long, Long> map = Arrays.stream(recordDyArray).collect(Collectors.toMap(dy -> dy.getLong("appointid"), dy -> dy.getLong("adminorg.boid"), (a1, a2) -> a1));
                appointAdminMap.putAll(map);
            }
        });
        LOG.error("queryByPersonAndOrgAndStdPosition4Message appointAdminMap:{}", appointAdminMap);
        return Arrays.stream(dynamicObjectArray).filter(dynamicObject -> dynamicObject.getLong("appointid") != 0L).filter(dy -> adminOrgId == (Long)appointAdminMap.get(dy.getLong("appointid"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] queryByPersonAndOrgAndStdPosition(Object personId, long orgId, Object stdposition, Object positionType) {
        QFilter personQFilter = new QFilter("empposrel.person", "=", personId);
        QFilter adminOrgIdQFilter = new QFilter("empposrel.adminorg", "=", (Object)orgId);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        QFilter positionFilter = new QFilter("standardposition", "=", stdposition);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{};
        try (DataSet dataSet = null;){
            QFilter[] qFilters = new QFilter[]{personQFilter, adminOrgIdQFilter, positionTypeFilter, positionFilter, isPullQFilter};
            dataSet = ORM.create().queryDataSet("tdcs_relational_algo", "tdcs_relational", "id,empposrel,standardposition,position,job,positiontype,appointid,employee,modifytime,modifier,creator,createtime", qFilters);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : dataSet) {
                idList.add((Long)row.get("id"));
            }
            dynamicObjectArray = RELATIONAL_HELPER.loadDynamicObjectArray(idList.toArray());
        }
        return dynamicObjectArray;
    }

    public DynamicObject[] queryByEmpposrelId(long empposrelId) {
        QFilter empposrelQFilter = new QFilter("empposrel", "=", (Object)empposrelId);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        return RELATIONAL_HELPER.query("id,modifier,modifytime,empposrel,appointid,employee,position,job,standardposition,positiontype,ispull", new QFilter[]{empposrelQFilter, isPullQFilter}, "modifytime desc");
    }

    public DynamicObject[] queryByEmpAndJob(Object employee, Object job, Object positionType) {
        QFilter empQFilter = new QFilter("employee", "=", employee);
        QFilter positionQFilter = new QFilter("job", "=", job);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        return RELATIONAL_HELPER.query("id,modifier,modifytime,empposrel,appointid,employee,position,job,standardposition,positiontype,ispull", new QFilter[]{empQFilter, positionQFilter, positionTypeFilter});
    }

    public DynamicObject[] queryByEmpAndStandardPosition(Object employee, Object standardPosition, Object positionType) {
        QFilter empQFilter = new QFilter("employee", "=", employee);
        QFilter positionQFilter = new QFilter("standardposition", "=", standardPosition);
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        return RELATIONAL_HELPER.query("id,modifier,modifytime,empposrel,appointid,employee,position,job,standardposition,positiontype,ispull", new QFilter[]{empQFilter, positionQFilter, positionTypeFilter});
    }

    public DynamicObject getRelationalEmptyDy() {
        return RELATIONAL_HELPER.generateEmptyDynamicObject();
    }

    public void saveRelational(DynamicObject dy) {
        RELATIONAL_HELPER.saveOne(dy);
    }

    public void updateRelational(DynamicObject tenure) {
        RELATIONAL_HELPER.updateDataOne(tenure);
    }

    public DynamicObject queryDismissRelationByEmpAndPosition(Object employee, Object position, Object positionType) {
        QFilter empQFilter = new QFilter("employee", "=", employee);
        QFilter positionQFilter = new QFilter("position", "=", position);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        return DISMISS_RELATION_HELPER.queryOne("id,modifier,modifytime,empposrel,dismissbillid,employee,position,job,standardposition,variationtypeid,positiontype", new QFilter[]{empQFilter, positionQFilter, isPullQFilter, positionTypeFilter});
    }

    public DynamicObject queryDismissRelationByEmpAndJob(Object employee, Object job, Object positionType) {
        QFilter empQFilter = new QFilter("employee", "=", employee);
        QFilter jobQFilter = new QFilter("job", "=", job);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        return DISMISS_RELATION_HELPER.queryOne("id,modifier,modifytime,empposrel,dismissbillid,employee,position,job,standardposition,variationtypeid,positiontype", new QFilter[]{empQFilter, jobQFilter, isPullQFilter, positionTypeFilter});
    }

    public DynamicObject queryDismissRelationByEmpPosOrgRel(long empPosOrgRelId) {
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        QFilter positionTypeFilter = new QFilter("empposrel", "=", (Object)empPosOrgRelId);
        return DISMISS_RELATION_HELPER.queryOne("id,modifier,modifytime,empposrel,dismissbillid,employee,position,job,standardposition,variationtypeid,positiontype", new QFilter[]{isPullQFilter, positionTypeFilter});
    }

    public DynamicObject queryDismissRelationByEmpAndStandardPosition(Object employee, Object standardPosition, Object positionType) {
        QFilter empQFilter = new QFilter("employee", "=", employee);
        QFilter standardPositionQFilter = new QFilter("standardposition", "=", standardPosition);
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)"0");
        QFilter positionTypeFilter = new QFilter("positiontype", "=", positionType);
        return DISMISS_RELATION_HELPER.queryOne("id,modifier,modifytime,empposrel,dismissbillid,employee,position,job,standardposition,variationtypeid,positiontype", new QFilter[]{empQFilter, standardPositionQFilter, isPullQFilter, positionTypeFilter});
    }

    public DynamicObject getDismissRelationEmptyDy() {
        return DISMISS_RELATION_HELPER.generateEmptyDynamicObject();
    }

    public void saveDismissRelation(DynamicObject dy) {
        DISMISS_RELATION_HELPER.saveOne(dy);
    }

    public void updateDismissRelation(DynamicObject tenure) {
        DISMISS_RELATION_HELPER.updateDataOne(tenure);
    }

    public DynamicObject queryRelationByAppointId(String selectedProperties, long appointId) {
        QFilter appointIdQFilter = new QFilter("appointid", "=", (Object)appointId);
        DynamicObject relation = RELATIONAL_HELPER.queryOne(selectedProperties, new QFilter[]{appointIdQFilter});
        return relation;
    }

    public DynamicObject queryDismissRelationByDismissId(String selectedProperties, long dismissBillId) {
        QFilter dismissBillIdQFilter = new QFilter("dismissbillid", "=", (Object)dismissBillId);
        DynamicObject dismissRelation = DISMISS_RELATION_HELPER.queryOne(selectedProperties, new QFilter[]{dismissBillIdQFilter});
        return dismissRelation;
    }

    public DynamicObject[] queryRelationalByEmpPosRelId(List<Long> empPosRelIdList) {
        QFilter empQFilter = new QFilter("empposrel", "in", empPosRelIdList);
        return RELATIONAL_HELPER.query("id,modifier,modifytime,empposrel,appointid,employee,position,job,standardposition,positiontype,ispull", new QFilter[]{empQFilter});
    }
}

