/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.formservice;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.IListColumn;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class FormCommonService {
    public void showBosDefaultOperationResult(String title, List<String> errorMsg, IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_operationresult");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("title", (Object)title);
        formShowParameter.setCustomParam("errorMsg", errorMsg);
        formShowParameter.setShowTitle(false);
        view.showForm(formShowParameter);
    }

    public FormShowParameter buildBosDefaultOperationResult(String title, List<String> errorMsg) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_operationresult");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("title", (Object)title);
        fsp.setCustomParam("errorMsg", errorMsg);
        fsp.setShowTitle(false);
        return fsp;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args, String fixName) {
        if (HRStringUtils.isNotEmpty((String)fixName)) {
            List columns = args.getListColumns();
            for (IListColumn item : columns) {
                item.setFixed(true);
                if (!fixName.equals(item.getListFieldKey())) continue;
                break;
            }
        }
    }

    public void setPropertyNotDataChanged(IDataModel model, String ... propertyNames) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        Arrays.stream(propertyNames).forEach(propertyName -> {
            IDataEntityProperty property = (IDataEntityProperty)properties.get(propertyName);
            if (property != null) {
                this.removePropertyChanged(dataEntity, (String)propertyName);
                return;
            }
            List propertyList = dataEntity.getDataEntityType().getProperties().getCollectionProperties(false);
            if (CollectionUtils.isEmpty((Collection)propertyList)) {
                return;
            }
            List<ICollectionProperty> entryPropertyList = propertyList.stream().filter(collectionProperty -> collectionProperty instanceof EntryProp).collect(Collectors.toList());
            entryPropertyList.forEach(entryProperty -> {
                DynamicObjectCollection collection = (DynamicObjectCollection)entryProperty.getValueFast((Object)dataEntity);
                if (CollectionUtils.isEmpty((Collection)collection)) {
                    return;
                }
                collection.forEach(rowDataEntity -> this.removePropertyChanged((DynamicObject)rowDataEntity, (String)propertyName));
            });
        });
    }

    private void removePropertyChanged(DynamicObject dataEntity, String propertyName) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propertyName);
        if (HRObjectUtils.isEmpty((Object)property)) {
            List<IDataEntityProperty> subEntryProperties = properties.stream().filter(subProperty -> subProperty instanceof EntryProp).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(subEntryProperties)) {
                return;
            }
            subEntryProperties.forEach(entryProperty -> {
                DynamicObjectCollection collection = (DynamicObjectCollection)entryProperty.getValueFast((Object)dataEntity);
                if (CollectionUtils.isEmpty((Collection)collection)) {
                    return;
                }
                collection.forEach(rowDataEntity -> this.removePropertyChanged((DynamicObject)rowDataEntity, propertyName));
            });
            return;
        }
        if (property instanceof BasedataProp) {
            property = (IDataEntityProperty)properties.get((Object)(propertyName + "_id"));
            dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
            return;
        }
        if (property instanceof MulBasedataProp || property instanceof EntryProp) {
            if (property instanceof MulBasedataProp) {
                dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
            }
            if (property instanceof EntryProp) {
                dataEntity.getDataEntityState().setRemovedItems(Boolean.FALSE);
            }
            DynamicObjectCollection entryEntities = (DynamicObjectCollection)property.getValueFast((Object)dataEntity);
            entryEntities.forEach(entry -> {
                entry.getDataEntityState().setBizChanged(false);
                entry.getDataEntityState().setRemovedItems(Boolean.FALSE);
                DataEntityPropertyCollection entityProperties = entry.getDataEntityType().getProperties();
                entityProperties.forEach(entProp -> {
                    if (entProp instanceof MulBasedataProp) {
                        this.removePropertyChanged((DynamicObject)entry, entProp.getName());
                    }
                });
            });
            return;
        }
        dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
    }
}

