/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.formservice.batchconfirm;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.formservice.batchconfirm.ConfirmPageUtil;
import kd.tdc.tdcs.bussiness.formservice.batchconfirm.IBatchConfirmFormService;

public abstract class BatchConfirmBaseFormService
implements IBatchConfirmFormService {
    @Override
    public void callValidatorBeforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs, String operateKey, AbstractFormPlugin formPlugin) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String opKey = operate.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)opKey)) {
            return;
        }
        String isOpCancel = operate.getOption().getVariableValue("isopcancel", null);
        if (HRStringUtils.isEmpty((String)isOpCancel)) {
            IListView listView = (IListView)formPlugin.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            beforeDoOperationEventArgs.setCancel(true);
            OperateOption operateOption = operate.getOption();
            listView.getPageCache().put(opKey + "_optionVariable", SerializationUtils.toJsonString((Object)operateOption.getVariables()));
            operateOption.setVariableValue("isopcancel", "1");
            String fromId = ((ListShowParameter)listView.getFormShowParameter()).getBillFormId();
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)operate.getOperateKey(), (String)fromId, (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)operateOption);
            this.handleValidateResult(preOpResult, operate, formPlugin);
        }
    }

    @Override
    public void cancelOpBeforeExecuteOperationTransaction(BeforeOperationArgs args, AbstractOperationServicePlugIn plugIn) {
        OperateOption option = plugIn.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            args.setCancel(true);
        }
    }

    @Override
    public void doOperationClosedCallBack(Object returnData, String opKey, AbstractFormPlugin formPlugin) {
        Map result = (Map)returnData;
        if (!CollectionUtils.isEmpty((Map)result) && ((Boolean)result.get("iscofirm")).booleanValue()) {
            IListView listView = (IListView)formPlugin.getView();
            String failPkIdString = listView.getPageCache().get("failpkid");
            if (!HRStringUtils.isEmpty((String)failPkIdString)) {
                List failPkIds = (List)SerializationUtils.deSerializeFromBase64((String)failPkIdString);
                List failRows = failPkIds.stream().map(ListSelectedRow::new).collect(Collectors.toList());
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                selectedRows.removeAll(failRows);
            }
            OperateOption option = OperateOption.create();
            this.setClosedCallBackOperateOption(returnData, option);
            String optionVariableCache = listView.getPageCache().get(opKey + "_optionVariable");
            if (HRStringUtils.isNotEmpty((String)optionVariableCache)) {
                Map optionVariables = (Map)SerializationUtils.fromJsonString((String)optionVariableCache, Map.class);
                optionVariables.remove("ishasright");
                optionVariables.forEach((arg_0, arg_1) -> ((OperateOption)option).setVariableValue(arg_0, arg_1));
            }
            option.setVariableValue("isopcancel", "0");
            listView.invokeOperation(opKey, option);
        }
    }

    public void setClosedCallBackOperateOption(Object returnData, OperateOption option) {
    }

    @Override
    public void refreshAfterDoOperation(AfterDoOperationEventArgs args, AbstractFormPlugin formPlugin) {
        BillList billList = (BillList)formPlugin.getControl("billlistap");
        if (billList == null) {
            return;
        }
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null) {
            if (operationResult.isSuccess()) {
                billList.refresh();
                return;
            }
            if (billList.getSelectedRows().size() > 1) {
                billList.refresh();
            }
        }
    }

    @Override
    public void doOperationConfirmCallBack(AbstractFormPlugin formPlugin) {
    }

    protected boolean handleValidateResultForAllSuccess(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        return false;
    }

    protected boolean handleValidateResultForAllFail(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        return false;
    }

    protected abstract boolean handleValidateResultForSomeFail(OperationResult var1, FormOperate var2, int var3, int var4, AbstractFormPlugin var5);

    protected abstract List<HRExportHeadObject> createExcelHeadData(FormOperate var1);

    protected abstract List<Map<String, Object>> createExcelExportData(OperationResult var1, FormOperate var2, AbstractFormPlugin var3);

    private void handleValidateResult(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        listView.getPageCache().remove("failpkid");
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        List failPkId = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).distinct().collect(Collectors.toList());
        int failSize = failPkId.size();
        int allRowsSize = selectedRows.size();
        if (failSize == 0) {
            if (!this.handleValidateResultForAllSuccess(operationResult, operate, formPlugin)) {
                OperateOption option = operate.getOption();
                option.setVariableValue("isopcancel", "0");
                listView.invokeOperation(operate.getOperateKey(), option);
            }
            return;
        }
        if (failSize == allRowsSize) {
            if (!this.handleValidateResultForAllFail(operationResult, operate, formPlugin)) {
                this.showValidateErrorMessage(operationResult, operate);
            }
            return;
        }
        String failPkIdString = SerializationUtils.serializeToBase64(failPkId);
        listView.getPageCache().put("failpkid", failPkIdString);
        if (!this.handleValidateResultForSomeFail(operationResult, operate, allRowsSize, failSize, formPlugin)) {
            this.showBatchConfirmPageDefault(operationResult, operate, allRowsSize, failSize, formPlugin);
        }
    }

    private void showBatchConfirmPageDefault(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        String opName = operate.getOperateName().getLocaleValue();
        String allNumLbl = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d\uff1a", (String)"BatchConfirmBaseFormService_0", (String)"tdc-tdcs-business", (Object[])new Object[]{allRowsSize});
        String fitNumLbl = String.valueOf(allRowsSize - failSize);
        String fitLbl = ResManager.loadKDString((String)"\u6761\u7b26\u5408\u6761\u4ef6\uff0c\u53ef\u64cd\u4f5c{0}", (String)"BatchConfirmBaseFormService_1", (String)"tdc-tdcs-business", (Object[])new Object[]{opName});
        String noFitNumLbl = String.valueOf(failSize);
        String noFitLbl = ResManager.loadKDString((String)"\u6761\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u5c06\u4e3a\u4f60\u8df3\u8fc7", (String)"BatchConfirmBaseFormService_2", (String)"tdc-tdcs-business", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u786e\u8ba4\u6570\u636e", (String)"BatchConfirmBaseFormService_3", (String)"tdc-tdcs-business", (Object[])new Object[]{opName});
        String finalLbl = ResManager.loadKDString((String)"{0}\u9009\u4e2d\u7684\u6570\u636e\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"BatchConfirmBaseFormService_4", (String)"tdc-tdcs-business", (Object[])new Object[]{opName});
        List<HRExportHeadObject> headDataList = this.createExcelHeadData(operate);
        List<Map<String, Object>> exportDataList = this.createExcelExportData(operationResult, operate, formPlugin);
        FormShowParameter confirmPage = ConfirmPageUtil.getBatchConfirmPage(allNumLbl, fitNumLbl, fitLbl, noFitNumLbl, noFitLbl, finalLbl, excelName, exportDataList, headDataList);
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, operate.getOperateKey()));
        confirmPage.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"BatchConfirmBaseFormService_5", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        formPlugin.getView().showForm(confirmPage);
    }

    protected void showValidateErrorMessage(OperationResult operationResult, FormOperate operate) {
        IListView listView = (IListView)operate.getView();
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            return;
        }
        String firstErrorMsg = this.getErrorMsg((IOperateInfo)allErrorOrValidateInfo.get(0));
        boolean isExistsDifferentError = allErrorOrValidateInfo.stream().map(this::getErrorMsg).anyMatch(errorMsg -> !HRStringUtils.equals((String)errorMsg, (String)firstErrorMsg));
        if (isExistsDifferentError) {
            listView.showOperationResult(operationResult, operate.getOperateName().getLocaleValue());
        } else {
            listView.showErrorNotification(firstErrorMsg);
        }
    }

    public String getErrorMsg(IOperateInfo operateInfo) {
        String[] splitArrays;
        String colon;
        String splitFlag;
        String infoMessage = operateInfo.getMessage();
        int index = infoMessage.indexOf(splitFlag = (colon = ResManager.loadKDString((String)"\uff1a", (String)"BatchConfirmBaseFormService_6", (String)"tdc-tdcs-business", (Object[])new Object[0])) + " ");
        if (index > 0 && index < infoMessage.length() - 1 && (splitArrays = infoMessage.split(splitFlag)).length == 2) {
            return infoMessage.substring(index + 1);
        }
        return infoMessage;
    }
}

