/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.license;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRBizCertSignHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import org.apache.commons.lang.StringUtils;

public final class TDCSCertCommonHelper {
    private static final Log logger = LogFactory.getLog(TDCSCertCommonHelper.class);
    private static final String TDCS_CERTENTITY = "tdcs_certdetail";
    private static final HRBaseServiceHelper HRTI_CERTHELPER = new HRBaseServiceHelper("tdcs_certdetail");

    public static Map<String, Object> prepareVerifyCertCount(String bizAppID, String bizObjID, List<Long> pids) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        TDCSCertCommonHelper.validateParameter(bizAppID, bizObjID, pids);
        String groupId = TDCSCertCommonHelper.getGroupId(bizAppID, bizObjID);
        DynamicObject[] certDetails = TDCSCertCommonHelper.loadCertDetail(groupId, pids);
        DynamicObject[] exceptionCertDetails = TDCSCertCommonHelper.batchCheckSignStr(certDetails);
        List<Long> unCertPids = TDCSCertCommonHelper.getUnCertDetailDiffPids(pids, certDetails);
        Map preVerifyCertMap = HRCertCommonHelper.verifyCertCount((String)bizAppID, (String)bizObjID, (int)unCertPids.size());
        resultMap.put("NEXISTID", unCertPids);
        List<Long> exceptionPids = TDCSCertCommonHelper.getPidByCertDetail(exceptionCertDetails);
        resultMap.put("EXCEPTID", exceptionPids);
        List<Long> existCertPids = TDCSCertCommonHelper.getPidByCertDetail(certDetails);
        existCertPids.removeAll(exceptionPids);
        resultMap.put("EXISTID", existCertPids);
        resultMap.put("DATA", preVerifyCertMap);
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.prepareVerifyCertCount: unCertDetail={},existCertPid={},preVerifyCertMap={}", new Object[]{JSON.toJSONString(unCertPids), JSON.toJSONString(existCertPids), JSON.toJSONString((Object)preVerifyCertMap)});
        return resultMap;
    }

    public static Map<String, Object> updateUsedCertCount(String bizAppID, String bizObjID, List<Long> pids) {
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.updateUsedCertCount-1: bizAppID = {},bizObjID = {} ,pids={}", new Object[]{bizAppID, bizObjID, JSON.toJSONString(pids)});
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        TDCSCertCommonHelper.validateParameter(bizAppID, bizObjID, pids);
        List<Long> pidList = pids.stream().distinct().collect(Collectors.toList());
        String groupId = TDCSCertCommonHelper.getGroupId(bizAppID, bizObjID);
        DynamicObject[] certDetails = TDCSCertCommonHelper.loadCertDetail(groupId, pidList);
        List<Long> unCertDetails = TDCSCertCommonHelper.getUnCertDetailDiffPids(pidList, certDetails);
        if (unCertDetails.size() == 0) {
            TDCSCertCommonHelper.batchUpdateUsedCertDetails(certDetails);
            resultMap.put("STATE", "TRUE");
        } else {
            Map preVerifyCertMap = HRCertCommonHelper.verifyCertCount((String)bizAppID, (String)bizObjID, (int)unCertDetails.size());
            if (HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(preVerifyCertMap.get("infoType"))) {
                resultMap.put("DATA", preVerifyCertMap);
                resultMap.put("STATE", "FALSE");
            } else {
                Map usedCertMap = HRCertCommonHelper.updateUsedCertCount((String)bizAppID, (String)bizObjID, (int)unCertDetails.size());
                TDCSCertCommonHelper.batchUpdateUsedCertDetails(certDetails);
                TDCSCertCommonHelper.batchInsertCertDetails(unCertDetails, groupId);
                resultMap.put("DATA", usedCertMap);
                resultMap.put("STATE", "TRUE");
            }
        }
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.updateUsedCertCount-2: resultMap={}", (Object)JSON.toJSONString(resultMap));
        return resultMap;
    }

    public static Map<String, Object> verifyCert(String bizAppID, String bizObjID) {
        Map verifyCertMap = HRCertCommonHelper.verifyCertCount((String)bizAppID, (String)bizObjID);
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.verifyCert: bizAppID={},bizObjID={},verifyCertMap={}", new Object[]{bizAppID, bizObjID, JSON.toJSONString((Object)verifyCertMap)});
        return verifyCertMap;
    }

    public static Map<String, Object> verifyCertByPid(String bizAppID, String bizObjID, List<Long> pids) {
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.verifyCertByPid-1: bizAppID = {},bizObjID = {} ,pids={}", new Object[]{bizAppID, bizObjID, JSON.toJSONString(pids)});
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        TDCSCertCommonHelper.validateParameter(bizAppID, bizObjID, pids);
        Map verifyCertMap = HRCertCommonHelper.verifyCertCount((String)bizAppID, (String)bizObjID);
        String state = "NORMAL";
        String errorMessage = "";
        String groupId = TDCSCertCommonHelper.getGroupId(bizAppID, bizObjID);
        DynamicObject[] certDetails = TDCSCertCommonHelper.loadCertDetail(groupId, pids);
        DynamicObject[] exceptionCertDetails = TDCSCertCommonHelper.batchCheckSignStr(certDetails);
        List<Long> unCertDetails = TDCSCertCommonHelper.getUnCertDetailDiffPids(pids, certDetails);
        if (HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(verifyCertMap.get("infoType"))) {
            state = "FORBID";
            if (exceptionCertDetails != null && exceptionCertDetails.length > 0) {
                resultMap.put("EXCEPTID", TDCSCertCommonHelper.getPidByCertDetail(exceptionCertDetails));
            }
            if (unCertDetails != null && unCertDetails.size() > 0) {
                resultMap.put("NEXISTID", unCertDetails);
            }
        } else {
            if (exceptionCertDetails != null && exceptionCertDetails.length > 0) {
                state = "FAIL";
                resultMap.put("EXCEPTID", TDCSCertCommonHelper.getPidByCertDetail(exceptionCertDetails));
            }
            if (unCertDetails != null && unCertDetails.size() > 0) {
                state = "FAIL";
                resultMap.put("NEXISTID", unCertDetails);
            }
            if ("FAIL".equals(state)) {
                errorMessage = MessageFormat.format(ResManager.loadKDString((String)"%s\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TDCSCertCommonHelper_1", (String)"tdc-tdcs-business", (Object[])new Object[0]), HRCertCommonHelper.getGroupName((String)groupId));
            }
        }
        resultMap.put("STATE", state);
        resultMap.put("DATA", verifyCertMap);
        resultMap.put("MSG", errorMessage);
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.verifyCertByPid-2: resultMap={}", (Object)JSON.toJSONString(resultMap));
        return resultMap;
    }

    public static Map<String, Object> verifyCertByPersonId(String bizAppID, String bizObjID, List<Long> personIds) {
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.verifyCertByPersonId: bizAppID = {},bizObjID = {} ,personIds={}", new Object[]{bizAppID, bizObjID, JSON.toJSONString(personIds)});
        Map<Long, Long> personIdPidMap = TDCSCertCommonHelper.convertPidByIds(personIds);
        HashMap<Long, Long> pidPersonIdMap = new HashMap<Long, Long>(personIdPidMap.size());
        for (Map.Entry<Long, Long> entry : personIdPidMap.entrySet()) {
            pidPersonIdMap.put(entry.getValue(), entry.getKey());
        }
        List<Long> pids = personIdPidMap.values().stream().collect(Collectors.toList());
        Map<String, Object> result = TDCSCertCommonHelper.verifyCertByPid(bizAppID, bizObjID, pids);
        ArrayList allPersonId = Lists.newArrayList();
        if (result.containsKey("NEXISTID")) {
            List notExistPids = (List)result.get("NEXISTID");
            allPersonId.addAll(notExistPids);
            result.put("NEXISTID", TDCSCertCommonHelper.convertPersonId(notExistPids, pidPersonIdMap));
        }
        if (result.containsKey("EXCEPTID")) {
            List exceptionPids = (List)result.get("EXCEPTID");
            allPersonId.addAll(exceptionPids);
            result.put("EXCEPTID", TDCSCertCommonHelper.convertPersonId(exceptionPids, pidPersonIdMap));
        }
        if (allPersonId.size() > 0) {
            String personNames = TDCSCertCommonHelper.getPersonName(allPersonId);
            String errorMessage = ResManager.loadKDString((String)"%s\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"TDCSCertCommonHelper_0", (String)"tdc-tdcs-business", (Object[])new Object[]{personNames});
            result.put("MSG", errorMessage);
        }
        return result;
    }

    public static void releaseCertByPersonId(String bizAppID, String bizObjID, List<Long> personIds) {
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.releaseCertByPersonId: bizAppID={},bizObjID={},personIds={}", new Object[]{bizAppID, bizObjID, JSON.toJSONString(personIds)});
        Map<Long, Long> personIdPidMap = TDCSCertCommonHelper.convertPidByIds(personIds);
        List<Long> pids = personIdPidMap.values().stream().collect(Collectors.toList());
        TDCSCertCommonHelper.releaseCertByPid(bizAppID, bizObjID, pids);
    }

    public static void releaseCertByPid(String bizAppID, String bizObjID, List<Long> pids) {
        TDCSCertCommonHelper.validateParameter(bizAppID, bizObjID, pids);
        String groupId = TDCSCertCommonHelper.getGroupId(bizAppID, bizObjID);
        DynamicObject[] certDetails = TDCSCertCommonHelper.loadCertDetail(groupId, pids);
        TDCSCertCommonHelper.releaseCertDetails(certDetails);
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.releaseCertByPid: bizAppID={},bizObjID={},pids={}", new Object[]{bizAppID, bizObjID, JSON.toJSONString(pids)});
    }

    public static Map<Long, Long> convertPidByIds(List<Long> personIds) {
        if (personIds == null) {
            throw new KDBizException("convertPidById parameter personId is null,please check!");
        }
        if (personIds.size() > 100000) {
            throw new KDBizException("convertPidById parameter personId size > 100000,please check!");
        }
        QFilter qFilter = new QFilter("id", "in", personIds);
        DynamicObject[] hrpiPerson = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"id,personindexid", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, Long> pidMap = new HashMap<Long, Long>();
        if (hrpiPerson != null) {
            for (DynamicObject person : hrpiPerson) {
                Long id = person.getLong("id");
                Long personindexid = person.getLong("personindexid");
                pidMap.put(id, personindexid);
            }
        }
        return pidMap;
    }

    public static void updateCertDetailShaStr(String groupId) {
        Map map = HRCertCommonHelper.verifyCertCount((String)groupId);
        if (StringUtils.equals((String)((String)map.get("infoType")), (String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.updateCertDetailShaStr is FORBIDDEN!");
            return;
        }
        DynamicObject[] dynamicObjects = TDCSCertCommonHelper.loadCertDetail(groupId, null);
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject detail : dynamicObjects) {
            String oldShaStr;
            String pidStr = detail.getString("pid");
            String newShaStr = TDCSCertCommonHelper.generateSignStr(pidStr, groupId);
            if (StringUtils.equals((String)newShaStr, (String)(oldShaStr = detail.getString("shastr")))) continue;
            detail.set("shastr", (Object)newShaStr);
            detail.set("modifytime", (Object)new Date());
            rows.add(detail);
        }
        if (!rows.isEmpty()) {
            HRTI_CERTHELPER.updateDatas(rows.toArray(new DynamicObject[rows.size()]));
        }
        logger.info("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.updateCertDetailShaStr count is {}", (Object)rows.size());
    }

    public static String getPersonName(List<Long> personIds) {
        StringBuilder names = new StringBuilder();
        QFilter qFilter = new QFilter("id", "in", personIds);
        DynamicObject[] personObjs = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"id,name,number", (QFilter[])qFilter.toArray());
        if (personObjs != null && personObjs.length > 0) {
            for (int i = 0; i < personObjs.length; ++i) {
                names.append(personObjs[i].getString("name"));
                if (i == personObjs.length - 1) continue;
                names.append("\u3001");
            }
        }
        return names.toString();
    }

    public static Map<Long, DynamicObject> getPersonByPids(List<Long> pids) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(pids.size());
        QFilter qFilter = new QFilter("personindexid", "in", pids);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject[] personObjs = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"id,personindexid,name,number", (QFilter[])qFilter.toArray());
        if (personObjs != null && personObjs.length > 0) {
            for (DynamicObject dynamicObject : personObjs) {
                result.put(dynamicObject.getLong("personindexid"), dynamicObject);
            }
        }
        return result;
    }

    public static String getExceptionMsg(String name) {
        return ResManager.loadKDString((String)"%s\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"TDCSCertCommonHelper_3", (String)"tdc-tdcs-business", (Object[])new Object[]{name});
    }

    private static void validateParameter(String bizAppID, String bizObjID, List<Long> pids) {
        if (pids == null || pids.size() == 0) {
            throw new KDBizException("Call parameter pids is null or empty,please check!");
        }
    }

    private static String getGroupId(String appId, String formId) {
        return HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
    }

    private static String generateSignStr(String pidStr, String groupId) {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String salt = MessageFormat.format("{0}-{1}", groupId, accountId);
        return HRBizCertSignHelper.getSignData((String)pidStr, (String)salt);
    }

    private static DynamicObject[] batchCheckSignStr(DynamicObject[] certDetails) {
        DynamicObject[] exceptionCertDetails = null;
        if (certDetails != null) {
            ArrayList<DynamicObject> exceptionCertList = new ArrayList<DynamicObject>(certDetails.length);
            for (DynamicObject certDetail : certDetails) {
                if (TDCSCertCommonHelper.checkSignStr(certDetail)) continue;
                exceptionCertList.add(certDetail);
            }
            exceptionCertDetails = exceptionCertList.toArray(new DynamicObject[0]);
        }
        return exceptionCertDetails;
    }

    private static boolean checkSignStr(DynamicObject certDetail) {
        long pid = certDetail.getLong("pid");
        String pidStr = String.valueOf(pid);
        String groupId = certDetail.getString("groupId");
        String oldShaStr = certDetail.getString("shastr");
        String newShaStr = TDCSCertCommonHelper.generateSignStr(pidStr, groupId);
        logger.error("kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper.checkSignStr pid={}", (Object)pid);
        return StringUtils.equals((String)newShaStr, (String)oldShaStr);
    }

    private static DynamicObject[] loadCertDetail(String groupId, List<Long> pids) {
        String selectProperties = "id,pid,groupid,shastr,holdtime,modifytime";
        QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
        if (pids != null && pids.size() > 0) {
            QFilter pidFilter = new QFilter("pid", "in", pids);
            QFilter[] qFilters = new QFilter[]{pidFilter, groupFilter};
            return HRTI_CERTHELPER.query(selectProperties, qFilters);
        }
        DynamicObject[] objects = HRTI_CERTHELPER.query(selectProperties, groupFilter.toArray());
        return objects;
    }

    private static void batchInsertCertDetails(List<Long> pids, String groupId) {
        if (pids != null && pids.size() > 0) {
            long[] pkIds = IDService.get().genLongIds(pids.size());
            DynamicObject[] certDetails = new DynamicObject[pids.size()];
            for (int i = 0; i < pids.size(); ++i) {
                DynamicObject certDetail = HRTI_CERTHELPER.generateEmptyDynamicObject();
                Date currentDate = new Date();
                certDetail.set("id", (Object)pkIds[i]);
                certDetail.set("pid", (Object)pids.get(i));
                certDetail.set("shastr", (Object)TDCSCertCommonHelper.generateSignStr(String.valueOf(pids.get(i)), groupId));
                certDetail.set("groupid", (Object)groupId);
                certDetail.set("holdtime", (Object)currentDate);
                certDetail.set("modifytime", (Object)currentDate);
                certDetails[i] = certDetail;
            }
            HRTI_CERTHELPER.save(certDetails);
        }
    }

    private static void batchUpdateUsedCertDetails(DynamicObject[] certDetails) {
        if (certDetails != null && certDetails.length > 0) {
            for (DynamicObject certDetail : certDetails) {
                certDetail.set("modifytime", (Object)new Date());
            }
            HRTI_CERTHELPER.updateDatas(certDetails);
        }
    }

    private static void releaseCertDetails(DynamicObject[] certDetails) {
        if (certDetails != null && certDetails.length > 0) {
            List preDeleteDetailPks = Arrays.stream(certDetails).map(row -> row.getLong("id")).collect(Collectors.toList());
            HRTI_CERTHELPER.delete(preDeleteDetailPks.toArray());
        }
    }

    private static List<Long> getUnCertDetailDiffPids(List<Long> sourcePids, DynamicObject[] existPids) {
        ArrayList<Long> resultPidList = new ArrayList<Long>(sourcePids);
        resultPidList.removeAll(TDCSCertCommonHelper.getPidByCertDetail(existPids));
        return resultPidList;
    }

    private static List<Long> getPidByCertDetail(DynamicObject[] certDetail) {
        if (certDetail == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(certDetail).map(row -> row.getLong("pid")).collect(Collectors.toList());
    }

    private static List<Long> convertPersonId(List<Long> pids, Map<Long, Long> pidPersonIdMap) {
        List<Long> list = Collections.emptyList();
        if (pids != null && pids.size() > 0) {
            list = new ArrayList<Long>(pids.size());
            for (Long row : pids) {
                list.add(pidPersonIdMap.get(row));
            }
        }
        return list;
    }
}

