/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.queryhelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.model.smartsearch.scene.SearchCustomFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchSceneBo;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.tdc.tdcs.bussiness.application.external.ExtSearchService;

public class SearchFilterSchemeQueryHelper {
    private static final HRBaseServiceHelper FILTER_SCHEME_HELPER = new HRBaseServiceHelper("tdcs_searchfilterscheme");

    public static List<Map<String, Object>> getMyFilterSchemes(long sceneId, long userId) {
        ArrayList resultList;
        block7: {
            Object[] result = FILTER_SCHEME_HELPER.query("id,name,filter,filter_tag", new QFilter[]{new QFilter("sceneid", "=", (Object)sceneId), new QFilter("user", "=", (Object)userId)}, "createtime desc");
            resultList = Lists.newArrayList();
            if (!HRArrayUtils.isNotEmpty((Object[])result)) break block7;
            HrApiResponse<SearchSceneBo> searchScene = ExtSearchService.querySearchScene(sceneId);
            if (searchScene.isSuccess()) {
                List searchFilterList = ((SearchSceneBo)searchScene.getData()).getSearchFilterList();
                Map<String, List> fieldFilterMapping = searchFilterList.stream().filter(item -> !Objects.isNull(item.getSearchCustomFilterList())).collect(Collectors.toMap(SearchFilterBo::getFieldAlias, SearchFilterBo::getSearchCustomFilterList, (v1, v2) -> v1));
                for (Object dy : result) {
                    LinkedHashMap dataMap = Maps.newLinkedHashMap();
                    dataMap.put("schemeNameId", String.valueOf(dy.getLong("id")));
                    dataMap.put("schemeName", dy.getString("name"));
                    List filterList = (List)SerializationUtils.fromJsonString((String)dy.getString("filter_tag"), List.class);
                    List currFields = searchFilterList.stream().map(SearchFilterBo::getFieldAlias).collect(Collectors.toList());
                    filterList.removeIf(item -> !currFields.contains((String)item.get("number")));
                    Iterator iterator = filterList.iterator();
                    while (iterator.hasNext()) {
                        List searchCustomFilterBos;
                        Map next = (Map)iterator.next();
                        String fieldKey = (String)next.get("number");
                        String type = (String)next.get("type");
                        List selectedIds = (List)next.get("selected");
                        if (Objects.isNull(fieldKey)) continue;
                        if (type.equals("2")) {
                            searchCustomFilterBos = fieldFilterMapping.get(fieldKey);
                            if (CollectionUtils.isEmpty((Collection)searchCustomFilterBos)) {
                                iterator.remove();
                                continue;
                            }
                            List valueList = searchCustomFilterBos.stream().map(SearchCustomFilterBo::getKey).collect(Collectors.toList());
                            selectedIds.removeIf(item -> !valueList.contains((String)item.get("id")));
                            if (!HRCollUtil.isEmpty((Collection)selectedIds)) continue;
                            iterator.remove();
                            continue;
                        }
                        if (!type.equals("1") || CollectionUtils.isEmpty((Collection)(searchCustomFilterBos = fieldFilterMapping.get(fieldKey)))) continue;
                        iterator.remove();
                    }
                    dataMap.put("schemeSelectedFilter", filterList);
                    resultList.add(dataMap);
                }
            } else {
                for (Object dy : result) {
                    LinkedHashMap dataMap = Maps.newLinkedHashMap();
                    dataMap.put("schemeNameId", String.valueOf(dy.getLong("id")));
                    dataMap.put("schemeName", dy.getString("name"));
                    List filterList = (List)SerializationUtils.fromJsonString((String)dy.getString("filter_tag"), List.class);
                    dataMap.put("schemeSelectedFilter", filterList);
                    resultList.add(dataMap);
                }
            }
        }
        return resultList;
    }

    public static boolean isExists(Long schemeId, long sceneId, long userId, String name) {
        ArrayList qFilters = Lists.newArrayList();
        if (!Objects.isNull(schemeId)) {
            qFilters.add(new QFilter("id", "!=", (Object)schemeId));
        }
        qFilters.add(new QFilter("sceneid", "=", (Object)sceneId));
        qFilters.add(new QFilter("user", "=", (Object)userId));
        qFilters.add(new QFilter("name", "=", (Object)name));
        return FILTER_SCHEME_HELPER.isExists(qFilters.toArray(new QFilter[0]));
    }

    public static boolean isExists(long id) {
        return FILTER_SCHEME_HELPER.isExists((Object)id);
    }
}

