/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.queryhelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.enums.talentpool.InPoolStatusEnum;

public class TalentPoolQueryHelper {
    private static final Log LOG = LogFactory.getLog(TalentPoolQueryHelper.class);
    private static final HRBaseServiceHelper RESERVE_TALENT_HELPER = new HRBaseServiceHelper("tdcs_reservetalent");
    private static final HRBaseServiceHelper TALENT_POOL_HELPER = new HRBaseServiceHelper("tdcs_talentpool");
    private static final HRBaseServiceHelper ENTRY_EXIT_POOL_HELPER = new HRBaseServiceHelper("talp_entryexitpoolbase");
    private static final HRBaseServiceHelper POOL_TYPE_HELPER = new HRBaseServiceHelper("tdcs_talentpooltype");

    public static DynamicObject queryOneReserveTalentById(String selectFields, Object reserveTalentId) {
        return RESERVE_TALENT_HELPER.queryOriginalOne(selectFields, reserveTalentId);
    }

    public static DynamicObject[] queryReserveTalentByPoolIds(String selectFields, List<Long> poolIds, QFilter dataRuleFilter) {
        return RESERVE_TALENT_HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("talentpool", "in", poolIds), dataRuleFilter});
    }

    public static DynamicObject queryReserveTalentByIntoBillNo(String intoBillNo) {
        return RESERVE_TALENT_HELPER.queryOriginalOne("inpooltime", new QFilter[]{new QFilter("intobillno", "=", (Object)intoBillNo)});
    }

    public static DynamicObject[] queryReserveTalentByPkValue(String selectFields, List<Object> pkValues) {
        return RESERVE_TALENT_HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", pkValues)});
    }

    public static DynamicObject[] queryReserveTalentByIds(String selectFields, List<Long> ids) {
        return RESERVE_TALENT_HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static DynamicObject queryTalentPoolInfoById(String selectFields, Long id) {
        return TALENT_POOL_HELPER.queryOriginalOne(selectFields, (Object)id);
    }

    public static DynamicObject[] queryTalentPoolInfoByIds(String selectFields, List<Long> ids) {
        return TALENT_POOL_HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static DynamicObject queryTalentPoolById(String selectFields, Long id) {
        return TALENT_POOL_HELPER.queryOne(selectFields, (Object)id);
    }

    public static Map<String, Object> countEntryExitPoolNumber(List<Long> poolIds) {
        Map resultMap = null;
        try {
            resultMap = (Map)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"countEntryExitPoolNumber", (Object[])new Object[]{poolIds});
        }
        catch (Exception exception) {
            LOG.error("countEntryExitPoolNumber###exception", (Throwable)exception);
        }
        LOG.info("countEntryExitPoolNumber###poolIds:{},resultMap:{}", poolIds, resultMap);
        return resultMap;
    }

    public static int countPendingRecommends(List<Long> poolIds) {
        int pendingBillNumber = 0;
        try {
            pendingBillNumber = (Integer)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"countPendingRecommends", (Object[])new Object[]{poolIds});
        }
        catch (Exception exception) {
            LOG.error("countPendingRecommends###exception", (Throwable)exception);
        }
        LOG.info("countPendingRecommends###poolIds:{},pendingBills:{}", poolIds, (Object)pendingBillNumber);
        return pendingBillNumber;
    }

    public static void poolPermChange(List<Long> poolIds) {
        try {
            LOG.info("poolPermChange###poolIds:{},", poolIds);
            HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"poolPermChange", (Object[])new Object[]{poolIds});
        }
        catch (Exception exception) {
            LOG.error("poolPermChange###exception", (Throwable)exception);
        }
    }

    public static DynamicObject queryOriginalOneByBillNo(String selectField, String billNo) {
        return ENTRY_EXIT_POOL_HELPER.queryOriginalOne(selectField, new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
    }

    public static boolean isExistsInPoolReserveTalent(long talentPoolId, long employeeId) {
        return RESERVE_TALENT_HELPER.isExists(new QFilter[]{new QFilter("employee", "=", (Object)employeeId), new QFilter("talentpool", "=", (Object)talentPoolId), new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.IN_POOL.getStatus())});
    }

    public static boolean reserveTalentIsOutPool(long reserveTalentId) {
        return RESERVE_TALENT_HELPER.isExists(new QFilter[]{new QFilter("id", "=", (Object)reserveTalentId), new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.OUT_POOL.getStatus())});
    }

    public static boolean poolIsFull(long talentPoolId) {
        DynamicObject dy = TALENT_POOL_HELPER.queryOriginalOne("islimitpersonnum,personnumlimit,inpoolnum", (Object)talentPoolId);
        if (Objects.isNull(dy)) {
            return false;
        }
        String isLimitPersonNum = dy.getString("islimitpersonnum");
        if (HRStringUtils.equals((String)isLimitPersonNum, (String)"1")) {
            int inPoolNum;
            int personNumLimit = dy.getInt("personnumlimit");
            return personNumLimit <= (inPoolNum = dy.getInt("inpoolnum"));
        }
        return false;
    }

    public static DynamicObject[] queryInPoolReserveTalentByRecommendIds(String selectFields, Set<Long> inPoolRecommendIds) {
        return RESERVE_TALENT_HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("entryentity.recommendid", "in", inPoolRecommendIds), new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.IN_POOL.getStatus())});
    }

    public static List<Long> queryPoolIds(Long orgId) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tdcs_talentpool", (Long)orgId);
        Object[] poolData = TALENT_POOL_HELPER.query("id", new QFilter[]{baseDataFilter, new QFilter("enable", "=", (Object)"1")});
        if (HRArrayUtils.isEmpty((Object[])poolData)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(poolData).map(item -> item.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> queryPoolIdsByDataRuleFilter(Long orgId, QFilter dataRuleFilter) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tdcs_talentpool", (Long)orgId);
        Object[] poolData = TALENT_POOL_HELPER.query("id", new QFilter[]{baseDataFilter, dataRuleFilter, new QFilter("enable", "=", (Object)"1")});
        if (HRArrayUtils.isEmpty((Object[])poolData)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(poolData).map(item -> item.getLong("id")).collect(Collectors.toList());
    }

    public static DynamicObject[] queryInPoolReserveTalentByPoolIds(String selectFields, List<Long> poolIds) {
        return RESERVE_TALENT_HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("talentpool", "in", poolIds), new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.IN_POOL.getStatus())});
    }

    public static DynamicObject[] queryReserveTalentByDataRuleQFilter(String selectFields, long orgId, List<Long> poolIds, QFilter dataRuleFilter) {
        ArrayList qFilters = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(poolIds)) {
            qFilters.add(new QFilter("talentpool", "in", poolIds));
        }
        Collections.addAll(qFilters, new QFilter("org", "=", (Object)orgId), dataRuleFilter, new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.IN_POOL.getStatus()));
        return RESERVE_TALENT_HELPER.queryOriginalArray(selectFields, qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] queryOutPoolReserveTalentByPoolIds(String selectFields, List<Long> poolIds) {
        return RESERVE_TALENT_HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("talentpool", "in", poolIds), new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.OUT_POOL.getStatus())});
    }

    public static int countInPoolTalentByPoolId(long poolId) {
        return RESERVE_TALENT_HELPER.count("tdcs_reservetalent", new QFilter[]{new QFilter("talentpool", "=", (Object)poolId), new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.IN_POOL.getStatus())});
    }

    public static DynamicObject[] queryNameByTypeAndIds(String helperFormId, Set<Long> typeIds) {
        if ("tdcs_intopooltype".equals(helperFormId) || "tdcs_outofpooltype".equals(helperFormId)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(helperFormId);
            return helper.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", typeIds)});
        }
        return new DynamicObject[0];
    }

    public static DynamicObject queryPoolTypeById(String selectField, long id) {
        return POOL_TYPE_HELPER.queryOriginalOne(selectField, (Object)id);
    }

    public static DynamicObject[] queryPoolByTypeIds(String selectField, List<Long> typeIds, List<Long> orgIds) {
        ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("group", "in", typeIds)});
        if (!CollectionUtils.isEmpty(orgIds)) {
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"tdcs_talentpool", orgIds, (boolean)true));
        }
        return TALENT_POOL_HELPER.queryOriginalArray(selectField, qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] queryPoolByFilters(String selectField, List<QFilter> qFilters, List<Long> orgIds) {
        if (!CollectionUtils.isEmpty(orgIds)) {
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"tdcs_talentpool", orgIds, (boolean)true));
        }
        return TALENT_POOL_HELPER.queryOriginalArray(selectField, qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] includeLowLevelPools() {
        Object[] poolDys = TALENT_POOL_HELPER.query("id", new QFilter[]{new QFilter("entryentity.includelowlevel", "=", (Object)"1")});
        if (HRArrayUtils.isNotEmpty((Object[])poolDys)) {
            Set poolIds = Arrays.stream(poolDys).map(item -> item.getLong("id")).collect(Collectors.toSet());
            return TALENT_POOL_HELPER.query("id,entryentity,entryentity.applyadminorg,entryentity.includelowlevel", new QFilter[]{new QFilter("id", "in", poolIds)});
        }
        return new DynamicObject[0];
    }
}

