/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.search;

import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.tdc.tdcs.search.ITalentSearchExtendService;
import kd.tdc.tdcs.common.bo.talentsearch.SearchPage;
import kd.tdc.tdcs.common.bo.talentsearch.SearchResultVO;

public class SearchBuryPointService {
    private static final Log logger = LogFactory.getLog(SearchBuryPointService.class);
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String KEY_WORD = "keyword";
    public static final String PAGE_NUM = "pagenum";
    public static final String DATE_TIME = "datetime";
    public static final String CLIENT = "client";
    public static final String RESULT_COUNT = "resultcount";
    public static final String SEARCH_ID = "searchid";

    public static void search(SearchPage<SearchResultVO> page, IFormView view) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, ITalentSearchExtendService.class, (String)"kd.sdk.tdc.tdcs.search.ITalentSearchExtendService", null);
        IPageCache pageCache = view.getPageCache();
        String searchId = kd.bos.id.ID.genStringId();
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                RequestContext requestContext = RequestContext.getOrCreate();
                map.put(ID, requestContext.getCurrUserId());
                map.put(NAME, requestContext.getUserName());
                map.put(KEY_WORD, page.getSearchParam().getSearchContent());
                map.put(PAGE_NUM, page.getPageindex());
                map.put(DATE_TIME, new Date());
                map.put(CLIENT, requestContext.getClient());
                map.put(RESULT_COUNT, page.getDatacount());
                plugin.search(map);
                pageCache.put(SEARCH_ID, searchId);
                logger.info("SearchBuryPointInterface->search,map:{},searchId:{}", map, (Object)searchId);
            }
            return null;
        });
    }

    public static void viewDetail(long empId, IFormView view) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, ITalentSearchExtendService.class, (String)"kd.sdk.tdc.tdcs.search.ITalentSearchExtendService", null);
        IPageCache pageCache = view.getPageCache();
        String searchIdStr = pageCache.get(SEARCH_ID);
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                plugin.viewDetail(searchIdStr, Long.valueOf(empId));
                logger.info("SearchBuryPointInterface->viewDetail,searchIdStr:{},empId:{}", (Object)searchIdStr, (Object)empId);
            }
            return null;
        });
    }
}

