/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CommOrgApplicationService;
import kd.tdc.tdcs.bussiness.domain.certgroup.service.CertGroupDomainService;
import kd.tdc.tdcs.bussiness.domain.commorguser.enums.CommUserStatusEnum;
import kd.tdc.tdcs.bussiness.domain.commorguser.service.CommOrgUserDomainService;

public class CommOrgUserTask
extends AbstractTask {
    private final CommOrgApplicationService commOrgApplicationService = ServiceFactory.getService(CommOrgApplicationService.class);
    private final CommOrgUserDomainService commOrgUserDomainService = ServiceFactory.getService(CommOrgUserDomainService.class);
    private final CertGroupDomainService certGroupDomainService = ServiceFactory.getService(CertGroupDomainService.class);
    private static final Log log = LogFactory.getLog(CommOrgUserTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date currentDate = new Date();
        this.commUserStatusEffect(currentDate);
        this.commUserStatusExit(currentDate);
    }

    private void commUserStatusEffect(Date currentDate) {
        DynamicObject[] needEffectCommUsers = this.commOrgApplicationService.getNeedEffectCommUser(currentDate);
        if (needEffectCommUsers == null || needEffectCommUsers.length == 0) {
            return;
        }
        ArrayList<DynamicObject> needEffectCommUserList = new ArrayList<DynamicObject>(needEffectCommUsers.length);
        for (DynamicObject needEffectCommUser : needEffectCommUsers) {
            needEffectCommUser.set("userstatus", (Object)CommUserStatusEnum.EFFECT.getNumber());
            needEffectCommUserList.add(needEffectCommUser);
        }
        this.commOrgUserDomainService.updateDatas(needEffectCommUserList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commUserStatusExit(Date currentDate) {
        try (TXHandle txhandle = TX.required();){
            DynamicObject[] commUsers = this.commOrgApplicationService.getNeedExpireCommUser(currentDate);
            if (commUsers == null || commUsers.length == 0) {
                return;
            }
            this.commOrgApplicationService.commUserStatusExit(currentDate, commUsers);
        }
    }
}

