/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.task.coordination;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.coordination.service.CoordSubscriberDomainService;
import kd.tdc.tdcs.bussiness.domain.coordination.service.CoordinationMsgDomainService;
import kd.tdc.tdcs.bussiness.domain.coordination.service.CoordinationTaskDomainService;
import kd.tdc.tdcs.bussiness.task.coordination.CoordinationTask;
import kd.tdc.tdcs.common.constants.coordination.CoordExecuteTypeEnum;
import kd.tdc.tdcs.common.constants.coordination.CoordTaskStatusEnum;

public class CoordinationCornTask
extends AbstractTask {
    private final CoordinationTaskDomainService coordinationTaskDomainService = ServiceFactory.getService(CoordinationTaskDomainService.class);
    private final CoordinationMsgDomainService coordinationMsgDomainService = ServiceFactory.getService(CoordinationMsgDomainService.class);
    private final CoordSubscriberDomainService coordSubscriberDomainService = ServiceFactory.getService(CoordSubscriberDomainService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] msgList = this.coordinationMsgDomainService.getNotConsumedMsg();
        if (msgList != null && msgList.length > 0) {
            this.createTask(msgList);
        }
        int overTime = 2;
        this.coordinationTaskDomainService.dealWithOverTimeTask(overTime);
        DynamicObject[] taskList = this.coordinationTaskDomainService.getTaskList();
        if (taskList == null || taskList.length < 1) {
            return;
        }
        ExecutorService executorService = CoordinationTaskDomainService.EXECUTOR_SERVICE;
        for (DynamicObject taskDy : taskList) {
            executorService.submit(new CoordinationTask(taskDy, CoordExecuteTypeEnum.SCHEDULED_EXECUTION.getType()));
        }
    }

    private void createTask(DynamicObject[] msgList) {
        ORM orm = ORM.create();
        for (DynamicObject msgDy : msgList) {
            DynamicObject[] taskDys;
            DynamicObject[] coordSubscriberList;
            String msgSubNo = msgDy.getString("msgsubno");
            if (HRStringUtils.isEmpty((String)msgSubNo) || (coordSubscriberList = this.coordSubscriberDomainService.getCoordSubscriberList(Collections.singletonList(msgSubNo))) == null || coordSubscriberList.length < 1 || (taskDys = this.coordinationTaskDomainService.getTaskListBySubAndMsg(msgDy, coordSubscriberList)).length == coordSubscriberList.length) continue;
            Set taskSubscriberIdSet = Arrays.stream(taskDys).map(dy -> dy.getLong("coordsubscriber")).collect(Collectors.toSet());
            Set subscriberIdSet = Arrays.stream(coordSubscriberList).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            Set<Long> noTaskSubIdSet = subscriberIdSet.stream().filter(e -> !taskSubscriberIdSet.contains(e)).collect(Collectors.toSet());
            if (noTaskSubIdSet.size() < 1) continue;
            long[] taskIds = this.getLongIds(orm, noTaskSubIdSet);
            List noTaskSubList = Arrays.stream(coordSubscriberList).filter(dy -> noTaskSubIdSet.contains(dy.getLong("id"))).collect(Collectors.toList());
            for (int i = 0; i < noTaskSubList.size(); ++i) {
                this.coordinationTaskDomainService.createTask(msgDy, (DynamicObject)noTaskSubList.get(i), taskIds[i], CoordTaskStatusEnum.TO_BE_EXECUTE.getStatus());
            }
        }
    }

    private long[] getLongIds(ORM orm, Set<Long> noTaskSubIdSet) {
        return orm.genLongIds("tdcs_coordinationtask", noTaskSubIdSet.size());
    }
}

