/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.task.coordination;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.coordination.service.CoordinationTaskDomainService;
import kd.tdc.tdcs.bussiness.domain.coordination.service.CoordinationValidatorDomainService;
import kd.tdc.tdcs.common.constants.coordination.CoordExecuteTypeEnum;
import kd.tdc.tdcs.common.constants.coordination.CoordTaskStatusEnum;

public class CoordinationTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(CoordinationTask.class);
    private final CoordinationValidatorDomainService coordinationValidatorDomainService = ServiceFactory.getService(CoordinationValidatorDomainService.class);
    private final CoordinationTaskDomainService coordinationTaskDomainService = ServiceFactory.getService(CoordinationTaskDomainService.class);
    private final RequestContext context = RequestContext.get();
    private DynamicObject coordinationMsg;
    private DynamicObject coordSubscriber;
    private long taskId;
    private DynamicObject taskDy;
    private final String execType;

    public CoordinationTask(DynamicObject coordinationMsg, DynamicObject coordSubscriber, long taskId, String execType) {
        this.coordinationMsg = coordinationMsg;
        this.coordSubscriber = coordSubscriber;
        this.taskId = taskId;
        this.execType = execType;
    }

    public CoordinationTask(DynamicObject taskDy, String execType) {
        this.taskDy = taskDy;
        this.execType = execType;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.context);
        if (HRStringUtils.isEmpty((String)this.execType)) {
            return;
        }
        if (HRStringUtils.equals((String)this.execType, (String)CoordExecuteTypeEnum.SYSTEM_EXECUTION.getType())) {
            this.systemExecute(this.execType);
        } else if (HRStringUtils.equals((String)this.execType, (String)CoordExecuteTypeEnum.SCHEDULED_EXECUTION.getType())) {
            this.scheduledExecute(this.execType);
        } else if (HRStringUtils.equals((String)this.execType, (String)CoordExecuteTypeEnum.MANUAL_EXECUTION.getType())) {
            this.coordinationTaskDomainService.execute(this.taskDy, this.execType);
        }
    }

    private void scheduledExecute(String execType) {
        if (ObjectUtils.isEmpty((Object)this.taskDy)) {
            return;
        }
        Map<String, String> validationResult = this.coordinationValidatorDomainService.validate(this.taskDy, execType);
        if (!Boolean.parseBoolean(validationResult.get("result"))) {
            return;
        }
        this.coordinationTaskDomainService.execute(this.taskDy, execType);
    }

    private void systemExecute(String execType) {
        if (ObjectUtils.isEmpty((Object)this.coordinationMsg) || ObjectUtils.isEmpty((Object)this.coordSubscriber) || this.taskId == 0L) {
            return;
        }
        String taskStatus = CoordTaskStatusEnum.EXECUTING.getStatus();
        String execMode = HRDyObjectPropUtil.getString((DynamicObject)this.coordSubscriber, (String)"execmode");
        if ("20".equals(execMode)) {
            taskStatus = CoordTaskStatusEnum.TO_BE_EXECUTE.getStatus();
        }
        DynamicObject taskDy = this.coordinationTaskDomainService.createTask(this.coordinationMsg, this.coordSubscriber, this.taskId, taskStatus);
        if ("20".equals(execMode)) {
            return;
        }
        Map<String, String> validationResult = this.coordinationValidatorDomainService.validate(taskDy, execType);
        if (!Boolean.parseBoolean(validationResult.get("result"))) {
            return;
        }
        this.coordinationTaskDomainService.execute(taskDy, execType);
    }
}

