/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.task.dataupgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.certgroup.service.CertGroupDomainService;
import kd.tdc.tdcs.common.util.CommUtils;

public class UpgradeCertGroupEntryUniqueKeyTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UpgradeCertGroupEntryUniqueKeyTask.class);
    private final CertGroupDomainService certGroupDomainService = ServiceFactory.getService(CertGroupDomainService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        ArrayList qFiltersList = Lists.newArrayList();
        Object[] dynamicObjects = this.certGroupDomainService.queryCerGroupByAnyFilter("id,certcentry,certcentry.ctteeper,certcentry.membername,certcentry.membernumber,certcentry.source,certcentry.isemp,certcentry.uniquekey", qFiltersList);
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObjectCollection certcEntry = dynamicObjects[i].getDynamicObjectCollection("certcentry");
            if (HRCollUtil.isEmpty((Collection)certcEntry)) continue;
            for (DynamicObject dynamicObject : certcEntry) {
                if (dynamicObject.getBoolean("isemp")) {
                    String memberName = dynamicObject.getString("membername");
                    String memberNumber = dynamicObject.getString("membernumber");
                    if (HRStringUtils.isEmpty((String)memberName) || HRStringUtils.isEmpty((String)memberNumber)) continue;
                    dynamicObject.set("uniquekey", (Object)CommUtils.appendStr((String[])new String[]{dynamicObject.getString("membername"), ";", dynamicObject.getString("membernumber")}));
                    continue;
                }
                DynamicObject ctteeperObj = dynamicObject.getDynamicObject("ctteeper");
                if (HRObjectUtils.isEmpty((Object)ctteeperObj)) continue;
                dynamicObject.set("uniquekey", (Object)CommUtils.appendStr((String[])new String[]{ctteeperObj.getString("name"), ";", ctteeperObj.getString("phonenum")}));
            }
        }
        this.certGroupDomainService.saveCerGroup((DynamicObject[])dynamicObjects);
    }
}

