/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.task.dataupgrade;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.certgroup.service.CertGroupDomainService;
import kd.tdc.tdcs.common.constants.CertificationGroupConstants;

public class UpgradeCertGroupEntryUserInfoTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UpgradeCertGroupEntryUserInfoTask.class);
    private final CertGroupDomainService certGroupDomainService = ServiceFactory.getService(CertGroupDomainService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String selectFields = "id,isemp,person,ctteeper,membername,membernumber,boid";
        QFilter nameQFilter = new QFilter("membername", "=", (Object)"");
        DynamicObject[] certGroupEntry = this.certGroupDomainService.queryCertGroupEntry(selectFields, new QFilter[]{nameQFilter});
        LOGGER.info("CertGroupDomainService.certGroupEntry.length:", (Object)certGroupEntry.length);
        Map<Long, DynamicObject> formattedRows = this.completeCertGroupEntry(certGroupEntry);
        this.saveCertGroupEntryByMaster(certGroupEntry, formattedRows);
    }

    private Map<Long, DynamicObject> completeCertGroupEntry(DynamicObject[] certGroupEntry) {
        List<DynamicObject> ctteeList = Arrays.stream(certGroupEntry).filter(row -> row.get("ctteeper") != null).collect(Collectors.toList());
        LOGGER.info("CertGroupDomainService.ctteeList.size:", (Object)ctteeList.size());
        ctteeList.forEach(row -> {
            String isEmp = row.getString("isemp");
            if (HRStringUtils.equals((String)isEmp, (String)"1")) {
                row.set("person", (Object)row.getDynamicObject("ctteeper.person"));
            } else {
                row.set("membername", (Object)row.getString("ctteeper.name"));
                row.set("membernumber", (Object)row.getString("ctteeper.number"));
            }
        });
        List<DynamicObject> employeeList = Arrays.stream(certGroupEntry).filter(row -> row.get("person") != null).collect(Collectors.toList());
        LOGGER.info("CertGroupDomainService.employeeList.size:", (Object)ctteeList.size());
        employeeList.forEach(row -> {
            row.set("membername", (Object)row.getString("person.person.name"));
            row.set("membernumber", (Object)row.getString("person.person.number"));
        });
        return Arrays.stream(certGroupEntry).collect(Collectors.toMap(row -> row.getLong("id"), row -> row));
    }

    private void saveCertGroupEntryByMaster(DynamicObject[] certGroupEntry, Map<Long, DynamicObject> formattedRows) {
        DynamicObject[] cerGroups;
        List cerGroupIds = Arrays.stream(certGroupEntry).map(row -> row.getLong("boid")).distinct().collect(Collectors.toList());
        LOGGER.info("CertGroupDomainService.cerGroupIds.size:", (Object)cerGroupIds.size());
        String groupSelectFields = String.join((CharSequence)",", "certcentry.id", "certcentry.person", "certcentry.membername", "certcentry.membernumber");
        QFilter idQFilter = new QFilter("id", "in", cerGroupIds);
        for (DynamicObject cerGroup : cerGroups = this.certGroupDomainService.queryCerGroup(groupSelectFields, new QFilter[]{idQFilter})) {
            DynamicObjectCollection memberEntry = cerGroup.getDynamicObjectCollection("certcentry");
            memberEntry.forEach(row -> {
                Long entryId = row.getLong("id");
                if (formattedRows.get(entryId) != null) {
                    DynamicObject formattedRow = (DynamicObject)formattedRows.get(entryId);
                    for (String copyField : CertificationGroupConstants.COPY_FIELDS) {
                        row.set(copyField, formattedRow.get(copyField));
                    }
                }
            });
        }
        this.certGroupDomainService.saveCerGroup(cerGroups);
    }
}

