/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.opplugin.bankacct;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAccountImportOp
extends BatchImportPlugin {
    protected static final String NEW = "new";
    protected static final String OVERRIDE = "override";
    protected static final String OVERRIDE_NEW = "overridenew";
    private static final Log logger = LogFactory.getLog(BankAccountImportOp.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Map options = this.ctx.getOption();
        this.dealBillDatas(billdatas, logger, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealBillDatas(List<ImportBillData> billdatas, ImportLogger logger, Map<String, Object> options) {
        Iterator<ImportBillData> it = billdatas.iterator();
        HashSet<String> orgNumberSet = new HashSet<String>(10);
        for (ImportBillData importBillData : billdatas) {
            JSONObject jsonObject = (JSONObject)importBillData.getData().get((Object)"company");
            String orgNumber = jsonObject.getString("number");
            orgNumberSet.add(orgNumber);
        }
        if (EmptyUtil.isEmpty(orgNumberSet)) {
            return;
        }
        QFilter orgQFilter = new QFilter("number", "in", orgNumberSet);
        DynamicObjectCollection bosOrgDc = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])orgQFilter.toArray());
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        HashMap<String, Long> idNumberMap = new HashMap<String, Long>(10);
        for (DynamicObject org : bosOrgDc) {
            Long id = org.getLong("id");
            String number = org.getString("number");
            orgIds.add(id);
            idNumberMap.put(number, id);
        }
        AppParam param = new AppParam();
        param.setViewType("08");
        param.setAppId(AppMetadataCache.getAppInfo((String)"am").getId());
        Map stringMapMap = SystemParamServiceHelper.loadBatchAppParameterByOrg((AppParam)param, orgIds);
        while (it.hasNext()) {
            String message = null;
            ImportBillData rowdata = it.next();
            JSONObject data = rowdata.getData();
            try {
                boolean isEquals;
                String bankFunc;
                boolean isEquals2;
                String orgNumber;
                Long orgId;
                Map paramMap;
                Object am001;
                JSONObject companyObject = (JSONObject)data.get((Object)"company");
                if (EmptyUtil.isNoEmpty((Object)companyObject) && "1".equals(am001 = (paramMap = (Map)stringMapMap.get(String.valueOf(orgId = (Long)idNumberMap.get(orgNumber = companyObject.getString("number"))))).get("am001"))) {
                    message = String.format(ResManager.loadKDString((String)"\u6839\u636e\u7cfb\u7edf\u53c2\u6570\u8bbe\u5b9a\uff0c\u6240\u6307\u5b9a\u7684\u7533\u8bf7\u516c\u53f8\u3010%s\u3011\u7684\u94f6\u884c\u8d26\u6237\u5fc5\u987b\u901a\u8fc7\u5f00\u6237\u7533\u8bf7\u6d41\u7a0b\u65b0\u589e\u3002", (String)"BankAccountImportOp_13", (String)"tmc-am-opplugin", (Object[])new Object[0]), orgNumber);
                }
                this.fillDefaultDataAndCheck((Map<String, Object>)data, options);
                String finOrgType = (String)data.get((Object)"finorgtype");
                boolean isChecked = this.checkDropdowValue("am_accountbank", "finorgtype", finOrgType);
                if (StringUtils.isEmpty((CharSequence)finOrgType)) {
                    message = ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u91d1\u878d\u673a\u6784\u7c7b\u522b", (String)"BankAccountImportOp_0", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                } else if (!isChecked) {
                    message = ResManager.loadKDString((String)"\u201c\u91d1\u878d\u673a\u6784\u7c7b\u522b\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879", (String)"BankAccountImportOp_1", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                }
                String acctStyle = (String)data.get((Object)"acctstyle");
                isChecked = this.checkDropdowValue("am_accountbank", "acctstyle", acctStyle);
                if (StringUtils.isEmpty((CharSequence)acctStyle)) {
                    message = ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u8d26\u6237\u7c7b\u578b", (String)"BankAccountImportOp_2", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                } else if (!isChecked) {
                    message = ResManager.loadKDString((String)"\u201c\u8d26\u6237\u7c7b\u578b\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879", (String)"BankAccountImportOp_3", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                }
                String acctType = (String)data.get((Object)"accttype");
                isChecked = this.checkDropdowValue("am_accountbank", "accttype", acctType);
                if (StringUtils.isEmpty((CharSequence)acctType)) {
                    message = ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u8d26\u6237\u6027\u8d28", (String)"BankAccountImportOp_4", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                } else if (!isChecked) {
                    message = ResManager.loadKDString((String)"\u201c\u8d26\u6237\u6027\u8d28\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879", (String)"BankAccountImportOp_5", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                }
                String acctStatus = (String)data.get((Object)"acctstatus");
                isChecked = this.checkDropdowValue("am_accountbank", "acctstatus", acctStatus);
                if (StringUtils.isEmpty((CharSequence)acctStatus)) {
                    message = ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u8d26\u6237\u72b6\u6001", (String)"BankAccountImportOp_6", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                } else if (!isChecked) {
                    message = ResManager.loadKDString((String)"\u201c\u8d26\u6237\u72b6\u6001\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879", (String)"BankAccountImportOp_7", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                } else if (!BankAcctStatusEnum.CLOSED.getValue().equals(acctStatus)) {
                    if (data.getDate("closedate") != null) {
                        message = ResManager.loadKDString((String)"\u201c\u8d26\u6237\u72b6\u6001\u201d\u4e3a\u201c\u5df2\u9500\u6237\u201d\u624d\u5141\u8bb8\u5bfc\u5165\u201c\u9500\u6237\u65e5\u671f\u201d", (String)"BankAccountImportOp_9", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)data.getString("closereason"))) {
                        message = ResManager.loadKDString((String)"\u201c\u8d26\u6237\u72b6\u6001\u201d\u4e3a\u201c\u5df2\u9500\u6237\u201d\u624d\u5141\u8bb8\u5bfc\u5165\u201c\u9500\u6237\u539f\u56e0\u201d", (String)"BankAccountImportOp_10", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                    }
                }
                String beBankFunc = (String)data.get((Object)"bebankfunc");
                if (!StringUtils.isEmpty((CharSequence)beBankFunc) && !(isEquals2 = this.isEquals(beBankFunc, "bebankfunc"))) {
                    message = ResManager.loadKDString((String)"\u201c\u94f6\u4f01\u529f\u80fd\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879", (String)"BankAccountImportOp_8", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                }
                if (!StringUtils.isEmpty((CharSequence)(bankFunc = (String)data.get((Object)"bankfunc"))) && !(isEquals = this.isEquals(bankFunc, "bankfunc"))) {
                    message = ResManager.loadKDString((String)"\u201c\u7f51\u4e0a\u94f6\u884c\u529f\u80fd\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879", (String)"BankAccountImportOp_12", (String)"tmc-am-opplugin", (Object[])new Object[0]);
                }
                this.checkAcctProperty((Map<String, Object>)data);
                data.put("createorg", data.get((Object)"company"));
                if (!EmptyUtil.isNoEmpty((String)message)) continue;
                this.addErrMessage(message);
            }
            catch (Exception exc) {
                message = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
                logger.log(Integer.valueOf(rowdata.getStartIndex()), message).fail();
                it.remove();
            }
        }
    }

    private boolean checkDropdowValue(String formId, String field, String name) {
        Boolean exist = Boolean.FALSE;
        MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)formId);
        if (((EntityType)meta.getAllEntities().get(formId)).getProperties().get((Object)field) instanceof ComboProp) {
            List items = ((ComboProp)((EntityType)meta.getAllEntities().get(formId)).getProperties().get((Object)field)).getComboItems();
            for (ValueMapItem item : items) {
                if (!item.getValue().equalsIgnoreCase(name)) continue;
                exist = Boolean.TRUE;
                break;
            }
        }
        return exist;
    }

    private boolean isEquals(String selectedFunc, String fieldName) {
        boolean result = Boolean.TRUE;
        Set<String> values = this.getDropdowValue("am_accountbank", fieldName);
        int oldCount = values.size();
        String[] split = selectedFunc.split(",");
        values.addAll(Arrays.asList(split));
        int newCount = values.size();
        if (oldCount != newCount) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private Set<String> getDropdowValue(String formId, String field) {
        HashSet<String> values = new HashSet<String>();
        MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)formId);
        if (((EntityType)meta.getAllEntities().get(formId)).getProperties().get((Object)field) instanceof ComboProp) {
            List items = ((ComboProp)((EntityType)meta.getAllEntities().get(formId)).getProperties().get((Object)field)).getComboItems();
            for (ValueMapItem item : items) {
                values.add(item.getValue());
            }
        }
        return values;
    }

    private void fillDefaultDataAndCheck(Map<String, Object> data, Map<String, Object> option) {
        String bankAccountNumber;
        QFilter accountBankQFilter;
        DynamicObject bankAcct;
        boolean isChangeApply;
        String importType = (String)option.get("importtype");
        if ((OVERRIDE.equals(importType) || OVERRIDE_NEW.equals(importType)) && (isChangeApply = AmParameterHelper.getAppBoolParameter((long)(bankAcct = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,company,bank", (QFilter[])new QFilter[]{accountBankQFilter = new QFilter("bankaccountnumber", "=", (Object)(bankAccountNumber = (String)data.get("bankaccountnumber")))})).getDynamicObject("company").getLong("id"), (String)TmcParamEnum.AM003.getValue()))) {
            this.addErrMessage(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u6240\u5c5e\u8d44\u91d1\u7ec4\u7ec7\u5f00\u542f\u3010\u94f6\u884c\u8d26\u6237\u5fc5\u987b\u901a\u8fc7\u53d8\u66f4\u6d41\u7a0b\u53d8\u66f4\u3011\u53c2\u6570\uff0c\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u90fd\u5fc5\u987b\u901a\u8fc7\u53d8\u66f4\u6d41\u7a0b\u53d8\u66f4\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u4fee\u6539\u3002", (String)"TransDetailImportOp_0", (String)"tmc-bei-opplugin", (Object[])new Object[0]), bankAccountNumber));
        }
    }

    private DynamicObject getCompanyByNumber(Map<String, Object> data) {
        JSONObject companyOb = (JSONObject)data.get("company");
        String number = companyOb.getString("number");
        QFilter orgQFilter = new QFilter("number", "=", (Object)number);
        DynamicObject company = TmcDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{orgQFilter});
        return company;
    }

    private void checkAcctProperty(Map<String, Object> data) {
        DynamicObject company = this.getCompanyByNumber(data);
        boolean isShowEnd = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)"isselectend");
        if (isShowEnd) {
            String bankAccountNumber = (String)data.get("bankaccountnumber");
            JSONObject acctPropertyJS = (JSONObject)data.get("acctproperty");
            String number = acctPropertyJS.getString("number");
            QFilter qFilter = new QFilter("isleaf", "=", (Object)"1");
            qFilter.and(new QFilter("number", "=", (Object)number));
            DynamicObject acctPurpose = TmcDataServiceHelper.loadSingle((String)"bd_acctpurpose", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (acctPurpose == null) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u201c\u4ec5\u80fd\u9009\u51fa\u672b\u7ea7\u8d26\u6237\u7528\u9014\u201d\u53c2\u6570\u4e3a\u201c\u5f00\u542f\u201d\u65f6\uff0c\u4e0d\u80fd\u5bfc\u5165\u3010\u8d26\u6237\u7528\u9014\u3011\u4e3a\u975e\u672b\u7ea7\u8d26\u6237\u7528\u9014\u7684\u94f6\u884c\u8d26\u6237\u3002", (String)"BankAccountImportOp_11", (String)"tmc-am-opplugin", (Object[])new Object[0]), bankAccountNumber));
            }
        }
    }

    private void addErrMessage(String message) {
        throw new KDBizException(message);
    }
}

