/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.opplugin.bankacct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.business.validate.bankacct.BankAccountSaveValidator;
import kd.tmc.am.business.validate.bankacct.BankAcctVirtualValidator;
import kd.tmc.am.common.enums.AccountBankLogEnum;
import kd.tmc.am.common.helper.AcctBankLogHelper;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAccountSaveOp
extends AbstractOperationServicePlugIn {
    private static final String[] bankFunc = new String[]{BankFuncEnum.QUERY.getValue(), BankFuncEnum.PAY.getValue(), BankFuncEnum.RECEIPT.getValue(), BankFuncEnum.ECD.getValue(), BankFuncEnum.PROXYINQUIRY.getValue()};
    private Map<Object, Object> idMapProxyCurrency = new HashMap<Object, Object>(10);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BankAccountSaveValidator());
        e.addValidator((AbstractValidator)new BankAcctVirtualValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("company");
        fieldKeys.add("opendate");
        fieldKeys.add("finorgtype");
        fieldKeys.add("bank");
        fieldKeys.add("currency");
        fieldKeys.add("defaultcurrency");
        fieldKeys.add("org");
        fieldKeys.add("bankaccountnumber");
        fieldKeys.add("ismulcurrency");
        fieldKeys.add("createorg");
        fieldKeys.add("acctstyle");
        fieldKeys.add("creator");
        fieldKeys.add("issetbankinterface");
        fieldKeys.add("bebankfunc");
        fieldKeys.add("proxycurrency");
        fieldKeys.add("proxyinquiryaccount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        ArrayList<String> currencyNames = null;
        for (DynamicObject bankAcct : args.getDataEntities()) {
            DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("currency");
            DynamicObject defCurrency = bankAcct.getDynamicObject("defaultcurrency");
            currencyNames = new ArrayList<String>(currencys.size());
            currencyNames.add(defCurrency.getString("name"));
            for (DynamicObject currency : currencys) {
                if (((DynamicObject)currency.get("fbasedataid")).getPkValue().equals(defCurrency.getPkValue())) continue;
                currencyNames.add(((DynamicObject)currency.get("fbasedataid")).getString("name"));
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)currencys) || currencys.size() == 1) {
                bankAcct.set("ismulcurrency", (Object)Boolean.FALSE);
            } else {
                bankAcct.set("ismulcurrency", (Object)Boolean.TRUE);
            }
            String currencyName = StringUtils.join((Object[])currencyNames.toArray(new String[0]), (String)",");
            if (currencyName.length() > 80) {
                currencyName = currencyName.substring(0, 77);
                currencyName = currencyName + "...";
            }
            bankAcct.set("currencyname", (Object)currencyName);
            bankAcct.set("org", bankAcct.get("company"));
            bankAcct.set("createorg", bankAcct.get("company"));
            bankAcct.set("number", bankAcct.get("bankaccountnumber"));
            bankAcct.set("status", (Object)BillStatus.C.name());
            String bebankfunc = bankAcct.getString("bebankfunc");
            DynamicObjectCollection entries = bankAcct.getDynamicObjectCollection("entry");
            boolean tag = bankAcct.getBoolean("issetbankinterface");
            Date openDate = bankAcct.getDate("opendate");
            if (tag) {
                if (entries.isEmpty()) {
                    for (int i = 0; i < 5; ++i) {
                        DynamicObject entry = entries.addNew();
                        entry.set("e_bankfunction", (Object)bankFunc[i]);
                        entry.set("seq", (Object)(i + 1));
                        entry.set("e_enable", (Object)(!StringUtils.isBlank((CharSequence)bebankfunc) && bebankfunc.contains(bankFunc[i]) ? 1 : 0));
                        if (StringUtils.isBlank((CharSequence)bebankfunc) || !bebankfunc.contains(bankFunc[i])) continue;
                        entry.set("e_predictopendate", (Object)openDate);
                    }
                    continue;
                }
                for (DynamicObject entry : entries) {
                    entry.set("e_enable", (Object)(!StringUtils.isBlank((CharSequence)bebankfunc) && bebankfunc.contains(entry.getString("e_bankfunction")) ? 1 : 0));
                }
                continue;
            }
            entries.clear();
        }
        this.dealProxyInquiryAcct(args.getDataEntities());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] bankAccts;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bankAcct : bankAccts = e.getDataEntities()) {
            long companyId = bankAcct.getDynamicObject("company").getLong("id");
            String key = "am_accountbank" + companyId;
            String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
            BaseDataCtrlCache.clearBaseDataUseRange((String)"am_accountbank", (Long)companyId);
            DynamicObject currency = bankAcct.getDynamicObject("proxycurrency");
            if (currency == null) continue;
            this.idMapProxyCurrency.put(bankAcct.getPkValue(), currency.getPkValue());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        try {
            AcctBankLogHelper.getInstance().addAcctBankLogByDynamic(e.getDataEntities(), AccountBankLogEnum.ACCOUNT_SAVE.getValue());
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void dealProxyInquiryAcct(DynamicObject[] dataEntities) {
        List collect = Arrays.stream(dataEntities).map(o -> o.getPkValue()).collect(Collectors.toList());
        DynamicObject[] proxyAcctDc = BusinessDataServiceHelper.load((String)"am_proxyinquiryaccount", (String)"org,bankacct,currency,proxyinquiryaccount,status,enable,issync,syndate", (QFilter[])new QFilter[]{new QFilter("bankacct", "in", collect)});
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(10);
        ArrayList<Object> deleteObjs = new ArrayList<Object>(10);
        for (DynamicObject dataEntity : dataEntities) {
            boolean hasProxyAccount = this.checkProxyAccount(dataEntity);
            if (hasProxyAccount) {
                if (dataEntity == null) continue;
                DynamicObject proxyCurrency = dataEntity.getDynamicObject("proxycurrency");
                String proxyInquiryAccount = dataEntity.getString("proxyinquiryaccount");
                List dynamicObjects = Arrays.stream(proxyAcctDc).filter(o -> o.getDynamicObject("bankacct").getPkValue().equals(dataEntity.getPkValue())).collect(Collectors.toList());
                Object currency = this.idMapProxyCurrency.get(dataEntity.getPkValue());
                if (dynamicObjects.size() > 0) {
                    DynamicObject proxyAcct;
                    if (EmptyUtil.isNoEmpty((DynamicObject)proxyCurrency)) {
                        DynamicObject oldProxyAcct;
                        proxyAcct = dynamicObjects.stream().filter(o -> o.getDynamicObject("currency").getPkValue().equals(proxyCurrency.getPkValue())).findFirst().orElse(null);
                        if (EmptyUtil.isNoEmpty((DynamicObject)proxyAcct)) {
                            proxyAcct.set("proxyinquiryaccount", (Object)proxyInquiryAccount);
                            saveObjs.add(proxyAcct);
                            continue;
                        }
                        DynamicObject newProxyAcctDy = this.newProxyAcctDy(dataEntity);
                        if (EmptyUtil.isNoEmpty((DynamicObject)newProxyAcctDy)) {
                            saveObjs.add(newProxyAcctDy);
                        }
                        if (!EmptyUtil.isNoEmpty((Object)currency) || !EmptyUtil.isNoEmpty((DynamicObject)(oldProxyAcct = (DynamicObject)dynamicObjects.stream().filter(o -> o.getDynamicObject("currency").getPkValue().equals(currency)).findFirst().orElse(null)))) continue;
                        deleteObjs.add(oldProxyAcct);
                        continue;
                    }
                    if (!EmptyUtil.isNoEmpty((Object)currency) || !EmptyUtil.isNoEmpty((DynamicObject)(proxyAcct = (DynamicObject)dynamicObjects.stream().filter(o -> o.getDynamicObject("currency").getPkValue().equals(currency)).findFirst().orElse(null)))) continue;
                    deleteObjs.add(proxyAcct);
                    continue;
                }
                if (!EmptyUtil.isNoEmpty((String)proxyInquiryAccount) || !EmptyUtil.isNoEmpty((DynamicObject)proxyCurrency)) continue;
                saveObjs.add(this.newProxyAcctDy(dataEntity));
                continue;
            }
            List dynamicObjects = Arrays.stream(proxyAcctDc).filter(o -> o.getDynamicObject("bankacct").getPkValue().equals(dataEntity.getPkValue())).collect(Collectors.toList());
            deleteObjs.addAll(dynamicObjects);
        }
        if (saveObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
        }
        if (deleteObjs.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)deleteObjs.get(0)).getDynamicObjectType(), (Object[])deleteObjs.toArray(new DynamicObject[0]));
        }
    }

    private boolean checkProxyAccount(DynamicObject bankAccount) {
        String beBankFunc;
        boolean isSetBankInterface;
        if (bankAccount != null && (isSetBankInterface = bankAccount.getBoolean("issetbankinterface")) && (beBankFunc = bankAccount.getString("bebankfunc")) != null && beBankFunc.contains("proxyinquiry")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private DynamicObject newProxyAcctDy(DynamicObject dataEntity) {
        String proxyInquiryAccount = dataEntity.getString("proxyinquiryaccount");
        if (EmptyUtil.isNoEmpty((String)proxyInquiryAccount)) {
            DynamicObject proxyInquiryAcct = BusinessDataServiceHelper.newDynamicObject((String)"am_proxyinquiryaccount");
            proxyInquiryAcct.set("status", (Object)"C");
            proxyInquiryAcct.set("enable", (Object)"1");
            proxyInquiryAcct.set("bankacct_id", dataEntity.getPkValue());
            proxyInquiryAcct.set("org_id", dataEntity.getDynamicObject("company").getPkValue());
            proxyInquiryAcct.set("bank_id", dataEntity.getDynamicObject("bank").getPkValue());
            proxyInquiryAcct.set("proxyinquiryaccount", (Object)dataEntity.getString("proxyinquiryaccount"));
            proxyInquiryAcct.set("currency_id", dataEntity.getDynamicObject("proxycurrency").getPkValue());
            proxyInquiryAcct.set("creator_id", dataEntity.getDynamicObject("creator").getPkValue());
            return proxyInquiryAcct;
        }
        return null;
    }
}

