/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.opplugin.holdgoodsmainfest;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.business.validate.holdgoodsmainfest.HoldGoodsMainFestAuditValidator;

public class HoldGoodsMainFestAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        keyList.add("businesstype");
        keyList.add("inventorygood");
        keyList.add("stakeholder");
        keyList.add("associatedtype");
        keyList.add("billinfo");
        keyList.add("changeentryentity");
        keyList.add("afterchange");
        keyList.add("cgoodsname");
        keyList.add("cstartdate");
        keyList.add("cenddate");
        keyList.add("cpermission");
        keyList.add("cdescription");
        keyList.add("cassociatedtype");
        keyList.add("cbillinfo");
        keyList.add("ckeeper");
        keyList.add("propertytype");
        keyList.add("cbillid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        List<Object> targetPkList = new ArrayList();
        for (DynamicObject holdGoodsMainfest : e.getDataEntities()) {
            DynamicObject[] inventGoodsDo;
            targetPkList.clear();
            DynamicObjectCollection entryEntity = holdGoodsMainfest.getDynamicObjectCollection("entryentity");
            String type = holdGoodsMainfest.getString("businesstype");
            DynamicObject stakeholderDy = holdGoodsMainfest.getDynamicObject("stakeholder");
            targetPkList = entryEntity.stream().map(y -> {
                DynamicObject inventGood = y.getDynamicObject("inventorygood");
                return Long.parseLong(inventGood.getPkValue().toString());
            }).collect(Collectors.toList());
            for (DynamicObject invGoods : inventGoodsDo = BusinessDataServiceHelper.load((Object[])targetPkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_inventorygoodmanager"))) {
                String propName = "goodstatus";
                String propValue = "A";
                switch (type.toLowerCase(Locale.ROOT)) {
                    case "change": {
                        propValue = "A";
                        this.updateGoodsUseInfo(holdGoodsMainfest, invGoods);
                        break;
                    }
                    case "logout": {
                        propValue = "E";
                        break;
                    }
                    case "loss": {
                        propValue = "D";
                        break;
                    }
                    case "invalid": {
                        propValue = "C";
                        break;
                    }
                    case "transfer": 
                    case "adoption": {
                        propName = "adoptionstatus";
                        propValue = "true";
                        invGoods.set("goodstatus", (Object)"A");
                        invGoods.set("adopter", stakeholderDy.getPkValue());
                        break;
                    }
                    case "return": {
                        propName = "adoptionstatus";
                        invGoods.set("goodstatus", (Object)"A");
                        invGoods.set("adopter", (Object)0);
                        break;
                    }
                }
                invGoods.set(propName, (Object)propValue);
            }
            SaveServiceHelper.save((DynamicObject[])inventGoodsDo);
        }
    }

    private void updateGoodsUseInfo(DynamicObject mainfest, DynamicObject invGoods) {
        DynamicObjectCollection changeDc = mainfest.getDynamicObjectCollection("changeentryentity");
        for (DynamicObject changeDy : changeDc) {
            String propertyType = changeDy.getString("propertytype");
            if (propertyType.isEmpty()) continue;
            String key = "c" + propertyType;
            if (propertyType.equalsIgnoreCase("associatedtype")) {
                DynamicObjectCollection associatedList = invGoods.getDynamicObjectCollection("entryentity");
                associatedList.clear();
                String billInfo = changeDy.getString("cbillinfo");
                String billIds = changeDy.getString("cbillid");
                String[] billInfoSplit = billInfo.split(",");
                String[] billIdsSplit = billIds.split(",");
                int index = 0;
                for (String newInfo : billInfoSplit) {
                    DynamicObject row = associatedList.addNew();
                    row.set(propertyType, changeDy.get(key));
                    row.set("billinfo", (Object)newInfo);
                    row.set("billid", (Object)billIdsSplit[index]);
                    ++index;
                }
                continue;
            }
            invGoods.set(propertyType, changeDy.get(key));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new HoldGoodsMainFestAuditValidator());
    }
}

