/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.opplugin.openacct;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.business.validate.openacct.BankAcctOpenUnSubmitValidator;
import kd.tmc.am.common.helper.AmBotpHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class BankAcctOpenUnSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        keyList.add("bankaccountnumber");
        keyList.add("finorgtype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BankAcctOpenUnSubmitValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String entityName = e.getDataEntities()[0].getDataEntityType().getName();
        String targetEntityName = "ifm_accountacceptancebill";
        Set<Object> ifmBillId = new HashSet(10);
        for (DynamicObject dyObj : e.getDataEntities()) {
            Long pkValue;
            Long targetBillId;
            String finOrgType = dyObj.getString("finorgtype");
            if (!FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(finOrgType) || (targetBillId = AmBotpHelper.getTargetBill((String)entityName, (Long)(pkValue = (Long)dyObj.getPkValue()), (String)targetEntityName)) == 0L) continue;
            AmBotpHelper.deleteBotpRation((Long)pkValue, (Long)targetBillId);
            ifmBillId.add(targetBillId);
        }
        DynamicObject[] existTargetBills = BusinessDataServiceHelper.load((String)"ifm_accountacceptancebill", (String)"id", (QFilter[])new QFilter("id", "in", ifmBillId).toArray());
        if (existTargetBills.length > 0) {
            ifmBillId = Arrays.stream(existTargetBills).map(d -> (Long)d.getPkValue()).collect(Collectors.toSet());
            TmcOperateServiceHelper.execOperate((String)"delete", (String)targetEntityName, (Object[])ifmBillId.toArray(), (OperateOption)OperateOption.create(), (boolean)true);
        }
    }
}

