/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.opplugin.openacct;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BusinessTypeEnum;
import kd.tmc.fbp.common.enums.InnerAcctAcceptStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.opplugin.botp.AbsMultiPropBotpConvertPlugin;

public class BankOpenBotpConvertPlugin
extends AbsMultiPropBotpConvertPlugin {
    protected String getSourceKey() {
        return "muiticurrency";
    }

    protected String getTargetKey() {
        return "muiticurrency";
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntities;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            billDataEntity.setValue("businesstype", (Object)BusinessTypeEnum.OPEN.getValue());
            billDataEntity.setValue("businessstatus", (Object)InnerAcctAcceptStatusEnum.WAIT.getValue());
            billDataEntity.setValue("issetbankinterface", (Object)false);
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            billDataEntity.setValue("sourceid", pkValue);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"am_accopenbill");
            DynamicObject openBank = dynamicObject.getDynamicObject("bank");
            DynamicObject openBankAllFields = BusinessDataServiceHelper.loadSingle((Object)openBank.getPkValue(), (String)"bd_finorginfo");
            billDataEntity.getDataEntity().set("scorg", openBankAllFields.get("org"));
            DynamicObject dataEntity = billDataEntity.getDataEntity();
            dataEntity.set("bankaccountnumber", (Object)this.getInnerAccountCodeRule(dataEntity));
            dataEntity.set("acctname", dynamicObject.getDynamicObject("openorg").get("name"));
        }
    }

    private String getInnerAccountCodeRule(DynamicObject dataEntity) {
        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ifm_inneracct");
        newDynamicObject.set("openorg", dataEntity.get("openorg"));
        newDynamicObject.set("finorg", dataEntity.get("bank"));
        newDynamicObject.set("currency_dflt", dataEntity.get("defaultcurrency"));
        return CodeRuleHelper.generateNumber((String)"ifm_inneracct", (DynamicObject)newDynamicObject, null, null);
    }

    public void afterConvert(AfterConvertEventArgs e) {
    }
}

