/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.opplugin.openacct;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class OpenBillToAcctConvertExtPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Set openBillIdSet = Arrays.stream(billDataEntities).map(o -> {
            List srcRows = (List)o.getValue("ConvertSource");
            if (srcRows.size() > 0) {
                DynamicObject srcBill = (DynamicObject)srcRows.get(0);
                return srcBill.getLong("id");
            }
            return null;
        }).collect(Collectors.toSet());
        DynamicObject[] bankAcctArr = BusinessDataServiceHelper.load((Object[])openBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accopenbill"));
        Map<String, DynamicObject> openBillMap = Arrays.stream(bankAcctArr).collect(Collectors.toMap(k -> k.getString("bankaccountnumber"), v -> v));
        for (ExtendedDataEntity billDataEntity : billDataEntities) {
            DynamicObject row;
            DynamicObjectCollection rows;
            DynamicObject openBill;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            String bankAccountNumber = targetBill.getString("bankaccountnumber");
            if (EmptyUtil.isEmpty((String)bankAccountNumber) || EmptyUtil.isEmpty((DynamicObject)(openBill = openBillMap.get(bankAccountNumber)))) continue;
            if (targetBill.containsProperty("entrysignetentity") && openBill.containsProperty("entrysignetentity")) {
                DynamicObjectCollection netBankGrantEntity = openBill.getDynamicObjectCollection("netbankgrantentity");
                rows = targetBill.getDynamicObjectCollection("netbankgrantentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)netBankGrantEntity) && EmptyUtil.isEmpty((DynamicObjectCollection)rows)) {
                    for (DynamicObject bankGrant : netBankGrantEntity) {
                        row = rows.addNew();
                        row.set("netgrant", bankGrant.get("netgrant"));
                        row.set("operator", bankGrant.get("operator"));
                        row.set("goods", bankGrant.get("goods"));
                        row.set("netgrantcur", bankGrant.get("netgrantcur"));
                        row.set("approvedamount", bankGrant.get("approvedamount"));
                    }
                }
            }
            if (targetBill.containsProperty("entrysignetentity") && openBill.containsProperty("entrysignetentity")) {
                DynamicObjectCollection entrySigNetEntity = openBill.getDynamicObjectCollection("entrysignetentity");
                DynamicObjectCollection sigNetRows = targetBill.getDynamicObjectCollection("entrysignetentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrySigNetEntity) && EmptyUtil.isEmpty((DynamicObjectCollection)sigNetRows)) {
                    for (DynamicObject bankGrant : entrySigNetEntity) {
                        row = sigNetRows.addNew();
                        row.set("signettype", bankGrant.get("signettype"));
                        row.set("signetname", bankGrant.get("signetname"));
                        row.set("signetkeeper", bankGrant.get("signetkeeper"));
                    }
                }
            }
            if (targetBill.containsProperty("virtualentity") && openBill.containsProperty("virtualentity")) {
                DynamicObjectCollection virtualEntity = openBill.getDynamicObjectCollection("virtualentity");
                rows = targetBill.getDynamicObjectCollection("virtualentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)virtualEntity) && EmptyUtil.isEmpty((DynamicObjectCollection)rows)) {
                    for (DynamicObject bankGrant : virtualEntity) {
                        row = rows.addNew();
                        row.set("virtualaccount", bankGrant.get("virtualaccount"));
                        row.set("openbank", bankGrant.get("openbank"));
                        row.set("remark", bankGrant.get("remark"));
                    }
                }
            }
            this.setNormalProperty(targetBill, openBill, "merchantnumber");
            this.setNormalProperty(targetBill, openBill, "level");
            this.setNormalProperty(targetBill, openBill, "masteraccount");
            this.setNormalProperty(targetBill, openBill, "ismoneypool");
            this.setNormalProperty(targetBill, openBill, "businessmatters");
            this.setNormalProperty(targetBill, openBill, "isopenpos");
            this.setNormalProperty(targetBill, openBill, "poscount");
            this.setMultiBaseProperty(targetBill, openBill, "multigoods", "multigoods");
            this.setNormalProperty(targetBill, openBill, "enteraccount");
            this.setNormalProperty(targetBill, openBill, "deposittype");
            this.setNormalProperty(targetBill, openBill, "depositrate");
            this.setNormalProperty(targetBill, openBill, "agreementrate");
            this.setNormalProperty(targetBill, openBill, "agreelimit");
            this.setNormalProperty(targetBill, openBill, "couponfrequency");
            this.setNormalProperty(targetBill, openBill, "iselecpayment");
            this.setNormalProperty(targetBill, openBill, "elecpaymenttype");
            this.setNormalProperty(targetBill, openBill, "elecpaymentlevel");
            this.setMultiBaseProperty(targetBill, openBill, "relatedsettleacct", "relatedsettleacct");
            if (!EmptyUtil.isNoEmpty((Object)openBill.getBoolean("iselecpayment")) || !openBill.getBoolean("iselecpayment")) continue;
            DynamicObject settlementType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"JSFS15_S")});
            DynamicObjectCollection settlementColl = targetBill.getDynamicObjectCollection("settlementtype");
            settlementColl.clear();
            DynamicObject newSettlement = new DynamicObject(settlementColl.getDynamicObjectType());
            newSettlement.set("fbasedataid", (Object)settlementType);
            settlementColl.add((Object)newSettlement);
            targetBill.set("settlementtype", (Object)settlementColl);
        }
    }

    public void setNormalProperty(DynamicObject targetBill, DynamicObject srcBill, String propertyName) {
        if (targetBill.containsProperty(propertyName) && srcBill.containsProperty(propertyName)) {
            targetBill.set(propertyName, srcBill.get(propertyName));
        }
    }

    public void setMultiBaseProperty(DynamicObject targetBill, DynamicObject srcBill, String getTargetKey, String getSourceKey) {
        MulBasedataProp targetFieldProp = (MulBasedataProp)this.getTgtMainType().findProperty(getTargetKey);
        MulBasedataProp sourceFieldProp = (MulBasedataProp)this.getSrcMainType().findProperty(getSourceKey);
        DynamicObjectCollection sourceFieldRows = srcBill.getDynamicObjectCollection(getSourceKey);
        DynamicObjectCollection targetFieldRows = targetBill.getDynamicObjectCollection(getTargetKey);
        targetFieldRows.clear();
        for (DynamicObject srcFieldRow : sourceFieldRows) {
            DynamicObject targetFieldRow = new DynamicObject(targetFieldProp.getDynamicCollectionItemPropertyType());
            targetFieldProp.getRefIdProp().setValue((Object)targetFieldRow, sourceFieldProp.getRefIdProp().getValue((Object)srcFieldRow));
            targetFieldRows.add((Object)targetFieldRow);
        }
    }
}

