/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.opplugin.proxyaccount;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.business.validate.proxyaccount.ProxyAccountSaveValidator;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class ProxyAccountDisableOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        keyList.add("bankacct");
        keyList.add("currency");
        keyList.add("issync");
        keyList.add("syndate");
        keyList.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ProxyAccountSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List<DynamicObject> needSyncBills = Arrays.stream(dataEntities).filter(o -> o.getDynamicObject("bankacct").getString("bebankfunc").contains("proxyinquiry")).collect(Collectors.toList());
        if (needSyncBills.size() > 0) {
            for (DynamicObject needSyncBill : needSyncBills) {
                needSyncBill.set("enable", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])needSyncBills.toArray(new DynamicObject[0]));
            Object[] pkIds = needSyncBills.stream().map(DataEntityBase::getPkValue).toArray();
            this.operationResult = TmcOperateServiceHelper.execOperate((String)"syncmappedacct", (String)"am_proxyinquiryaccount", (Object[])pkIds, (OperateOption)OperateOption.create());
            if (this.operationResult == null || !this.operationResult.isSuccess()) {
                for (DynamicObject needSyncBill : needSyncBills) {
                    needSyncBill.set("enable", (Object)"1");
                }
                SaveServiceHelper.save((DynamicObject[])needSyncBills.toArray(new DynamicObject[0]));
            }
        }
    }
}

