/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.opplugin.restrictedfunds;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.business.validate.restrictedfunds.RestrictedFundsManagerAuditValidator;

public class RestrictedFundsManagerAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        keyList.add("businesstype");
        keyList.add("billno");
        keyList.add("srcbillno");
        keyList.add("thistimeunblockamt");
        keyList.add("unrestrictedamt");
        keyList.add("actualliftdate");
        keyList.add("liftdate");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject dyObj : e.getDataEntities()) {
            String businessType = dyObj.getString("businesstype");
            if (!"2".equalsIgnoreCase(businessType)) continue;
            String srcBillNo = dyObj.getString("srcbillno");
            QFilter qFilter = new QFilter("billno", "=", (Object)srcBillNo);
            qFilter.and("businesstype", "=", (Object)"1");
            String selectField = "id,unrestrictedamt,actualliftdate";
            DynamicObject resultDt = BusinessDataServiceHelper.loadSingle((String)"am_restrictedfundsmanager", (String)selectField, (QFilter[])qFilter.toArray());
            if (resultDt == null) continue;
            BigDecimal oriAmt = resultDt.getBigDecimal("unrestrictedamt");
            BigDecimal thisSubstractAmt = dyObj.getBigDecimal("thistimeunblockamt");
            BigDecimal newValue = oriAmt.subtract(thisSubstractAmt);
            Date liftDate = dyObj.getDate("liftdate");
            resultDt.set("unrestrictedamt", (Object)newValue);
            if (newValue.longValue() == 0L) {
                resultDt.set("actualliftdate", (Object)liftDate);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resultDt});
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new RestrictedFundsManagerAuditValidator());
    }
}

