/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.common.helper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.am.common.enums.OpenAcctBillStatusEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AccountBankHelper {
    private static final String ENUM_STATUS_NORMAL = "normal";
    private static final String BANKACCOUNTNUMBER = "bankaccountnumber";
    private static final String CLOSESTATUS = "acctstatus";
    private static final String ACCTSTATUS = "acctstatus";
    private static final String ISSETBANKINTERFACE = "issetbankinterface";
    private static Log log = LogFactory.getLog(AccountBankHelper.class);

    public static DynamicObject getAccountBankById(long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bd_accountbanks");
    }

    public static List<Long> getAcctBankByOrg(long orgId) {
        return AccountBankHelper.getAcctBankByOrg(Collections.singletonList(orgId));
    }

    public static List<Long> getAcctBankByOrg(List<Long> orgIdList) {
        QFilter[] filters = AccountBankHelper.getAccountFilter(orgIdList);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])filters);
        ArrayList<Long> accountPks = new ArrayList<Long>(accounts.length);
        for (DynamicObject account : accounts) {
            accountPks.add((Long)account.getPkValue());
        }
        return accountPks;
    }

    public static void updateInnerAcctStatus(DynamicObject[] dataEntities, String acctStatus) {
        Set innerAccounts = Arrays.stream(dataEntities).map(d -> d.getDynamicObject("accountbank").getDynamicObject("inneracct")).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(innerAccounts)) {
            DynamicObject[] innerAccountsAllFields;
            for (DynamicObject innerAccountsAllField : innerAccountsAllFields = BusinessDataServiceHelper.load((Object[])innerAccounts.stream().map(i -> (Long)i.getPkValue()).filter(Objects::nonNull).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_inneracct"))) {
                innerAccountsAllField.set("acctstatus", (Object)acctStatus);
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_inneracct", (DynamicObject[])innerAccountsAllFields, (OperateOption)OperateOption.create());
        }
    }

    public static List<Long> getUseableAccountPks(Collection<Long> orgIds) {
        QFilter[] filters = AccountBankHelper.getUsableAccountFilter(orgIds);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])filters);
        ArrayList<Long> accountPks = new ArrayList<Long>(accounts.length);
        for (DynamicObject account : accounts) {
            accountPks.add((Long)account.getPkValue());
        }
        return accountPks;
    }

    public static boolean canUseAccount(long orgId, long acctBankId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company,acctstatus", (QFilter[])new QFilter("id", "=", (Object)acctBankId).toArray());
        return AccountBankHelper.validateAccountAuthByOrg(orgId, acctBankId) && (ENUM_STATUS_NORMAL.equals(account.getString("acctstatus")) || "freeze".equals(account.getString("acctstatus")));
    }

    public static boolean batchCanUseAccount(Map<Long, Set<Long>> checkMap) {
        for (Map.Entry<Long, Set<Long>> entry : checkMap.entrySet()) {
            Long orgId = entry.getKey();
            Set<Long> acctBankIdList = entry.getValue();
            QFilter qFilter = new QFilter("id", "in", acctBankIdList);
            qFilter.and(AccountBankHelper.getAccountBankFilterByOrg(orgId));
            DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter[]{qFilter});
            boolean flag = accountBanks.length == acctBankIdList.size() ? Boolean.TRUE : Boolean.FALSE;
            if (flag) {
                for (DynamicObject account : accountBanks) {
                    if (ENUM_STATUS_NORMAL.equals(account.getString("acctstatus")) || "freeze".equals(account.getString("acctstatus"))) continue;
                    return Boolean.FALSE;
                }
                continue;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean isEntrustCanUseAccount(long orgId, long acctBankId) {
        boolean accountStatus;
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company,acctstatus", (QFilter[])new QFilter("id", "=", (Object)acctBankId).toArray());
        boolean bl = accountStatus = ENUM_STATUS_NORMAL.equals(account.getString("acctstatus")) || "freeze".equals(account.getString("acctstatus"));
        if (accountStatus) {
            boolean canUse = AccountBankHelper.validateAccountAuthByOrg(orgId, acctBankId);
            if (!canUse) {
                QFilter fromOrgFilter = new QFilter("fromorg", "=", (Object)orgId);
                QFilter numberFilter = new QFilter("typerelation.number", "=", (Object)"accounting2capital");
                QFilter isPreSetFilter = new QFilter("typerelation.ispreset", "=", (Object)"1");
                QFilter[] qFilters = fromOrgFilter.and(numberFilter).and(isPreSetFilter).toArray();
                DynamicObject orgRelation = BusinessDataServiceHelper.loadSingle((String)"bos_org_orgrelation", (String)"toorg", (QFilter[])qFilters);
                if (Objects.nonNull(orgRelation)) {
                    DynamicObject toOrg = orgRelation.getDynamicObject("toorg");
                    return AccountBankHelper.validateAccountAuthByOrg((Long)toOrg.getPkValue(), acctBankId);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static Set<Long> getCurrencyPks(long acctBankId) {
        return AccountBankHelper.getCurrencyPks("bd_accountbanks", Collections.singletonList(acctBankId));
    }

    public static Set<Long> getCurrencyPks(List<Long> acctBankIds) {
        return AccountBankHelper.getCurrencyPks("bd_accountbanks", acctBankIds);
    }

    public static Set<Long> getCurrencyPks(String acctEntityName, List<Long> acctIds) {
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)acctEntityName, (String)"id,currency.fbasedataid.id,currency.fbasedataid.enable", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds), new QFilter("currency.fbasedataid.enable", "=", (Object)Character.valueOf('1'))}, null);
        HashSet<Long> currencyIdSet = new HashSet<Long>(queryAcctColl.size());
        for (int i = 0; i < queryAcctColl.size(); ++i) {
            DynamicObject acctObj = (DynamicObject)queryAcctColl.get(i);
            currencyIdSet.add(acctObj.getLong("currency.fbasedataid.id"));
        }
        return currencyIdSet;
    }

    public static Set<Long> getBanks(String acctEntityName, List<Long> acctIds) {
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)acctEntityName, (String)"id,bank.id", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds)}, null);
        HashSet<Long> bankIdSet = new HashSet<Long>(queryAcctColl.size());
        for (int i = 0; i < queryAcctColl.size(); ++i) {
            DynamicObject acctObj = (DynamicObject)queryAcctColl.get(i);
            bankIdSet.add(acctObj.getLong("bank.id"));
        }
        return bankIdSet;
    }

    public static DynamicObject getDefaultAccount(Long orgId, String fieldName) {
        QFilter[] usableAccountFilter = new QFilter[]{AccountBankHelper.getCreateOrgFilter(orgId), AccountBankHelper.getUsableFilter(), new QFilter(fieldName, "=", (Object)"1")};
        DynamicObject account = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])usableAccountFilter);
        if (account != null) {
            account = BusinessDataServiceHelper.loadSingleFromCache((Object)account.getPkValue(), (String)"bd_accountbanks");
        }
        return account;
    }

    public static DynamicObject getAccountByNumber(String accountNumber) {
        QFilter[] filters = new QFilter[]{new QFilter(BANKACCOUNTNUMBER, "=", (Object)accountNumber)};
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])filters);
        return account;
    }

    public static List<Long> getUseCompanies(long accountId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company", (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
        return Collections.singletonList(account.getLong("company"));
    }

    public static QFilter[] getUsableAccountFilter(Collection<Long> orgIds, boolean isSetBankInterface) {
        return new QFilter[]{AccountBankHelper.getOrgFilter(orgIds), AccountBankHelper.getUsableFilter(), AccountBankHelper.getSetEbFilter()};
    }

    public static QFilter[] getUsableAccountFilter(long orgId) {
        return new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgId), AccountBankHelper.getUsableFilter()};
    }

    public static QFilter[] getUsableAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgIds), AccountBankHelper.getUsableFilter()};
    }

    public static QFilter getUsableFilter() {
        return new QFilter("acctstatus", "=", (Object)ENUM_STATUS_NORMAL);
    }

    public static QFilter[] getAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{AccountBankHelper.getOrgFilter(orgIds)};
    }

    public static QFilter[] getAccountFilterForOwn(Collection<Long> orgIds) {
        return new QFilter[]{AccountBankHelper.getCreateOrgFilter(orgIds)};
    }

    public static QFilter[] getAccountFilterForOwn(long orgId) {
        return new QFilter[]{AccountBankHelper.getCreateOrgFilter(orgId)};
    }

    private static QFilter getOrgFilter(Collection<Long> orgIds) {
        return new QFilter("company", "in", orgIds);
    }

    private static QFilter getCreateOrgFilter(Collection<Long> orgIds) {
        return new QFilter("createorg", "in", orgIds);
    }

    private static QFilter getCreateOrgFilter(long orgId) {
        return new QFilter("createorg", "=", (Object)orgId);
    }

    private static QFilter getSetEbFilter() {
        return new QFilter(ISSETBANKINTERFACE, "=", (Object)Boolean.TRUE);
    }

    public static QFilter getCheckCompanyFilter(Collection<Long> orgIds) {
        return new QFilter("company", "in", orgIds);
    }

    public static String getBankNumberEncryptDisplay(String value) {
        if (value.length() < 9) {
            return String.join((CharSequence)"", Collections.nCopies(value.length(), "*"));
        }
        String preStr = value.substring(0, 4);
        String endStr = value.substring(value.length() - 4, value.length());
        return String.format("%s%s%s", preStr, String.join((CharSequence)"", Collections.nCopies(4, "*")), endStr);
    }

    public static boolean isClosed(long acctBankId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter("id", "=", (Object)acctBankId).toArray());
        return "closing".equals(account.getString("acctstatus")) || "closed".equals(account.getString("acctstatus"));
    }

    public static QFilter getCurrencyFilter(DynamicObject currency) {
        if (currency != null) {
            return new QFilter("currency.fbasedataid.id", "=", currency.getPkValue());
        }
        return null;
    }

    public static QFilter getAccountBankFilterByOrg(Long orgID) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)orgID);
    }

    public static QFilter getAccountBankFilterByOrg(Collection<Long> orgIDs) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", new ArrayList<Long>(orgIDs), (boolean)true);
    }

    public static DynamicObject[] getAccountBanksByOrg(Long orgID) {
        QFilter qFilter = AccountBankHelper.getAccountBankFilterByOrg(orgID);
        return BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,openorg,createorg,bankaccountnumber", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean validateAccountAuthByOrg(long orgId, long acctBankId) {
        QFilter qFilter = AccountBankHelper.getAccountBankFilterByOrg(orgId);
        qFilter.and(new QFilter("id", "=", (Object)acctBankId));
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return accountBanks.length > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static QFilter[] getCreateOrgAccountFilter(long orgId) {
        return new QFilter[]{AccountBankHelper.getCreateOrgFilter(Collections.singletonList(orgId)), AccountBankHelper.getUsableFilter()};
    }

    public static QFilter[] getCreateOrgAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{AccountBankHelper.getCreateOrgFilter(orgIds), AccountBankHelper.getUsableFilter()};
    }

    public static boolean isAuthorityAccount(DynamicObject accountBank, DynamicObject org) {
        if (accountBank == null || org == null) {
            return false;
        }
        return org.getLong("id") == accountBank.getDynamicObject("createorg").getLong("id");
    }

    public static Set<Long> getUserAuthorityOrgs(Long accountBankId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fuseorgid from ").append("t_bd_accountbanks_u").append(" where fdataid= ?");
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> list = new HashSet<Long>(10);
                while (rs.next()) {
                    list.add(rs.getLong("fuseorgid"));
                }
                return list;
            }
        };
        Set result = (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql.toString(), (Object[])new Object[]{accountBankId}, (ResultSetHandler)action);
        return result;
    }

    public static Map<Long, Set<Long>> getUserAuthorityOrgsByAccIds(Set<Long> accountBankId, Set<Long> orgIds) {
        StringJoiner askStringJoiner = new StringJoiner(",");
        IntStream.rangeClosed(1, accountBankId.size()).forEach(i -> askStringJoiner.add("?"));
        String ksql = "select fuseorgid,fdataid from t_bd_accountbanks_u  where fdataid in (" + askStringJoiner.toString() + ")";
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler<Map<Long, Set<Long>>> action = new ResultSetHandler<Map<Long, Set<Long>>>(){

            public Map<Long, Set<Long>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Set<Long>> mapOfAccAndOrg = new HashMap<Long, Set<Long>>();
                while (rs.next()) {
                    Long dataid = rs.getLong("fdataid");
                    Long useorgid = rs.getLong("fuseorgid");
                    if (mapOfAccAndOrg.containsKey(dataid)) {
                        ((Set)mapOfAccAndOrg.get(dataid)).add(useorgid);
                        continue;
                    }
                    HashSet<Long> orgIdSet = new HashSet<Long>();
                    orgIdSet.add(useorgid);
                    mapOfAccAndOrg.put(dataid, orgIdSet);
                }
                return mapOfAccAndOrg;
            }
        };
        Map result = (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)ksql, (Object[])accountBankId.toArray(new Object[0]), (ResultSetHandler)action);
        return result;
    }

    private static String getString(Set<Long> accountBankId) {
        StringBuilder sb = new StringBuilder();
        for (Long accountBank : accountBankId) {
            sb.append(accountBank);
            sb.append(",");
        }
        String str = sb.toString();
        str = str.substring(0, str.lastIndexOf(","));
        return str;
    }

    public static DynamicObject[] getAccountBanksByCreateOrg(Long orgID) {
        QFilter[] qFilter = AccountBankHelper.getCreateOrgAccountFilter(orgID);
        return BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,openorg,createorg,bankaccountnumber", (QFilter[])qFilter);
    }

    public static Map<String, Boolean> isEntrustCanUseAccounts(Set<Long> orgIds, Set<Long> acctBankIds, Map<Long, Set<Long>> accBankIdAndOrgIdMap) {
        HashMap<String, Boolean> accBankBoolMap = new HashMap<String, Boolean>();
        HashSet<String> acctstatusSet = new HashSet<String>();
        acctstatusSet.add(ENUM_STATUS_NORMAL);
        acctstatusSet.add("freeze");
        QFilter qFilter = new QFilter("id", "in", acctBankIds);
        QFilter qFilter1 = new QFilter("acctstatus", "in", acctstatusSet);
        QFilter qFilter2 = qFilter.and(qFilter1);
        long startTime1 = System.currentTimeMillis();
        log.info(" acctstatus  start:" + startTime1);
        log.info(" acctstatus  orgIds is:" + SerializationUtils.toJsonString(orgIds));
        log.info(" acctstatus  acctBankIds is:" + SerializationUtils.toJsonString(acctBankIds));
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,company,acctstatus", (QFilter[])qFilter2.toArray());
        log.info(" acctstatus  end:" + (System.currentTimeMillis() - startTime1));
        Set<Long> theNextacctBankIds = accounts.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        log.info(" acctstatus  theNextacctBankIds is:" + SerializationUtils.toJsonString(theNextacctBankIds));
        for (Long bankId : acctBankIds) {
            if (theNextacctBankIds.contains(bankId)) continue;
            accBankBoolMap.put(String.valueOf(bankId), Boolean.FALSE);
        }
        if (theNextacctBankIds.size() > 0) {
            Set<Long> theLastSet = AccountBankHelper.validateAccountAuthByOrgs(orgIds, theNextacctBankIds, accBankBoolMap, false, new HashMap<Long, Long>());
            log.info(" acctstatus  theLastSet is:" + SerializationUtils.toJsonString(theLastSet));
            log.info(" acctstatus  orgIds after validateAccountAuthByOrgs is:" + SerializationUtils.toJsonString(orgIds));
            if (theLastSet.size() > 0) {
                HashMap<Long, DynamicObject> orgIdAndToorgMap = new HashMap<Long, DynamicObject>();
                HashMap<Long, Long> orgIdAndFromOrgIdMap = new HashMap<Long, Long>();
                QFilter fromOrgFilter = new QFilter("fromorg", "in", orgIds);
                QFilter numberFilter = new QFilter("typerelation.number", "=", (Object)"accounting2capital");
                QFilter isPreSetFilter = new QFilter("typerelation.ispreset", "=", (Object)"1");
                QFilter[] qFilters = fromOrgFilter.and(numberFilter).and(isPreSetFilter).toArray();
                AccountBankHelper.getToorgData(orgIdAndToorgMap, orgIdAndFromOrgIdMap, qFilters);
                log.info(" acctstatus  orgIdAndFromOrgIdMap is:" + SerializationUtils.toJsonString(orgIdAndFromOrgIdMap));
                if (orgIdAndFromOrgIdMap.size() > 0) {
                    Set<Long> toorgPkSet = orgIdAndFromOrgIdMap.keySet();
                    Set<Long> resultSet = AccountBankHelper.validateAccountAuthByOrgs(toorgPkSet, theLastSet, accBankBoolMap, true, orgIdAndFromOrgIdMap);
                    log.info("resultSet size is:" + resultSet.size());
                } else {
                    for (Long accBankId : theLastSet) {
                        accBankBoolMap.put(String.valueOf(accBankId), Boolean.FALSE);
                    }
                }
            }
        }
        return accBankBoolMap;
    }

    private static void getToorgData(Map<Long, DynamicObject> orgIdAndToorgMap, Map<Long, Long> orgIdAndFromOrgIdMap, QFilter[] qFilters) {
        Long startTime1 = System.currentTimeMillis();
        log.info(" getToorgData  start:" + startTime1);
        DynamicObject[] orgRelations = BusinessDataServiceHelper.load((String)"bos_org_orgrelation", (String)"toorg,fromorg", (QFilter[])qFilters);
        log.info(" getToorgData  end:" + (System.currentTimeMillis() - startTime1));
        Map<Long, List<DynamicObject>> orgIdSet = Arrays.stream(orgRelations).collect(Collectors.groupingBy(e -> e.getDynamicObject("fromorg").getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : orgIdSet.entrySet()) {
            DynamicObject data = entry.getValue().get(0);
            orgIdAndToorgMap.put(entry.getKey(), data);
            orgIdAndFromOrgIdMap.put(data.getDynamicObject("toorg").getLong("id"), entry.getKey());
        }
    }

    public static Set<Long> validateAccountAuthByOrgs(Set<Long> orgIds, Set<Long> acctBankIds, Map<String, Boolean> accBankBoolMap, Boolean isLasTime, Map<Long, Long> orgIdAndFromOrgIdMap) {
        HashSet<Long> theLastSet = new HashSet<Long>();
        Map<Long, Set<Long>> billAndDetailBenaMap = AccountBankHelper.getUserAuthorityOrgsByAccIds(acctBankIds, orgIds);
        log.info(" acctstatus  billAndDetailBenaMap is:" + SerializationUtils.toJsonString(billAndDetailBenaMap));
        for (Long accountBankId : acctBankIds) {
            if (null != billAndDetailBenaMap.get(accountBankId)) {
                Set<Long> datas = billAndDetailBenaMap.get(accountBankId);
                for (Long orgId : datas) {
                    if (isLasTime.booleanValue()) {
                        orgId = orgIdAndFromOrgIdMap.get(orgId);
                    }
                    if (!orgIds.contains(orgId)) continue;
                    String keyStr = accountBankId + "_" + orgId;
                    accBankBoolMap.put(keyStr, Boolean.TRUE);
                }
                continue;
            }
            if (!isLasTime.booleanValue()) {
                theLastSet.add(accountBankId);
                continue;
            }
            log.info(" validateAccountAuthByOrgs  accountBankId false:" + accountBankId);
            accBankBoolMap.put(String.valueOf(accountBankId), Boolean.FALSE);
        }
        return theLastSet;
    }

    public static void deleteIfmInnerBill(Set<Long> ifmBillId) {
        String targetEntityName = "ifm_accountacceptancebill";
        if (EmptyUtil.isNoEmpty(ifmBillId)) {
            QFilter qFilter = new QFilter("id", "in", ifmBillId);
            qFilter.and("billstatus", "=", (Object)"A");
            DynamicObjectCollection existTargetBills = QueryServiceHelper.query((String)"ifm_accountacceptancebill", (String)"id", (QFilter[])qFilter.toArray());
            if (existTargetBills.size() > 0) {
                ifmBillId = existTargetBills.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
                log.info(" deleteIfmInnerBill  ifmBillId is:{}", ifmBillId);
                TmcOperateServiceHelper.execOperate((String)"delete", (String)targetEntityName, (Object[])ifmBillId.toArray(), (OperateOption)OperateOption.create(), (boolean)true);
            }
        }
    }

    public static Set<Long> getElecPaymentRelatedAcctIds(Long currentAcctId) {
        Map elecPaymentMap = BusinessDataServiceHelper.loadFromCache((String)"am_accountbank", (String)"id, iselecpayment, relatedsettleacct", (QFilter[])new QFilter[]{new QFilter("iselecpayment", "=", (Object)true), new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()), new QFilter("id", "!=", (Object)currentAcctId)});
        Set<Long> acctSet = elecPaymentMap.values().stream().flatMap(acct -> acct.getDynamicObjectCollection("relatedsettleacct").stream().map(relatedAcct -> relatedAcct.getDynamicObject("fbasedataid").getLong("id"))).collect(Collectors.toSet());
        DynamicObjectCollection openingAccts = QueryServiceHelper.query((String)"am_accopenbill", (String)"id, iselecpayment, relatedsettleacct.fbasedataid.id", (QFilter[])new QFilter[]{new QFilter("iselecpayment", "=", (Object)true), new QFilter("billstatus", "!=", (Object)OpenAcctBillStatusEnum.E.getValue()), new QFilter("billstatus", "!=", (Object)OpenAcctBillStatusEnum.G.getValue()), new QFilter("billstatus", "!=", (Object)OpenAcctBillStatusEnum.C.getValue()), new QFilter("id", "!=", (Object)currentAcctId)});
        acctSet.addAll(openingAccts.stream().map(acct -> acct.getLong("relatedsettleacct.fbasedataid.id")).collect(Collectors.toSet()));
        return acctSet;
    }

    public static void setInnerAcctStatus(Set<Long> innerAcctId, String acctStatus) {
        if (!CollectionUtils.isEmpty(innerAcctId)) {
            DynamicObject[] innerAccountsAllFields;
            for (DynamicObject innerAccountsAllField : innerAccountsAllFields = BusinessDataServiceHelper.load((Object[])innerAcctId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_inneracct"))) {
                innerAccountsAllField.set("acctstatus", (Object)acctStatus);
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_inneracct", (DynamicObject[])innerAccountsAllFields, (OperateOption)OperateOption.create());
        }
    }
}

