/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.am.common.enums.AccountBankLogEnum;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.model.AcctBankLogModel;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class AcctBankLogHelper {
    public static AcctBankLogHelper getInstance() {
        return Singleton.INSTANCE;
    }

    public void addAcctBankLog(List<AcctBankLogModel> acctBankLogs, boolean fireCas) throws Exception {
        if (acctBankLogs.size() == 0) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(16);
                String sql = "INSERT INTO t_am_acctbank_log (fid, forgid, facctbankid, fcurrencyid, fisdeal, foperatetype, fcreatetime, faccname) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
                long[] ids = DBServiceHelper.genLongIds((String)"t_am_acctbank_log", (int)acctBankLogs.size());
                int i = 0;
                for (AcctBankLogModel acctBankLog : acctBankLogs) {
                    batchParam.add(new Object[]{ids[i], acctBankLog.getOrgId(), acctBankLog.getAccId(), acctBankLog.getCurrencyId(), Character.valueOf('0'), acctBankLog.getOperateType(), new Date(), acctBankLog.getAccountName()});
                    ++i;
                }
                DB.executeBatch((DBRoute)DBRouteConst.BASE, (String)sql, batchParam);
                tx.commit();
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        if (fireCas) {
            this.fireCASBankStatement();
        }
    }

    public void fireCASBankStatement() {
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"bankStatementCheckService", (String)"syncBankAccount2StatementByLog", (Object[])new Object[0]);
    }

    public void addAcctBankLogByDynamic(DynamicObject[] dynamicObjects, String operation) throws Exception {
        Long accountId;
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ArrayList<AcctBankLogModel> acctBankLogs = new ArrayList<AcctBankLogModel>(16);
        HashMap<Long, HashSet<Long>> usedOrgIds = new HashMap<Long, HashSet<Long>>(16);
        if (!AccountBankLogEnum.ACCOUNT_SAVE.getValue().equals(operation)) {
            List collect = Arrays.stream(dynamicObjects).map(o -> o.getPkValue()).collect(Collectors.toList());
            dynamicObjects = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id,company,currency,name", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
        } else {
            HashSet<Long> accountIds = new HashSet<Long>(16);
            DynamicObject[] dynamicObjectArray = dynamicObjects;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dataEntity = dynamicObjectArray[i];
                DynamicObject org = dataEntity.getDynamicObject("company");
                accountId = dataEntity.getLong("id");
                Long orgId = org.getLong("id");
                accountIds.add(accountId);
            }
            Map<Long, Set<Long>> usedIds = AccountBankHelper.getUserAuthorityOrgsByAccIds(accountIds, null);
            if (usedIds != null && usedIds.size() > 0) {
                for (Map.Entry<Long, Set<Long>> usedId : usedIds.entrySet()) {
                    Long accountId2 = usedId.getKey();
                    Set<Long> serIds = usedId.getValue();
                    HashSet<Long> orgIdSet = (HashSet<Long>)usedOrgIds.get(accountId2);
                    if (orgIdSet == null) {
                        orgIdSet = new HashSet<Long>(16);
                        usedOrgIds.put(accountId2, orgIdSet);
                    }
                    orgIdSet.addAll(serIds);
                }
            }
        }
        for (DynamicObject dataEntity : dynamicObjects) {
            DynamicObject org = dataEntity.getDynamicObject("company");
            Long orgId = org.getLong("id");
            accountId = dataEntity.getLong("id");
            String accountName = dataEntity.getString("name");
            DynamicObjectCollection currencies = dataEntity.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencies) {
                Long currencyId = currency.getLong("fbasedataid_id");
                Set orgIds = (Set)usedOrgIds.get(accountId);
                if (orgIds != null && orgIds.size() > 0) {
                    for (Long usedOrgId : orgIds) {
                        AcctBankLogModel acctBankLogModel = new AcctBankLogModel(usedOrgId, accountId, currencyId, operation, accountName);
                        acctBankLogs.add(acctBankLogModel);
                    }
                    continue;
                }
                AcctBankLogModel acctBankLogModel = new AcctBankLogModel(orgId, accountId, currencyId, operation, accountName);
                acctBankLogs.add(acctBankLogModel);
            }
        }
        this.addAcctBankLog(acctBankLogs, true);
    }

    static class Singleton {
        private static final AcctBankLogHelper INSTANCE = new AcctBankLogHelper();

        Singleton() {
        }
    }
}

