/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.common.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class AmCommonHelper {
    public static void showWebForm(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get("formId");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get("showType"), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        AmCommonHelper.openPage(showParameter, paramMap, formPlugin);
    }

    public static void showWebBase(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get("formId");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get("showType"), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        AmCommonHelper.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebBill(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get("formId");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        if (null != paramMap.get("pkValue")) {
            showParameter.setPkId(paramMap.get("pkValue"));
            showParameter.setStatusValue(OperationStatus.VIEW.getValue());
        }
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get("showType"), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        AmCommonHelper.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showFormList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId(paramMap.get("billFormId").toString());
        Object filters = paramMap.get("filters");
        List qFilters = filters == null ? null : (List)filters;
        List qFiltersCol = showParameter.getListFilterParameter().getQFilters();
        if (null != qFilters && qFilters.size() > 0) {
            qFiltersCol.addAll(qFilters);
        }
        formPlugin.getView().showForm((FormShowParameter)showParameter);
    }

    private static void openPage(FormShowParameter showParameter, Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap.get("formName") != null) {
            showParameter.setCaption((String)paramMap.get("formName"));
        }
        Boolean needCallBack = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get("needCallBack"), (Object)Boolean.FALSE);
        String formId = (String)paramMap.get("formId");
        if (needCallBack.booleanValue()) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, formId));
        }
        if (paramMap.get("customParam") != null) {
            Map customParam = (Map)paramMap.get("customParam");
            showParameter.getCustomParams().putAll(customParam);
        }
        formPlugin.getView().showForm(showParameter);
    }

    public static Long getBillIdByBillNo(String billType, String billNo) {
        ArrayList<String> type;
        long id = 0L;
        QFilter qFilters = null;
        qFilters = "am_accountbank".equalsIgnoreCase(billType) ? new QFilter("bankaccountnumber", "=", (Object)billNo) : ("bd_finorginfo".equalsIgnoreCase(billType) ? new QFilter("number", "=", (Object)billNo) : new QFilter("billno", "=", (Object)billNo));
        if ("cfm_loancontract_bl_l".equalsIgnoreCase(billType)) {
            billType = "cfm_loancontractbill";
            type = new ArrayList<String>();
            type.add("loan");
            type.add("sl");
            qFilters.and("loantype", "in", type);
        } else if ("cfm_loancontract_ic_l".equalsIgnoreCase(billType)) {
            billType = "cfm_loancontractbill";
            type = new ArrayList();
            type.add("ec");
            type.add("entrust");
            qFilters.and("loantype", "in", type);
        }
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((String)billType, (String)"id", (QFilter[])new QFilter[]{qFilters});
        if (dyObj != null) {
            id = dyObj.getLong("id");
        }
        return id;
    }
}

