/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.Pair;
import kd.tmc.am.common.helper.PeriodHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctHelper {
    public static Map<Object, DynamicObject> loadRelBill(String billType, Object bankAcctId) {
        List<QFilter> pFilters = BankAcctHelper.getFilter(billType, bankAcctId);
        Map relBills = TmcDataServiceHelper.loadFromCache((String)billType, (QFilter[])pFilters.toArray(new QFilter[pFilters.size()]));
        return relBills;
    }

    public static List<QFilter> getFilter(String billType, Object bankAcctId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter fb = new QFilter("billstatus", "in", (Object)BillStatusEnum.SUBMIT.getValue());
        QFilter fc = new QFilter("billstatus", "in", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter fe = new QFilter("billstatus", "in", (Object)BillStatusEnum.BEING.getValue());
        switch (billType) {
            case "cas_recbill": {
                filters.add(new QFilter("accountbank", "in", bankAcctId));
                filters.add(fb.or(fc));
                break;
            }
            case "cas_paybill": {
                filters.add(new QFilter("payeracctbank", "in", bankAcctId));
                filters.add(fb.or(fc).or(fe));
                break;
            }
            case "cas_agentpaybill": {
                filters.add(new QFilter("payeracctbank", "in", bankAcctId));
                filters.add(fb.or(fc).or(fe));
                break;
            }
        }
        return filters;
    }

    public static void showRelBillList(String billType, Object bankAcctId, AbstractFormPlugin formPlugin) {
        List<QFilter> filter = BankAcctHelper.getFilter(billType, bankAcctId);
        ListShowParameter sp = ShowFormHelper.createShowListForm((String)billType, (boolean)false);
        sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        sp.getOpenStyle().setInlineStyleCss(null);
        sp.setFormId("bos_list");
        sp.setLookUp(false);
        sp.getListFilterParameter().setQFilters(filter);
        sp.setCustomParam("isTrack", (Object)true);
        formPlugin.getView().showForm((FormShowParameter)sp);
    }

    public static boolean isInnerAcct(DynamicObject bankAcct) {
        DynamicObject innerAcc = bankAcct.getDynamicObject("inneracct");
        return innerAcc != null;
    }

    public static void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, IFormView view) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        view.showForm(param);
    }

    public static boolean isRefrenced(Object accId) {
        QFilter recAa = new QFilter("actpayaccount", "=", accId);
        QFilter recIa = new QFilter("inneraccount", "=", accId);
        QFilter recAt = new QFilter("accountbank", "=", accId);
        boolean casRec = QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{recAa.or(recIa).or(recAt)});
        if (casRec) {
            return true;
        }
        QFilter payIa = new QFilter("inneraccount", "=", accId);
        QFilter payPa = new QFilter("payeracctbank", "=", accId);
        boolean casPay = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{payIa.or(payPa)});
        if (casPay) {
            return true;
        }
        QFilter agePa = new QFilter("payeracctbank", "=", accId);
        boolean agentPay = QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])new QFilter[]{agePa});
        if (agentPay) {
            return true;
        }
        QFilter bjAb = new QFilter("accountbank", "=", accId);
        boolean bankJournal = QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])new QFilter[]{bjAb});
        if (bankJournal) {
            return true;
        }
        QFilter bsAb = new QFilter("accountbank", "=", accId);
        boolean bankStatement = QueryServiceHelper.exists((String)"cas_bankstatement", (QFilter[])new QFilter[]{bsAb});
        if (bankStatement) {
            return true;
        }
        QFilter trans = new QFilter("accountbank", "=", accId);
        boolean transDetail = QueryServiceHelper.exists((String)"bei_transdetail", (QFilter[])new QFilter[]{trans});
        if (transDetail) {
            return true;
        }
        QFilter balance = new QFilter("accountbank", "=", accId);
        boolean bankBalance = QueryServiceHelper.exists((String)"bei_bankbalance", (QFilter[])new QFilter[]{balance});
        if (bankBalance) {
            return true;
        }
        QFilter ba = new QFilter("bankaccount", "=", accId);
        QFilter da = new QFilter("draweraccount", "=", accId);
        boolean draftBill = QueryServiceHelper.exists((String)"cdm_draftbillf7", (QFilter[])new QFilter[]{ba.or(da)});
        return draftBill;
    }

    public static boolean isRefrenced(Object accId, Object userOrgId) {
        QFilter recAa = new QFilter("actpayaccount", "=", accId);
        QFilter recIa = new QFilter("inneraccount", "=", accId);
        QFilter recAt = new QFilter("accountbank", "=", accId);
        QFilter orgFilter = new QFilter("org", "=", userOrgId);
        boolean casRec = QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{orgFilter.and(recAa.or(recIa).or(recAt))});
        if (casRec) {
            return true;
        }
        QFilter payIa = new QFilter("inneraccount", "=", accId);
        QFilter payPa = new QFilter("payeracctbank", "=", accId);
        QFilter payOrgFilter = new QFilter("org", "=", userOrgId);
        boolean casPay = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{payOrgFilter.and(payIa.or(payPa))});
        if (casPay) {
            return true;
        }
        QFilter agePa = new QFilter("payeracctbank", "=", accId);
        QFilter agentOrgFilter = new QFilter("org", "=", userOrgId);
        boolean agentPay = QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])new QFilter[]{agentOrgFilter.and(agePa)});
        if (agentPay) {
            return true;
        }
        QFilter bjAb = new QFilter("accountbank", "=", accId);
        QFilter bankOrgFilter = new QFilter("org", "=", userOrgId);
        boolean bankJournal = QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])new QFilter[]{bankOrgFilter.and(bjAb)});
        if (bankJournal) {
            return true;
        }
        QFilter bsAb = new QFilter("accountbank", "=", accId);
        QFilter statementOrgFilter = new QFilter("org", "=", userOrgId);
        boolean bankStatement = QueryServiceHelper.exists((String)"cas_bankstatement", (QFilter[])new QFilter[]{statementOrgFilter.and(bsAb)});
        if (bankStatement) {
            return true;
        }
        QFilter trans = new QFilter("accountbank", "=", accId);
        QFilter transOrgFilter = new QFilter("company", "=", userOrgId);
        boolean transDetail = QueryServiceHelper.exists((String)"bei_transdetail", (QFilter[])new QFilter[]{transOrgFilter.and(trans)});
        if (transDetail) {
            return true;
        }
        QFilter balance = new QFilter("accountbank", "=", accId);
        QFilter balanceOrgFilter = new QFilter("company", "=", userOrgId);
        boolean bankBalance = QueryServiceHelper.exists((String)"bei_bankbalance", (QFilter[])new QFilter[]{balanceOrgFilter.and(balance)});
        if (bankBalance) {
            return true;
        }
        QFilter ba = new QFilter("bankaccount", "=", accId);
        QFilter da = new QFilter("draweraccount", "=", accId);
        QFilter draftOrgFilter = new QFilter("company", "=", userOrgId);
        boolean draftBill = QueryServiceHelper.exists((String)"cdm_draftbillf7", (QFilter[])new QFilter[]{draftOrgFilter.and(ba.or(da))});
        return draftBill;
    }

    public static boolean isUse(Object accId, Object useOrgId) {
        boolean use = BankAcctHelper.isRefrenced(accId, useOrgId);
        if (use) {
            return true;
        }
        QFilter accountQFilter = new QFilter("buyingaccount", "=", accId).or(new QFilter("sellingaccount", "=", accId));
        QFilter orgFilter = new QFilter("org", "=", useOrgId);
        boolean exchangeBill = QueryServiceHelper.exists((String)"cas_exchangebill", (QFilter[])new QFilter[]{orgFilter, accountQFilter});
        if (exchangeBill) {
            return true;
        }
        accountQFilter = new QFilter("payeracctbank", "=", accId);
        orgFilter = new QFilter("org", "=", useOrgId);
        boolean transHandleBill = QueryServiceHelper.exists((String)"ifm_transhandlebill", (QFilter[])new QFilter[]{accountQFilter, orgFilter});
        if (transHandleBill) {
            return true;
        }
        accountQFilter = new QFilter("entrys.subacct", "=", accId);
        orgFilter = new QFilter("entrys.subacct_company", "=", useOrgId);
        boolean transUpBill = QueryServiceHelper.exists((String)"fca_transupbill", (QFilter[])new QFilter[]{accountQFilter, orgFilter});
        if (transUpBill) {
            return true;
        }
        accountQFilter = new QFilter("accountbank", "=", accId);
        orgFilter = new QFilter("company", "=", useOrgId);
        boolean transDownBill = QueryServiceHelper.exists((String)"fca_transdownbill", (QFilter[])new QFilter[]{accountQFilter, orgFilter});
        return transDownBill;
    }

    public static boolean isExistBasicAccount(Object companyId, Object accId) {
        QFilter qFilter = new QFilter("company", "=", companyId);
        qFilter.and(new QFilter("id", "!=", accId));
        qFilter.and(new QFilter("acctstyle", "=", (Object)"basic"));
        qFilter.and(new QFilter("acctstatus", "!=", (Object)"closed"));
        return QueryServiceHelper.exists((String)"am_accountbank", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean checkMissBalanceAdjust(DynamicObject bankAccount, Date date, Date transferDate) {
        DynamicObject org = bankAccount.getDynamicObject("company");
        boolean haveBalanceAdjust = false;
        QFilter filterRecEdc = new QFilter("org", "=", org.getPkValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_rec_edc", (String)"id,recperiod,startperiod", (QFilter[])new QFilter[]{filterRecEdc});
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            return true;
        }
        DynamicObject recPeriod = dynamicObject.getDynamicObject("recperiod");
        if (EmptyUtil.isEmpty((DynamicObject)recPeriod)) {
            return true;
        }
        Date periodEndDate = recPeriod.getDate("enddate");
        if (transferDate.before(periodEndDate)) {
            return true;
        }
        Long periodId = PeriodHelper.getPeriodId(org.getLong("id"), date);
        if (EmptyUtil.isNoEmpty((Long)periodId)) {
            QFilter filter = new QFilter("org", "=", (Object)org.getLong("id")).and("bankaccount", "=", bankAccount.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("period", "=", (Object)periodId);
            haveBalanceAdjust = QueryServiceHelper.exists((String)"cas_balanceadjust", (QFilter[])new QFilter[]{filter});
        }
        return haveBalanceAdjust;
    }

    public static boolean existUnAuditAccountManageTransfer(Object pkValue) {
        QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", pkValue), new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())};
        return TmcDataServiceHelper.exists((String)"am_management_transfer", (QFilter[])filters);
    }

    public static DataSet updateAccountCurrency(QFilter[] filter, DataSet dataSet, String accountIdKey, String currencyKey) {
        DynamicObject[] accountArr = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,currency.fbasedataid.name", (QFilter[])filter);
        Map<Long, String> currencyMap = Arrays.stream(accountArr).map(a -> {
            DynamicObjectCollection currencyList = a.getDynamicObjectCollection("currency");
            if (CollectionUtils.isEmpty((Collection)currencyList)) {
                return new Pair((Object)a.getLong("id"), (Object)"");
            }
            List currencyNames = currencyList.stream().map(c -> c.getString("fbasedataid.name")).collect(Collectors.toList());
            return new Pair((Object)a.getLong("id"), (Object)String.join((CharSequence)",", currencyNames));
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        Algo algo = Algo.create((String)"updateCurrencyName");
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        Field[] fields = dataSet.getRowMeta().getFields();
        int fieldCount = dataSet.getRowMeta().getFieldCount();
        while (dataSet.hasNext()) {
            Object[] rowData = new Object[fieldCount];
            Row row = dataSet.next();
            for (int i = 0; i < fields.length; ++i) {
                if (currencyKey.equals(fields[i].getAlias())) {
                    Long bankAcctId = row.getLong(accountIdKey);
                    rowData[i] = currencyMap.get(bankAcctId);
                    continue;
                }
                rowData[i] = row.get(i);
            }
            datasetBuilder.append(rowData);
        }
        return datasetBuilder.build();
    }
}

