/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctManageHelp {
    public static Map<Long, String> changeManegeCheck(List<Long> ids, DynamicObject org) {
        DynamicObject[] dynamicObjects;
        HashMap<Long, String> returnMap = new HashMap<Long, String>(6);
        if (org == null || ids == null || ids.size() == 0) {
            return null;
        }
        for (DynamicObject acct : dynamicObjects = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"company,currency,number", (QFilter[])new QFilter("id", "in", ids).toArray())) {
            if (!BankAcctManageHelp.checkRef(acct)) {
                String msgA = ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u8d26\u6237%s\u5b58\u5728\u5f15\u7528\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9", (String)"BankAcctManageHelp_0", (String)"tmc-am-common", (Object[])new Object[]{acct.getString("number")});
                returnMap.put(acct.getLong("id"), msgA);
                continue;
            }
            if (!BankAcctManageHelp.isZeroBalance(acct)) {
                String msgB = ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u8d26\u6237%s\u65e5\u8bb0\u4f59\u989d\u4e0d\u4e3a\u96f6\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9", (String)"BankAcctManageHelp_1", (String)"tmc-am-common", (Object[])new Object[]{acct.getString("number")});
                returnMap.put(acct.getLong("id"), msgB);
                continue;
            }
            String msg = BankAcctManageHelp.comparePeriod(acct.getDynamicObject("company"), org, acct.getString("number"));
            if (!EmptyUtil.isNotEmpty((CharSequence)msg)) continue;
            returnMap.put(acct.getLong("id"), msg);
        }
        return returnMap;
    }

    public static List<String> bankAcctCloseCheck(DynamicObject bankAcct) {
        boolean isNeedCheck;
        DynamicObject company = bankAcct.getDynamicObject("company");
        ArrayList<String> errorMsgList = new ArrayList<String>(5);
        if (company != null && (isNeedCheck = AmParameterHelper.getAppBoolParameter(company.getLong("id"), "bankacctclosectrl"))) {
            String checkBillList = AmParameterHelper.getAppStringParameter(company.getLong("id"), "bankacctclosectrlitem");
            long bankAcctId = bankAcct.getLong("id");
            AmBizResource amBizResource = new AmBizResource();
            if (!EmptyUtil.isEmpty((String)checkBillList)) {
                boolean journalIsCheck;
                DynamicObjectCollection currencys;
                QFilter[] filters;
                DynamicObject cashMgtInit;
                Map<Object, DynamicObject> agentPayBills;
                Map<Object, DynamicObject> recBill;
                Object billNums;
                StringBuilder billNumStr;
                Map<Object, DynamicObject> payBill;
                if (checkBillList.indexOf(",pay,") > -1 && !CollectionUtils.isEmpty(payBill = BankAcctHelper.loadRelBill("cas_paybill", bankAcctId))) {
                    billNumStr = new StringBuilder();
                    for (Map.Entry<Object, DynamicObject> entry : payBill.entrySet()) {
                        billNumStr.append(entry.getValue().get("billno")).append(',');
                    }
                    billNums = billNumStr.substring(0, billNumStr.length() - 1);
                    errorMsgList.add(String.format(amBizResource.getCloseacctExistpbill() + "%s" + amBizResource.getCloseacctOpperror(), billNums));
                }
                if (checkBillList.indexOf(",rec,") > -1 && !CollectionUtils.isEmpty(recBill = BankAcctHelper.loadRelBill("cas_recbill", bankAcctId))) {
                    billNumStr = new StringBuilder();
                    for (Map.Entry<Object, DynamicObject> entry : recBill.entrySet()) {
                        billNumStr.append(entry.getValue().get("billno")).append(',');
                    }
                    billNums = billNumStr.substring(0, billNumStr.length() - 1);
                    errorMsgList.add(amBizResource.getCloseacctExistrbill() + (String)billNums + amBizResource.getCloseacctOprerror());
                }
                if (checkBillList.indexOf(",agent,") > -1 && !CollectionUtils.isEmpty(agentPayBills = BankAcctHelper.loadRelBill("cas_agentpaybill", bankAcctId))) {
                    billNumStr = new StringBuilder();
                    for (Map.Entry entry : agentPayBills.entrySet()) {
                        billNumStr.append(((DynamicObject)entry.getValue()).get("billno")).append(',');
                    }
                    billNums = billNumStr.substring(0, billNumStr.length() - 1);
                    errorMsgList.add(String.format(amBizResource.getCloseacctExistagentpbill() + "%s" + amBizResource.getCloseacctOpperror(), billNums));
                }
                if (checkBillList.indexOf(",cashmgtinit,") > -1 && (cashMgtInit = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (String)"id,startperiod,standardcurrency.id", (QFilter[])(filters = new QFilter[]{new QFilter("org", "=", (Object)bankAcct.getDynamicObject("company").getLong("id"))}))) != null && cashMgtInit.getDynamicObject("standardcurrency") != null && null != (currencys = bankAcct.getDynamicObjectCollection("currency"))) {
                    for (DynamicObject currency : currencys) {
                        BigDecimal balance = CasBusinessHelper.getBalanceFormCas((long)bankAcct.getDynamicObject("company").getLong("id"), (long)bankAcctId, (long)currency.getDynamicObject("fbasedataid").getLong("id"));
                        if (balance.compareTo(BigDecimal.ZERO) == 0) continue;
                        errorMsgList.add(amBizResource.getTipCasamt());
                        break;
                    }
                }
                if (checkBillList.indexOf(",journalcheck,") > -1 && !(journalIsCheck = CasBusinessHelper.journalIsCheck((DynamicObject)bankAcct))) {
                    errorMsgList.add(amBizResource.getTipCascheck());
                }
            }
        }
        return errorMsgList;
    }

    private static boolean checkRef(DynamicObject acct) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)acct.getDynamicObject("company").getLong("id"))};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
        if (dynamicObject == null) {
            return true;
        }
        DynamicObject currentPeriod = dynamicObject.getDynamicObject("currentperiod");
        if (currentPeriod == null) {
            return true;
        }
        Date startDate = currentPeriod.getDate("begindate");
        QFilter bizDateFilter = new QFilter("bizdate", ">=", (Object)startDate);
        QFilter bookDateFilter = new QFilter("bookdate", ">=", (Object)startDate);
        QFilter transDateFilter = new QFilter("transbilldate", ">=", (Object)startDate);
        QFilter payerAcctBankFilter = new QFilter("payeracctbank", "=", (Object)acct.getLong("id"));
        QFilter accountBankFilter = new QFilter("accountbank", "=", (Object)acct.getLong("id"));
        QFilter upOrDownFilter = new QFilter("accountbank", "=", (Object)acct.getLong("id"));
        QFilter upOrDownFilterSub = new QFilter("entrys.subacct", "=", (Object)acct.getLong("id"));
        QFilter exchangeFilter = new QFilter("buyingaccount", "=", (Object)acct.getLong("id")).or("sellingaccount", "=", (Object)acct.getLong("id")).or("paycommissionaccount", "=", (Object)acct.getLong("id"));
        Object[] casRec = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id", (QFilter[])new QFilter[]{bizDateFilter, accountBankFilter});
        if (EmptyUtil.isNoEmpty((Object[])casRec)) {
            return false;
        }
        Object[] casPay = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{bizDateFilter, payerAcctBankFilter});
        if (EmptyUtil.isNoEmpty((Object[])casPay)) {
            return false;
        }
        Object[] agentPay = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id", (QFilter[])new QFilter[]{bizDateFilter, payerAcctBankFilter});
        if (EmptyUtil.isNoEmpty((Object[])agentPay)) {
            return false;
        }
        Object[] bankJournal = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id", (QFilter[])new QFilter[]{bookDateFilter, accountBankFilter});
        if (EmptyUtil.isNoEmpty((Object[])bankJournal)) {
            return false;
        }
        Object[] exchangeBill = BusinessDataServiceHelper.load((String)"cas_exchangebill", (String)"id", (QFilter[])new QFilter[]{bizDateFilter, exchangeFilter});
        if (EmptyUtil.isNoEmpty((Object[])exchangeBill)) {
            return false;
        }
        Object[] upBill = BusinessDataServiceHelper.load((String)"fca_transupbill", (String)"id", (QFilter[])new QFilter[]{transDateFilter, upOrDownFilter});
        if (EmptyUtil.isNoEmpty((Object[])upBill)) {
            return false;
        }
        Object[] upBill1 = BusinessDataServiceHelper.load((String)"fca_transupbill", (String)"id", (QFilter[])new QFilter[]{transDateFilter, upOrDownFilterSub});
        if (EmptyUtil.isNoEmpty((Object[])upBill1)) {
            return false;
        }
        Object[] downBill = BusinessDataServiceHelper.load((String)"fca_transdownbill", (String)"id", (QFilter[])new QFilter[]{transDateFilter, upOrDownFilter});
        if (EmptyUtil.isNoEmpty((Object[])downBill)) {
            return false;
        }
        Object[] downBill1 = BusinessDataServiceHelper.load((String)"fca_transdownbill", (String)"id", (QFilter[])new QFilter[]{transDateFilter, upOrDownFilterSub});
        if (EmptyUtil.isNoEmpty((Object[])downBill1)) {
            return false;
        }
        Object[] bankStatement = BusinessDataServiceHelper.load((String)"cas_bankstatement", (String)"id", (QFilter[])new QFilter[]{bizDateFilter, accountBankFilter});
        if (EmptyUtil.isNoEmpty((Object[])bankStatement)) {
            return false;
        }
        Object[] transDetail = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id", (QFilter[])new QFilter[]{bizDateFilter, accountBankFilter});
        if (EmptyUtil.isNoEmpty((Object[])transDetail)) {
            return false;
        }
        Object[] elecreceipt = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id", (QFilter[])new QFilter[]{bizDateFilter, accountBankFilter});
        if (EmptyUtil.isNoEmpty((Object[])elecreceipt)) {
            return false;
        }
        Object[] ifmPay = BusinessDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id", (QFilter[])new QFilter[]{bizDateFilter, payerAcctBankFilter});
        if (EmptyUtil.isNoEmpty((Object[])ifmPay)) {
            return false;
        }
        QFilter filter = new QFilter("relationacc.fbasedataid.id", "in", (Object)acct.getLong("id"));
        Object[] exists = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id", (QFilter[])new QFilter[]{filter});
        return !EmptyUtil.isNoEmpty((Object[])exists);
    }

    private static boolean isZeroBalance(DynamicObject acct) {
        DynamicObjectCollection currencys = acct.getDynamicObjectCollection("currency");
        if (null != currencys) {
            for (int i = 0; i < currencys.size(); ++i) {
                DynamicObject currency = (DynamicObject)currencys.get(i);
                BigDecimal balance = CasBusinessHelper.getBalance((long)acct.getDynamicObject("company").getLong("id"), (long)acct.getLong("id"), (long)currency.getDynamicObject("fbasedataid").getLong("id"));
                if (balance.compareTo(BigDecimal.ZERO) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String comparePeriod(DynamicObject orgBefore, DynamicObject orgAfter, String acctNumber) {
        Date startDateB;
        String msg = "";
        if (orgBefore == null) {
            return msg;
        }
        QFilter[] filtersB = new QFilter[]{new QFilter("org", "=", (Object)orgBefore.getLong("id"))};
        QFilter[] filtersA = new QFilter[]{new QFilter("org", "=", (Object)orgAfter.getLong("id"))};
        DynamicObject dynamicObjectB = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filtersB);
        DynamicObject dynamicObjecA = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filtersA);
        DynamicObject currentPeriodB = dynamicObjectB.getDynamicObject("currentperiod");
        if (currentPeriodB == null) {
            return msg;
        }
        if (dynamicObjecA == null || dynamicObjecA.getDynamicObject("currentperiod") == null) {
            msg = ResManager.loadKDString((String)"\u76ee\u6807\u7ba1\u7406\u6743\u7ec4\u7ec7\u201c%s\u201d\u672a\u5b8c\u6210\u51fa\u7eb3\u521d\u59cb\u5316\uff0c\u8bf7\u5904\u7406\u3002", (String)"BankAcctManageHelp_3", (String)"tmc-am-common", (Object[])new Object[]{orgAfter.getString("name")});
            return msg;
        }
        DynamicObject currentPeriodA = dynamicObjecA.getDynamicObject("currentperiod");
        Date startDateA = currentPeriodA.getDate("begindate");
        if (startDateA.before(startDateB = currentPeriodB.getDate("begindate"))) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u8d26\u6237%s\u76ee\u6807\u521b\u5efa\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5c0f\u4e8e\u539f\u521b\u5efa\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"BankAcctManageHelp_2", (String)"tmc-am-common", (Object[])new Object[]{acctNumber});
        }
        return msg;
    }
}

