/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.fbp.common.enums.BankFuncEnum;

public class BankFunctionHelper {
    private static final Log LOGGER = LogFactory.getLog(BankFunctionHelper.class);

    private BankFunctionHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void upgrade(List<QFilter> filterList) {
        DynamicObject[] accountBanks;
        if (filterList == null || filterList.isEmpty()) {
            return;
        }
        ArrayList<Object> queryAccountIdList = new ArrayList<Object>();
        ArrayList<DynamicObject> queryList = new ArrayList<DynamicObject>();
        ArrayList<Object> payAccountIdList = new ArrayList<Object>();
        ArrayList<DynamicObject> payList = new ArrayList<DynamicObject>();
        ArrayList<Object> receiptAccountIdList = new ArrayList<Object>();
        ArrayList<DynamicObject> receiptList = new ArrayList<DynamicObject>();
        ArrayList<Object> ecdAccountIdList = new ArrayList<Object>();
        ArrayList<DynamicObject> ecdList = new ArrayList<DynamicObject>();
        ArrayList<Object> agentAccountIdList = new ArrayList<Object>();
        ArrayList<DynamicObject> agentList = new ArrayList<DynamicObject>();
        boolean isCover = (Boolean)SystemParamServiceHelper.getBillParameter((String)"am_accountbank", (String)"coveractualopendate");
        for (DynamicObject accountBank : accountBanks = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id,number,entry.id,entry.e_actualopendate,entry.e_billinfo,entry.e_enable,entry.e_bankfunction", (QFilter[])filterList.toArray(new QFilter[0]))) {
            DynamicObjectCollection entries = accountBank.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean("e_enable") || !isCover && entry.getDate("e_actualopendate") != null) continue;
                if (BankFuncEnum.QUERY.getValue().equals(entry.getString("e_bankfunction"))) {
                    queryAccountIdList.add(accountBank.getPkValue());
                    continue;
                }
                if (BankFuncEnum.PAY.getValue().equals(entry.getString("e_bankfunction"))) {
                    payAccountIdList.add(accountBank.getPkValue());
                    continue;
                }
                if (BankFuncEnum.RECEIPT.getValue().equals(entry.getString("e_bankfunction"))) {
                    receiptAccountIdList.add(accountBank.get("number"));
                    continue;
                }
                if (BankFuncEnum.ECD.getValue().equals(entry.getString("e_bankfunction"))) {
                    ecdAccountIdList.add(accountBank.getPkValue());
                    continue;
                }
                if (!BankFuncEnum.PROXYINQUIRY.getValue().equals(entry.getString("e_bankfunction"))) continue;
                agentAccountIdList.add(accountBank.getPkValue());
            }
        }
        QFilter filter1 = new QFilter("accountbank", "in", queryAccountIdList);
        Map<Object, Date> queryTransDetailMap = BankFunctionHelper.queryMinBizDateBill("bei_transdetail", "accountbank", "bizdate", filter1.toArray());
        Map<Object, Date> queryBankBalanceMap = BankFunctionHelper.queryMinBizDateBill("bei_bankbalance", "accountbank", "bizdate", filter1.toArray());
        QFilter filter2 = new QFilter("accountbank", "in", payAccountIdList);
        Map<Object, Date> bankPayBillMap = BankFunctionHelper.queryMinBizDateBill("bei_bankpaybill", "accountbank", "bizdate", filter2.toArray());
        Map<Object, Date> bankAgentPayBillMap = BankFunctionHelper.queryMinBizDateBill("bei_bankagentpay", "accountbank", "bizdate", filter2.toArray());
        Map<Object, Date> bankTransUpBillMap = BankFunctionHelper.queryMinBizDateBill("bei_banktransupbill", "accountbank", "bizdate", filter2.toArray());
        Map<Object, Date> bankTransDownBillMap = BankFunctionHelper.queryMinBizDateBill("bei_banktransdownbill", "accountbank", "bizdate", filter2.toArray());
        QFilter filter3 = new QFilter("accountbank", "in", ecdAccountIdList);
        Map<Object, Date> elecReceiptMap = BankFunctionHelper.queryMinBizDateBill("bei_elecreceipt", "accountbank", "bizdate", filter3.toArray());
        QFilter filter4 = new QFilter("conectno", "in", receiptAccountIdList);
        Map<Object, Date> cdmDelectronicRecDealMap = BankFunctionHelper.queryMinBizDateBill("cdm_electronic_rec_deal", "conectno", "bizdate", filter4.toArray());
        Map<Object, Date> cdmElectronicPayDealMap = BankFunctionHelper.queryMinBizDateBill("cdm_electronic_pay_deal", "conectno", "bizdate", filter4.toArray());
        Map<Object, Date> cdmElectronicSignDealMap = BankFunctionHelper.queryMinBizDateBill("cdm_electronic_sign_deal", "conectno", "bizdate", filter4.toArray());
        QFilter filter5 = new QFilter("accountbank", "in", agentAccountIdList);
        Map<Object, Date> agentTransDetailMap = BankFunctionHelper.queryMinBizDateBill("bei_transdetail", "accountbank", "bizdate", filter5.toArray());
        Map<Object, Date> agentBankBalanceMap = BankFunctionHelper.queryMinBizDateBill("bei_bankbalance", "accountbank", "bizdate", filter5.toArray());
        for (DynamicObject accountBank : accountBanks) {
            DynamicObjectCollection entries = accountBank.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                if (BankFuncEnum.QUERY.getValue().equals(entry.getString("e_bankfunction"))) {
                    LinkedHashMap<String, Date> dateMap1 = new LinkedHashMap<String, Date>();
                    dateMap1.put("bei_transdetail", queryTransDetailMap.get(accountBank.getPkValue()));
                    dateMap1.put("bei_bankbalance", queryBankBalanceMap.get(accountBank.getPkValue()));
                    BankFunctionHelper.setEntry(dateMap1, entry, accountBank, queryList);
                    continue;
                }
                if (BankFuncEnum.PAY.getValue().equals(entry.getString("e_bankfunction"))) {
                    LinkedHashMap<String, Date> dateMap2 = new LinkedHashMap<String, Date>();
                    dateMap2.put("bei_bankpaybill", bankPayBillMap.get(accountBank.getPkValue()));
                    dateMap2.put("bei_bankagentpay", bankAgentPayBillMap.get(accountBank.getPkValue()));
                    dateMap2.put("bei_banktransupbill", bankTransUpBillMap.get(accountBank.getPkValue()));
                    dateMap2.put("bei_banktransdownbill", bankTransDownBillMap.get(accountBank.getPkValue()));
                    BankFunctionHelper.setEntry(dateMap2, entry, accountBank, payList);
                    continue;
                }
                if (BankFuncEnum.RECEIPT.getValue().equals(entry.getString("e_bankfunction"))) {
                    LinkedHashMap<String, Date> dateMap3 = new LinkedHashMap<String, Date>();
                    dateMap3.put("bei_elecreceipt", elecReceiptMap.get(accountBank.getPkValue()));
                    BankFunctionHelper.setEntry(dateMap3, entry, accountBank, receiptList);
                    continue;
                }
                if (BankFuncEnum.ECD.getValue().equals(entry.getString("e_bankfunction"))) {
                    LinkedHashMap<String, Date> dateMap4 = new LinkedHashMap<String, Date>();
                    dateMap4.put("cdm_electronic_rec_deal", cdmDelectronicRecDealMap.get(accountBank.get("number")));
                    dateMap4.put("cdm_electronic_pay_deal", cdmElectronicPayDealMap.get(accountBank.get("number")));
                    dateMap4.put("cdm_electronic_sign_deal", cdmElectronicSignDealMap.get(accountBank.get("number")));
                    BankFunctionHelper.setEntry(dateMap4, entry, accountBank, ecdList);
                    continue;
                }
                if (!BankFuncEnum.PROXYINQUIRY.getValue().equals(entry.getString("e_bankfunction"))) continue;
                LinkedHashMap<String, Date> dateMap5 = new LinkedHashMap<String, Date>();
                dateMap5.put("bei_transdetail", agentTransDetailMap.get(accountBank.getPkValue()));
                dateMap5.put("bei_bankbalance", agentBankBalanceMap.get(accountBank.getPkValue()));
                BankFunctionHelper.setEntry(dateMap5, entry, accountBank, agentList);
            }
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        list.addAll(queryList);
        list.addAll(payList);
        list.addAll(receiptList);
        list.addAll(ecdList);
        list.addAll(agentList);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                h.markRollback();
                LOGGER.error("BankfunctionHelper_upgrade\uff1a", (Throwable)e);
            }
        }
    }

    public static Map<Object, Date> queryMinBizDateBill(String entityName, String groupFiled, String minField, QFilter[] filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)entityName, (String)entityName, (String)("id," + groupFiled + "," + minField), (QFilter[])filters, null);
        GroupbyDataSet group = dataSet.groupBy(new String[]{groupFiled});
        dataSet = group.min(minField).finish();
        HashMap<Object, Date> map = new HashMap<Object, Date>();
        for (Row row : dataSet) {
            map.put(row.get(groupFiled), row.getDate(minField));
        }
        return map;
    }

    public static Object[] getMinDate(Date ... dates) {
        Date min = dates[0];
        int minIndex = 0;
        Object[] objects = new Object[2];
        for (int i = 1; i < dates.length; ++i) {
            if (min == null) {
                minIndex = 1;
                min = dates[i];
                continue;
            }
            if (dates[i] == null) continue;
            minIndex = min.before(dates[i]) ? minIndex : i;
            min = min.before(dates[i]) ? min : dates[i];
        }
        objects[0] = minIndex;
        objects[1] = min;
        return objects;
    }

    private static void setEntry(Map<String, Date> dateMap, DynamicObject entry, DynamicObject accountBank, List<DynamicObject> saveList) {
        boolean isNonNull = dateMap.values().stream().anyMatch(Objects::nonNull);
        if (isNonNull) {
            Object[] minObjects = BankFunctionHelper.getMinDate(dateMap.values().toArray(new Date[0]));
            String[] nameList = dateMap.keySet().toArray(new String[0]);
            entry.set("e_billinfo", (Object)nameList[(Integer)minObjects[0]]);
            entry.set("e_actualopendate", minObjects[1]);
            saveList.add(accountBank);
        }
    }
}

