/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.am.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class OrgHelper {
    public static final String ORGTYPE_ACCOUNTING = "fisaccounting";
    public static final String ORGTYPE_SETTLEMENT = "fissettlement";
    public static final String ORGTYPE_BANKROLL = "fisbankroll";
    public static final String ORGTYPE_SALE = "fissale";
    public static final String NO_LEGAL_PERSON = "3";

    public static DynamicObject getAccountOrgByFundsOrg(DynamicObject fundsOrg) {
        if (null == fundsOrg) {
            return null;
        }
        DynamicObject accountOrg = null;
        boolean isAccount = fundsOrg.getBoolean(ORGTYPE_ACCOUNTING);
        if (isAccount) {
            DynamicObject tempSuperOrg;
            DynamicObject superOrg = fundsOrg;
            do {
                boolean isLegalPerson = false;
                DynamicObject orgpattern = superOrg.getDynamicObject("orgpattern");
                if (orgpattern != null) {
                    boolean bl = isLegalPerson = !NO_LEGAL_PERSON.equals((orgpattern = BusinessDataServiceHelper.loadSingle((Object)orgpattern.getPkValue(), (String)"bos_org_pattern", (String)"id, patterntype")).getString("patterntype"));
                }
                if (!isLegalPerson) continue;
                accountOrg = superOrg;
                break;
            } while (((tempSuperOrg = OrgHelper.getSuperiorBankOrg("10", superOrg.getLong("id"))) == null || tempSuperOrg.getLong("id") != fundsOrg.getLong("id")) && (superOrg = tempSuperOrg) != null);
        } else {
            try {
                Long orgid = OrgServiceHelper.getToOrg((String)ORGTYPE_BANKROLL, (String)ORGTYPE_ACCOUNTING, (Long)fundsOrg.getLong("id"), (Long)0L);
                accountOrg = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return accountOrg;
    }

    public static DynamicObject getSuperiorBankOrg(String attributes, long orgId) {
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)attributes, (long)orgId);
        if (superiorOrgs == null || superiorOrgs.size() < 1) {
            return null;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id, orgpattern", (QFilter[])new QFilter[]{new QFilter("id", "in", superiorOrgs.get(0))});
        return org;
    }

    public static Long getFisBankRollOrg(Long orgId, String appId, Long userId, String permission, String entityName) {
        DynamicObject currentOrg = OrgHelper.checkCurrentBankOrg(orgId);
        if (currentOrg != null && currentOrg.getBoolean(ORGTYPE_BANKROLL)) {
            return currentOrg.getLong("id");
        }
        List<Long> authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId(userId, appId = EmptyUtil.isNotEmpty((CharSequence)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"mon").getId(), entityName, permission);
        if (authorizedBankOrgId != null && !authorizedBankOrgId.isEmpty()) {
            return authorizedBankOrgId.get(0);
        }
        return null;
    }

    public static DynamicObject checkCurrentBankOrg(long orgId) {
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean(ORGTYPE_BANKROLL)) {
            return currentOrg;
        }
        return null;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_BANKROLL);
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String appId, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, appId, entityID, permissionItem, ORGTYPE_BANKROLL);
    }

    public static DynamicObjectCollection getAuthorizedAcctOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_ACCOUNTING);
    }

    public static DynamicObjectCollection getAuthorizedAcctOrg(Long userID, String appId, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, appId, entityID, permissionItem, ORGTYPE_ACCOUNTING);
    }

    private static DynamicObjectCollection getAuthorizedOrg(Long userID, String entityID, String permissionItem, String funType) {
        String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
        return OrgHelper.getAuthorizedOrg(userID, appId, entityID, permissionItem, funType);
    }

    private static DynamicObjectCollection getAuthorizedOrg(Long userID, String appId, String entityID, String permissionItem, String funType) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter functionFilter = new QFilter(funType, "=", (Object)"1");
        Map orgs = new HashMap();
        if (allPermOrgs.hasAllOrgPerm()) {
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = allPermOrgs.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgs.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String entityID, String permissionItem) {
        DynamicObjectCollection orgColl = OrgHelper.getAuthorizedBankOrg(userID, entityID, permissionItem);
        return OrgHelper.getIdList(orgColl);
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String appid, String entityID, String permissionItem) {
        DynamicObjectCollection orgColl = OrgHelper.getAuthorizedBankOrg(userID, appid, entityID, permissionItem);
        return OrgHelper.getIdList(orgColl);
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public static DynamicObject getOrgById(long id) {
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{id}, (String)"bos_org");
        return (DynamicObject)orgMap.get(id);
    }

    public static DynamicObject getBaseCurrency(long orgId) {
        try {
            return SystemStatusCtrolHelper.getStandardCurrency(orgId);
        }
        catch (KDBizException e) {
            return null;
        }
    }

    public static DynamicObject getOrgByNumber(String number) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter numFilter = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name,fisasset", (QFilter[])new QFilter[]{enableFilter, numFilter});
        if (null != orgs && orgs.size() > 0) {
            return (DynamicObject)orgs.get(0);
        }
        return null;
    }
}

