/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.common.helper.DynamicObjectHelper;
import kd.tmc.am.common.helper.PeriodHelper;

public class SystemStatusCtrolHelper {
    private static final Log logger = LogFactory.getLog(SystemStatusCtrolHelper.class);

    public static boolean isFinishInit(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null) {
            return false;
        }
        return systemStatusCtrol.getBoolean("isfinishinit");
    }

    public static boolean isFinishInitSetting(long orgId) {
        try {
            DynamicObject standardCurrency = SystemStatusCtrolHelper.getStandardCurrency(orgId);
            return standardCurrency != null;
        }
        catch (KDBizException e) {
            return false;
        }
    }

    public static List<Object> getBatchSystemStatusControl(Set<Long> orgIdList) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIdList)};
        Map result = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
        ArrayList<Object> isInitOrgList = new ArrayList<Object>(result.size());
        for (Map.Entry entry : result.entrySet()) {
            DynamicObject casInit = (DynamicObject)entry.getValue();
            isInitOrgList.add(casInit.getDynamicObject("org").getPkValue());
        }
        return isInitOrgList;
    }

    public static DynamicObject getCurrentPeriod(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null) {
            return null;
        }
        return systemStatusCtrol.getDynamicObject("currentperiod");
    }

    public static Map<Long, DynamicObject> getCurrentPeriod(Set<Long> orgIdS) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIdS)};
        DynamicObjectCollection idS = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        List pkList = idS.stream().map(item -> item.get("id")).collect(Collectors.toList());
        DynamicObject[] systemStatusCtrArr = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_cashmgtinit"));
        return Arrays.stream(systemStatusCtrArr).collect(Collectors.toMap(item -> item.getLong("org.id"), Function.identity(), (k1, k2) -> k1));
    }

    public static DynamicObject getPeriodType(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        return systemStatusCtrol == null ? null : systemStatusCtrol.getDynamicObject("periodtype");
    }

    public static DynamicObject getStartPeriod(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("startperiod") == null) {
            logger.info("\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01" + orgId);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"SystemStatusCtrolHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        return systemStatusCtrol.getDynamicObject("startperiod");
    }

    public static DynamicObject getStandardCurrency(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("standardcurrency") == null) {
            logger.info("\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01" + orgId);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"SystemStatusCtrolHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        return systemStatusCtrol.getDynamicObject("standardcurrency");
    }

    public static DynamicObject getExrateTable(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("exratetable") == null) {
            logger.info("\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01" + orgId);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"SystemStatusCtrolHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        return systemStatusCtrol.getDynamicObject("exratetable");
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
    }

    public static Map<String, DynamicObject> getSystemStatusCtrol(Set<Long> orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds)};
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])filters).values();
        HashMap<String, DynamicObject> orgMap = new HashMap<String, DynamicObject>();
        for (DynamicObject data : values) {
            String orgId = data.getString("org.id");
            if (orgMap.containsKey(orgId)) continue;
            orgMap.put(orgId, data);
        }
        return orgMap;
    }

    public static DynamicObject loadCashMgtInit(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObjectCollection cashMgitInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        if (cashMgitInitColl.size() == 0) {
            return null;
        }
        DynamicObject cashMgtInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cashMgitInitColl.get(0)).getLong("id"), (String)"cas_cashmgtinit");
        return cashMgtInit;
    }

    public static DynamicObject moveToNextPeriod(long orgId) {
        DynamicObject cashMgtInit = SystemStatusCtrolHelper.loadCashMgtInit(orgId);
        if (cashMgtInit == null) {
            return null;
        }
        DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod(currentPeriod.getLong("id"));
        DynamicObjectHelper.setValue(cashMgtInit, "currentperiod", nextPeriod);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashMgtInit});
        return nextPeriod;
    }

    public static DynamicObject moveToPrevPeriod(long orgId) {
        DynamicObject cashMgtInit = SystemStatusCtrolHelper.loadCashMgtInit(orgId);
        if (cashMgtInit == null) {
            return null;
        }
        DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
        if (currentPeriod == null) {
            return null;
        }
        DynamicObject prevPeriod = PeriodHelper.getPrevPeriod(currentPeriod.getLong("id"));
        DynamicObjectHelper.setValue(cashMgtInit, "currentperiod", prevPeriod);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashMgtInit});
        return prevPeriod;
    }
}

