/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.calc.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.report.bankacct.calc.IProcessStep;
import kd.tmc.am.report.bankacct.calc.ReportDataCalc;
import kd.tmc.am.report.bankacct.calc.process.OrgTreeCallback;

public class OrgTreeBuildProcess
implements IProcessStep {
    private Long companyViewId;
    private OrgTreeCallback callback;

    public OrgTreeBuildProcess() {
    }

    public OrgTreeBuildProcess(Long companyViewId, OrgTreeCallback callback) {
        this.companyViewId = companyViewId;
        this.callback = callback;
    }

    public void setCalcCallback(OrgTreeCallback callback) {
        this.callback = callback;
    }

    @Override
    public void process(List<ReportDataCalc> reportDataList) {
        List<ReportDataCalc> virtualDataList = this.createDismissOrgDataList(reportDataList);
        Map<Long, ReportDataCalc> orgIdToDataMap = Stream.concat(virtualDataList.stream(), reportDataList.stream()).collect(Collectors.toMap(o -> (Long)o.get("rowid"), ReportDataCalc::copy, (a, b) -> a));
        ArrayList<ReportDataCalc> orgDataList = new ArrayList<ReportDataCalc>(orgIdToDataMap.values());
        long[] virtualIdArr = DB.genGlobalLongIds((int)(reportDataList.size() + orgDataList.size() - virtualDataList.size()));
        LinkedList<Long> idList = new LinkedList<Long>();
        for (long id : virtualIdArr) {
            idList.add(id);
        }
        orgDataList.sort(Comparator.comparingInt(o -> (Integer)o.get("level")));
        HashMap<Long, Long> virtualIdMap = new HashMap<Long, Long>(orgDataList.size());
        for (ReportDataCalc reportDataCalc : orgDataList) {
            Boolean noData = (Boolean)reportDataCalc.get("no_data");
            reportDataCalc.set("is_leaf", Boolean.FALSE);
            reportDataCalc.set("isgroupnode", "1");
            if (Boolean.TRUE.equals(noData)) continue;
            Long newId = (Long)idList.pop();
            Long cId = (Long)reportDataCalc.get("rowid");
            ReportDataCalc virtualData = reportDataCalc.copy();
            virtualData.set("pid", cId);
            int cLevel = (Integer)virtualData.get("level");
            virtualData.set("level", cLevel + 1);
            virtualData.set("rowid", newId);
            virtualIdMap.put(cId, newId);
            orgIdToDataMap.put(newId, virtualData);
        }
        for (ReportDataCalc reportDataCalc : reportDataList) {
            Long id = (Long)reportDataCalc.get("rowid");
            Long virtualPDataId = (Long)virtualIdMap.get(id);
            ReportDataCalc pData = orgIdToDataMap.get(virtualPDataId);
            int pLevel = (Integer)pData.get("level");
            Long newId = (Long)idList.pop();
            reportDataCalc.set("rowid", newId);
            reportDataCalc.set("level", pLevel + 1);
            reportDataCalc.set("is_leaf", Boolean.TRUE);
            reportDataCalc.set("isgroupnode", "0");
            reportDataCalc.set("pid", virtualPDataId);
        }
        reportDataList.addAll(orgIdToDataMap.values());
        orgDataList.sort((o1, o2) -> (Integer)o2.get("level") - (Integer)o1.get("level"));
        if (this.callback != null) {
            this.callback.before(reportDataList);
        }
        for (ReportDataCalc reportData : reportDataList) {
            Long pid = (Long)reportData.get("pid");
            ReportDataCalc parent = orgIdToDataMap.get(pid);
            if (this.callback == null) continue;
            this.callback.visitChildData(parent, reportData);
        }
        if (this.callback != null) {
            this.callback.after(reportDataList);
        }
    }

    private List<ReportDataCalc> createDismissOrgDataList(List<ReportDataCalc> reportDataList) {
        HashSet<Long> orgIdSet = new HashSet<Long>(10);
        HashSet<Long> pOrgIdSet = new HashSet<Long>(10);
        for (ReportDataCalc reportData : reportDataList) {
            Long orgId = (Long)reportData.get("rowid");
            Long pOrgId = (Long)reportData.get("pid");
            orgIdSet.add(orgId);
            pOrgIdSet.add(pOrgId);
        }
        pOrgIdSet.removeAll(orgIdSet);
        ArrayList<ReportDataCalc> dismissDataList = new ArrayList<ReportDataCalc>(pOrgIdSet.size());
        if (pOrgIdSet.size() > 0) {
            QFilter tQFilter = new QFilter("org", "in", pOrgIdSet);
            if (this.companyViewId != null) {
                tQFilter.and("view.id", "=", (Object)this.companyViewId);
            } else {
                tQFilter.and("view.number", "=", (Object)"08");
            }
            String selectFields = "org rowid,org.name orgname,parent.id pid,parent.number pnumber,( case when isleaf='1' then '0' else '1' end ) isgroupnode,longnumber,level,sortcode";
            DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"tree-org", (String)"bos_org_structure", (String)selectFields, (QFilter[])tQFilter.toArray(), (String)"sortcode");
            String[] selector = (String[])Arrays.stream(orgDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            for (Row row : orgDataSet) {
                ReportDataCalc reportDataCalc = new ReportDataCalc();
                for (String key : selector) {
                    reportDataCalc.set(key, row.get(key));
                }
                reportDataCalc.set("no_data", Boolean.TRUE);
                dismissDataList.add(reportDataCalc);
            }
        }
        return dismissDataList;
    }
}

