/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.calc.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.am.report.bankacct.calc.IProcessStep;
import kd.tmc.am.report.bankacct.calc.IReportDataSetProcessor;
import kd.tmc.am.report.bankacct.calc.ReportDataCalc;

public class ReportDataSetProcessor
implements IReportDataSetProcessor {
    private List<IProcessStep> processorList = new ArrayList<IProcessStep>();
    private static Log logger = LogFactory.getLog(ReportDataSetProcessor.class);

    @Override
    public DataSet process(DataSet dataSet) {
        Algo algo = Algo.create((String)this.getClass().getName());
        String[] selector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        List<ReportDataCalc> dataList = this.createReportData(dataSet, selector);
        for (IProcessStep step : this.processorList) {
            step.process(dataList);
        }
        logger.info(dataList.toString());
        DataSet ds = this.transReportDataToDataSet(dataList, datasetBuilder, selector);
        return ds;
    }

    private List<ReportDataCalc> createReportData(DataSet dataSet, String[] selector) {
        ArrayList<ReportDataCalc> reportDataCalcList = new ArrayList<ReportDataCalc>();
        for (Row row : dataSet) {
            ReportDataCalc reportDataCalc = new ReportDataCalc();
            for (String key : selector) {
                reportDataCalc.set(key, row.get(key));
            }
            reportDataCalcList.add(reportDataCalc);
        }
        return reportDataCalcList;
    }

    private DataSet transReportDataToDataSet(List<ReportDataCalc> dataList, DataSetBuilder datasetBuilder, String[] selector) {
        for (ReportDataCalc reportDataCalc : dataList) {
            ArrayList objectList = new ArrayList(selector.length);
            for (String select : selector) {
                objectList.add(reportDataCalc.get(select));
            }
            datasetBuilder.append(objectList.toArray());
        }
        return datasetBuilder.build();
    }

    @Override
    public IReportDataSetProcessor registerProcess(IProcessStep step) {
        this.processorList.add(step);
        return this;
    }
}

