/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.tmc.am.report.bankacct.data.AcctStrategy;
import kd.tmc.fbp.common.util.DateUtils;

public abstract class AbstractAcctStrategy
implements AcctStrategy {
    private List<QFilter> filterList;
    protected DataSet dataSet;
    protected String[] order = new String[0];
    protected Map<String, Object> paramMap;
    private static final String[] STATARR1 = new String[]{"companyid", "bankcateid asc", "acctpropNumber asc", "change_date desc"};
    private static final String[] STATARR2 = new String[]{"openorgid", "bankcateid asc", "acctpropNumber asc", "change_date desc"};
    protected static final String SELECT = "company.id as companyid,company.name as company,openorg.name as openorg,openorg.id as openorgid,id as bankacctid,bankaccountnumber,name,acctname,acctproperty.number as acctpropNumber, acctproperty.name as acctprop,acctproperty.id as acctpropid,acctstyle,accttype,acctstatus,finorgtype,bank.name as bank,bank.id as bank_id,case when finorgtype='0' then bank.bank_cate.name else bank.name end as bankcate,case when finorgtype='0' then bank.bank_cate.id else bank.id end as bankcateid";

    public List<QFilter> getFilterList() {
        if (this.filterList == null) {
            this.filterList = new ArrayList<QFilter>();
        }
        return this.filterList;
    }

    public void setFilterList(List<QFilter> filterList) {
        this.filterList = new ArrayList<QFilter>(filterList);
    }

    public void setOrder(String dimension) {
        if ("company".equals(dimension)) {
            this.order = STATARR1;
        } else if ("openorg".equals(dimension)) {
            this.order = STATARR2;
        }
    }

    public String[] getOrder() {
        return this.order;
    }

    @Override
    public abstract AcctStrategy query();

    public abstract void setFilter();

    protected Date explainStartDate(String dateStr) {
        Date startDate = null;
        Timestamp currentTime = DateUtils.getCurrentTime();
        switch (dateStr) {
            case "thismonth": {
                startDate = DateUtils.getMinMonthDate((Date)new Date());
                break;
            }
            case "thisquarter": {
                startDate = DateUtils.getFirstSeasonDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "sixmonth": {
                startDate = DateUtils.getLastMonth((Date)currentTime, (int)6);
                break;
            }
            case "oneyear": {
                startDate = DateUtils.getLastYear((Date)currentTime, (int)1);
                break;
            }
            case "twoyear": {
                startDate = DateUtils.getLastYear((Date)currentTime, (int)2);
                break;
            }
        }
        return startDate;
    }

    protected Date explainEndDate(String dateStr) {
        Date endDate = new Date();
        switch (dateStr) {
            case "thismonth": {
                endDate = DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "thisquarter": {
                endDate = DateUtils.getLastSeasonDate((Date)DateUtils.getCurrentDate());
                break;
            }
        }
        return endDate;
    }

    @Override
    public AcctStrategy mergeDataSet(DataSet dataSet) {
        if (dataSet != null) {
            this.dataSet = this.mergeDataSet(dataSet, this.dataSet);
        }
        return this.build(this);
    }

    protected DataSet mergeDataSet(DataSet dataSet, DataSet dataSet2) {
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        for (Row row : dataSet) {
            datasetBuilder.append(row);
        }
        for (Row row : dataSet2) {
            datasetBuilder.append(row);
        }
        return datasetBuilder.build();
    }

    @Override
    public DataSet get() {
        return this.dataSet;
    }

    protected AcctStrategy build(AcctStrategy a) {
        return a;
    }

    @Override
    public DataSet operation() {
        return this.query().get();
    }
}

