/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.helper.BankFunctionHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class AcctBankFunctionDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String FILTER_ACCT_PURPOSE = "filter_acctpurpose";
    private static final String FILTER_BANK_CARE = "filter_bankcare";
    private static final String FILTER_BANK = "filter_bank";
    private static final String FILTER_ACCOUNT = "filter_account";
    private static final String FILTER_CURRENCIES = "filter_currencies";
    private static final String FILTER_ISCLOSED = "filter_isclosed";
    protected static final String SELECT = "company.name as company,company.id as companyid,openorg.name as openorg,id as bankacctid,bankaccountnumber,name,acctname ,bank.name as bank,bank.bebank.name as bebank,opendate,defaultcurrency,entry.e_bankfunction as bankfunction,entry.e_predictopendate as predictopendate,entry.e_actualopendate as actualopendate,entry.e_billinfo as billinfo";
    protected static final String[] ORDERS = new String[]{"companyid", "bankacctid asc"};

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map commFilter = queryParam.getFilter().getCommFilter();
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = this.getQueryOrgIds(queryParam);
        QFilter[] filter = AcctBankFunctionDataListPlugin.initBankAcctFilter(paramMap, orgIds);
        ArrayList<Object> filters = new ArrayList<Object>(commFilter.size());
        for (Map.Entry entry : commFilter.entrySet()) {
            filters.add(entry.getValue());
        }
        filters.addAll(Arrays.asList(filter));
        if (!EmptyUtil.isEmpty(paramMap.get("orgids"))) {
            filters.add(new QFilter("company.id", "in", paramMap.get("orgids")));
        }
        filters.add(new QFilter("issetbankinterface", "=", (Object)true));
        filters.add(new QFilter("entry.e_enable", "=", (Object)true));
        BankFunctionHelper.upgrade(filters);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"am_accountbank", (String)"am_accountbank", (String)SELECT, (QFilter[])filters.toArray(new QFilter[0]), null).orderBy(ORDERS);
        return dataSet;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    public static QFilter[] initBankAcctFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        QFilter finOrgFilter;
        QFilter filter = QingRptFilterParamHelper.initOrgFilter(paramMap, orgIds);
        if (filter == null) {
            filter = new QFilter("'1'", "=", (Object)"1");
        }
        ArrayList<Long> acctPurposeIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(FILTER_ACCT_PURPOSE))) {
            DynamicObjectCollection acctPurposes = (DynamicObjectCollection)paramMap.get(FILTER_ACCT_PURPOSE);
            for (DynamicObject acctPurpose : acctPurposes) {
                acctPurposeIds.add(acctPurpose.getLong("id"));
            }
        }
        if (!acctPurposeIds.isEmpty()) {
            filter.and(new QFilter("acctproperty.id", "in", acctPurposeIds));
        }
        if ((finOrgFilter = AcctBankFunctionDataListPlugin.initFinOrgFilter(paramMap)) != null) {
            filter.and(finOrgFilter);
        }
        ArrayList<Long> bankacctIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(FILTER_ACCOUNT))) {
            DynamicObjectCollection bankaccts = (DynamicObjectCollection)paramMap.get(FILTER_ACCOUNT);
            for (DynamicObject bankacct : bankaccts) {
                bankacctIds.add(bankacct.getLong("id"));
            }
        }
        if (!bankacctIds.isEmpty()) {
            filter.and(new QFilter("id", "in", bankacctIds));
        }
        if ("1".equals(paramMap.get(FILTER_ISCLOSED))) {
            filter.and("acctstatus", "=", (Object)"closed");
        }
        ArrayList<Long> currencyIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(FILTER_CURRENCIES))) {
            DynamicObjectCollection currencies = (DynamicObjectCollection)paramMap.get(FILTER_CURRENCIES);
            for (DynamicObject currency : currencies) {
                currencyIds.add(currency.getLong("id"));
            }
        }
        if (!currencyIds.isEmpty()) {
            filter.and(new QFilter("currency.fbasedataid.id", "in", currencyIds));
        }
        return new QFilter[]{filter};
    }

    private static QFilter initFinOrgFilter(Map<String, Object> paramMap) {
        QFilter filter = null;
        ArrayList<Long> bankIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(FILTER_BANK_CARE))) {
            for (DynamicObject bank : (DynamicObjectCollection)paramMap.get(FILTER_BANK_CARE)) {
                bankIds.add(bank.getLong("id"));
            }
        }
        if (!bankIds.isEmpty()) {
            filter = new QFilter("bank.bank_cate.id", "in", bankIds);
        }
        ArrayList<Long> finorgIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(FILTER_BANK))) {
            for (DynamicObject finorginfo : (DynamicObjectCollection)paramMap.get(FILTER_BANK)) {
                finorgIds.add(finorginfo.getLong("id"));
            }
        }
        if (!finorgIds.isEmpty()) {
            if (filter == null) {
                filter = new QFilter("bank.id", "in", finorgIds);
            } else {
                filter.and(new QFilter("bank.id", "in", finorgIds));
            }
        }
        return filter;
    }
}

