/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyChange;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyClose;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyFreeze;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyOpen;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class AcctChangeDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Map<String, String> V_TREE_BASE_COMPANY_MAP = new HashMap<String, String>(3);
    private static final Map<String, String> V_TREE_BASE_OPEN_ORG_MAP = new HashMap<String, String>(3);

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        Map commFilter = param.getFilter().getCommFilter();
        Map paramMap = this.transQueryParam(param);
        List orgIds = this.getQueryOrgIds(param);
        QFilter[] filter = QingRptFilterParamHelper.initBankAcctFilter(paramMap, orgIds);
        List<Object> changeList = new ArrayList<String>();
        if (!EmptyUtil.isEmpty(paramMap.get("filter_changetype"))) {
            String[] changeType = ((String)paramMap.get("filter_changetype")).split(",");
            changeList = Arrays.stream(changeType).filter(c -> !EmptyUtil.isEmpty((String)c)).collect(Collectors.toList());
        } else {
            changeList.add("open");
            changeList.add("close");
            changeList.add("change");
            changeList.add("freeze");
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(commFilter.size());
        for (Map.Entry entry : commFilter.entrySet()) {
            filters.add((QFilter)entry.getValue());
        }
        filters.addAll(Arrays.asList(filter));
        String statDimension = (String)paramMap.get("filter_statdim");
        DataSet dataSet = null;
        if (changeList.contains("open")) {
            ConcreteStrategyOpen open = new ConcreteStrategyOpen(filters, paramMap, statDimension);
            dataSet = open.query().mergeDataSet(dataSet).get();
        }
        if (changeList.contains("freeze")) {
            ConcreteStrategyFreeze freeze = new ConcreteStrategyFreeze(filters, paramMap, statDimension);
            dataSet = freeze.query().mergeDataSet(dataSet).get();
        }
        if (changeList.contains("change")) {
            ConcreteStrategyChange change = new ConcreteStrategyChange(filters, paramMap, statDimension);
            dataSet = change.query().mergeDataSet(dataSet).get();
        }
        if (changeList.contains("close")) {
            ConcreteStrategyClose close = new ConcreteStrategyClose(filters, paramMap, statDimension);
            dataSet = close.query().mergeDataSet(dataSet).get();
        }
        if (dataSet == null) {
            return null;
        }
        if ("org".equals(paramMap.get("filter_queryway"))) {
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"am", (String)"am_acctchgdetrpt", (String)"47150e89000000ac");
            dataSet = this.getTreeDataSet(dataSet, statDimension, null, orgIdList);
            dataSet = dataSet.orderBy(new String[]{"longnumber", "companyid", "changetype", "bankcateid desc", "acctpropNumber asc", "change_date desc"});
        } else if ("orgview".equals(paramMap.get("filter_queryway"))) {
            Long companyViewId = ((DynamicObject)paramMap.get("filter_orgview")).getLong("id");
            dataSet = this.getTreeDataSet(dataSet, statDimension, companyViewId, null);
            dataSet = dataSet.orderBy(new String[]{"longnumber", "openorgid", "changetype", "bankcateid desc", "acctpropNumber asc", "change_date desc"});
        }
        return dataSet;
    }

    private DataSet getTreeDataSet(DataSet dataSet, String statDimension, Long companyViewId, List<Long> orgIdList) {
        DataSet bizDs = dataSet.copy();
        String stat = "stat";
        ArrayList<String> statList = new ArrayList<String>();
        statList.add("stat");
        bizDs = bizDs.addField("1", "stat");
        if ("company".equals(statDimension)) {
            Map<String, String> vbizBaseMap = AcctDataListHelper.getBizBaseMap(bizDs, statList, V_TREE_BASE_COMPANY_MAP);
            bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "companyid", statList, V_TREE_BASE_COMPANY_MAP, vbizBaseMap, companyViewId, orgIdList);
            bizDs = AcctDataListHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
            bizDs = bizDs.updateField("bankaccountnumber", "case when bankaccountnumber='' then stat+'' else bankaccountnumber end");
        } else if ("openorg".equals(statDimension)) {
            Map<String, String> vbizBaseMap = AcctDataListHelper.getBizBaseMap(bizDs, statList, V_TREE_BASE_OPEN_ORG_MAP);
            bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "openorgid", statList, V_TREE_BASE_OPEN_ORG_MAP, vbizBaseMap, companyViewId, orgIdList);
            bizDs = AcctDataListHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
            bizDs = bizDs.updateField("bankaccountnumber", "case when bankaccountnumber='' then stat+'' else bankaccountnumber end");
        }
        return bizDs;
    }

    static {
        V_TREE_BASE_COMPANY_MAP.put("company", "orgname");
        V_TREE_BASE_COMPANY_MAP.put("companyid", "rowid");
        V_TREE_BASE_OPEN_ORG_MAP.put("openorg", "orgname");
        V_TREE_BASE_OPEN_ORG_MAP.put("openorgid", "rowid");
    }
}

