/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyBegin;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyChange;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyClose;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyEnd;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyFreeze;
import kd.tmc.am.report.bankacct.data.change.ConcreteStrategyOpen;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class AcctChangeSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Map<String, String> V_TREE_BASE_COMPANY_MAP = new HashMap<String, String>(3);
    private static final Map<String, String> V_TREE_BASE_OPEN_ORG_MAP = new HashMap<String, String>(3);

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam param, Object info) throws Throwable {
        Map paramMap = this.transQueryParam(param);
        String statDimension = (String)paramMap.get("filter_statdim");
        String stat = (String)paramMap.get("filter_stat");
        List orgIds = this.getQueryOrgIds(param);
        QFilter[] filter = QingRptFilterParamHelper.initBankAcctFilter(paramMap, orgIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(filter));
        ConcreteStrategyOpen open = new ConcreteStrategyOpen(filters, paramMap, statDimension);
        DataSet dataSet = open.query().get();
        ConcreteStrategyFreeze freeze = new ConcreteStrategyFreeze(filters, paramMap, statDimension);
        dataSet = freeze.query().mergeDataSet(dataSet).get();
        ConcreteStrategyChange change = new ConcreteStrategyChange(filters, paramMap, statDimension);
        dataSet = change.query().mergeDataSet(dataSet).get();
        ConcreteStrategyClose close = new ConcreteStrategyClose(filters, paramMap, statDimension);
        dataSet = close.query().mergeDataSet(dataSet).get();
        ConcreteStrategyBegin begin = new ConcreteStrategyBegin(filters, paramMap, statDimension);
        dataSet = begin.query().mergeDataSet(dataSet).get();
        ConcreteStrategyEnd end = new ConcreteStrategyEnd(filters, paramMap, statDimension);
        dataSet = end.query().mergeDataSet(dataSet).get();
        if (dataSet == null) {
            return null;
        }
        Long companyViewId = null;
        if ("orgview".equals(paramMap.get("filter_queryway"))) {
            companyViewId = ((DynamicObject)paramMap.get("filter_orgview")).getLong("id");
        }
        return this.getTreeDataSet(dataSet, statDimension, stat, companyViewId);
    }

    protected DataSet getTreeDataSet(DataSet bankAcctSet, String statDimension, String stat, Long companyViewId) {
        HashMap<String, String> vTreeBaseMap;
        ArrayList<String> bankAccountGroup = new ArrayList<String>();
        StringBuilder select = new StringBuilder();
        String rowId = "";
        switch (statDimension) {
            case "company": {
                bankAccountGroup.addAll(Arrays.asList("company", "companyid"));
                select.append("company,companyid");
                rowId = "companyid";
                vTreeBaseMap = V_TREE_BASE_COMPANY_MAP;
                break;
            }
            case "openorg": {
                bankAccountGroup.addAll(Arrays.asList("openorg", "openorgid"));
                select.append("openorg,openorgid");
                rowId = "openorgid";
                vTreeBaseMap = V_TREE_BASE_OPEN_ORG_MAP;
                break;
            }
            default: {
                vTreeBaseMap = new HashMap(1);
            }
        }
        ArrayList<String> statList = new ArrayList<String>(Arrays.asList("stat", "open", "closed", "change", "freeze", "begin_account", "end_account"));
        if (stat != null && stat.trim().length() != 0) {
            bankAccountGroup.add(stat);
            select.append(",").append(stat);
        }
        select.append(",(case when changetype = 'open' then 1 else 0 end) as open");
        select.append(",(case when changetype = 'close' then 1 else 0 end) as closed");
        select.append(",(case when changetype = 'change' then 1 else 0 end) as change");
        select.append(",(case when changetype = 'freeze' then 1 else 0 end) as freeze");
        select.append(",(case when changetype = 'begin' then 1 else 0 end) as begin");
        select.append(",(case when changetype = 'end' then 1 else 0 end) as end");
        DataSet bizDs = bankAcctSet.select(select.toString());
        GroupbyDataSet groupby = bizDs.groupBy(bankAccountGroup.toArray(new String[0]));
        groupby.sum("open", "open");
        groupby.sum("closed", "closed");
        groupby.sum("change", "change");
        groupby.sum("freeze", "freeze");
        groupby.sum("begin", "begin_account");
        groupby.sum("end", "end_account");
        bizDs = groupby.finish();
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"am", (String)"am_acctchgsumrpt", (String)"47150e89000000ac");
        bizDs = bizDs.addField("1", "stat");
        Map<String, String> vbizBaseMap = AcctDataListHelper.getBizBaseMap(bizDs, statList, vTreeBaseMap);
        bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", rowId, statList, vTreeBaseMap, vbizBaseMap, companyViewId, orgIdList);
        bizDs = AcctDataListHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
        bizDs = bizDs.orderBy(new String[]{"longnumber"});
        return bizDs;
    }

    static {
        V_TREE_BASE_COMPANY_MAP.put("company", "orgname");
        V_TREE_BASE_COMPANY_MAP.put("companyid", "rowid");
        V_TREE_BASE_OPEN_ORG_MAP.put("openorg", "orgname");
        V_TREE_BASE_OPEN_ORG_MAP.put("openorgid", "rowid");
    }
}

