/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class AcctDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private QFilter[] filter = null;
    private Long companyViewId = null;
    private static final String[] statArr1 = new String[]{"companyid", "finorgtype asc", "bankcateid asc", "acctpropNumber asc", "opendate desc"};
    private static final String[] statArr2 = new String[]{"openorgid", "finorgtype asc", "bankcateid asc", "acctpropNumber asc", "opendate desc"};
    private static final String[] statArr3 = new String[]{"acctpropNumber asc", "openorg", "finorgtype asc", "bankcateid asc", "acctprop asc", "opendate desc"};
    private static final String[] statArr4 = new String[]{"finorgtype asc", "bankcateid asc", "openorg", "opendate desc"};
    private static final String[] statArr5 = new String[]{"cityid", "finorgtype asc", "bankcateid asc", "openorg", "opendate desc"};

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        DataSet dataSet = null;
        Map commFilter = param.getFilter().getCommFilter();
        Map paramMap = this.transQueryParam(param);
        List orgIds = this.getQueryOrgIds(param);
        this.filter = QingRptFilterParamHelper.initBankAcctFilter(paramMap, orgIds);
        commFilter.remove("filter_openorg");
        commFilter.remove("filter_org");
        ArrayList<Object> filters = new ArrayList<Object>(commFilter.size());
        for (Map.Entry entry : commFilter.entrySet()) {
            filters.add(entry.getValue());
        }
        filters.addAll(Arrays.asList(this.filter));
        this.filter = filters.toArray(new QFilter[filters.size()]);
        if ("orgview".equals(paramMap.get("filter_queryway"))) {
            this.companyViewId = ((DynamicObject)paramMap.get("filter_orgview")).getLong("id");
        }
        String statdim = (String)paramMap.get("statdim");
        String[] orderArr = null;
        String groupColumn = null;
        String countColumn = "";
        String sumColumn = null;
        String totalSumCol = "";
        switch (statdim) {
            case "company": {
                orderArr = statArr1;
                groupColumn = "companyid";
                countColumn = "openorg";
                sumColumn = "bankcate";
                totalSumCol = "company";
                break;
            }
            case "openorg": {
                orderArr = statArr2;
                groupColumn = "openorgid";
                countColumn = "company";
                sumColumn = "bankcate";
                totalSumCol = "openorg";
                break;
            }
            case "acctprop": {
                orderArr = statArr3;
                groupColumn = "acctpropid";
                countColumn = "openorg";
                sumColumn = "company";
                totalSumCol = "acctprop";
                break;
            }
            case "finorg": {
                orderArr = statArr4;
                groupColumn = "bankcateid";
                countColumn = "company";
                sumColumn = "bank";
                totalSumCol = "bankcate";
                break;
            }
            case "finorg_prop": {
                orderArr = statArr5;
                groupColumn = "cityid";
                countColumn = "bank";
                sumColumn = "bankcate";
                totalSumCol = "city";
            }
        }
        dataSet = this.queryData(this.filter, orderArr);
        if (Arrays.asList("company", "openorg").contains(statdim)) {
            dataSet = this.getTreeDataSet(dataSet, statdim);
            dataSet = dataSet.orderBy(new String[]{"longnumber"});
            return dataSet;
        }
        DataSet subToDataSet = this.buildSubtoDataSet(dataSet, groupColumn, countColumn, sumColumn);
        DataSet toTalDataSet = this.buildTotalDataSet(dataSet, totalSumCol, countColumn);
        DataSet resultDataSet = this.mergeSubToDataSet(dataSet, subToDataSet, groupColumn);
        resultDataSet = this.mergeTotalDataSet(resultDataSet, toTalDataSet);
        resultDataSet = AcctDataListHelper.getBizDsUpOrgTree(resultDataSet);
        return resultDataSet;
    }

    private DataSet getTreeDataSet(DataSet dataSet, String statdim) {
        DataSet bizDs = dataSet.copy();
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"am", (String)"am_acctdetlrpt", (String)"47150e89000000ac");
        String stat = "stat";
        ArrayList<String> statList = new ArrayList<String>();
        statList.add("stat");
        if ("company".equals(statdim)) {
            bizDs = bizDs.addField("1", "stat");
            HashMap<String, String> vTreeBaseMap = new HashMap<String, String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("company", "orgname");
                    this.put("companyid", "rowid");
                }
            };
            Map<String, String> vbizBaseMap = AcctDataListHelper.getBizBaseMap(bizDs, statList, (Map<String, String>)vTreeBaseMap);
            vbizBaseMap.put("finorgtype", "'-1'");
            bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "companyid", statList, (Map<String, String>)vTreeBaseMap, vbizBaseMap, this.companyViewId, orgIdList);
            bizDs = AcctDataListHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
            bizDs = bizDs.updateField("bankaccountnumber", "case when bankaccountnumber='' then stat+'' else bankaccountnumber end");
        } else if ("openorg".equals(statdim)) {
            bizDs = bizDs.addField("1", "stat");
            HashMap<String, String> vTreeBaseMap = new HashMap<String, String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("openorg", "orgname");
                    this.put("openorgid", "rowid");
                }
            };
            Map<String, String> vbizBaseMap = AcctDataListHelper.getBizBaseMap(bizDs, statList, (Map<String, String>)vTreeBaseMap);
            vbizBaseMap.put("finorgtype", "'-1'");
            bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "openorgid", statList, (Map<String, String>)vTreeBaseMap, vbizBaseMap, this.companyViewId, orgIdList);
            bizDs = AcctDataListHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
            bizDs = bizDs.updateField("bankaccountnumber", "case when bankaccountnumber='' then stat+'' else bankaccountnumber end");
        }
        return bizDs;
    }

    private String getSelcetFileds() {
        String bankAcctSic = "company.id as companyid,company.name as company,openorg.name as openorg,openorg.id as openorgid,id as bankacctid,bankaccountnumber,name,acctname,acctproperty.number as acctpropNumber, acctproperty.name as acctprop,acctproperty.id as acctpropid, currencyname,defaultcurrency.name as defcurrency,acctstyle,accttype,opendate,closedate,acctstatus,manager.name as manager,0 as summarytype,finorgtype,bank.city.name as city,bank.city.id as cityid,bank.name as bank,case when finorgtype='1' then 'NA' else issetbankinterface end as issetbankinterface,case when finorgtype='0' then bank.bank_cate.name else bank.name end as bankcate,case when finorgtype='0' then bank.bank_cate.id else bank.id end as bankcateid";
        return bankAcctSic;
    }

    private DataSet buildTotalDataSet(DataSet dataSet, String totalSumCol, String countColumn) {
        DataSet totakDataSet = dataSet.copy();
        totakDataSet = totakDataSet.groupBy(null).count(countColumn).finish();
        Field[] groupFields = totakDataSet.getRowMeta().getFields();
        HashSet groupFieldsSet = new HashSet();
        Stream.of(groupFields).forEach(record -> groupFieldsSet.add(record.getAlias()));
        Field[] reportAllFields = dataSet.getRowMeta().getFields();
        ArrayList<String> groupSelectFields = new ArrayList<String>(reportAllFields.length);
        for (Field field : reportAllFields) {
            String fieldName;
            String emptyField = fieldName = field.getAlias();
            if (!groupFieldsSet.contains(fieldName)) {
                emptyField = "null as " + fieldName;
                if (totalSumCol.equalsIgnoreCase(fieldName)) {
                    emptyField = "'" + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AcctDetailDataListPlugin_2", (String)"tmc-am-report", (Object[])new Object[0]) + "'" + "as" + fieldName;
                }
                if ("summarytype".equalsIgnoreCase(fieldName)) {
                    emptyField = String.format("%s as %s", "1", fieldName);
                }
                if (countColumn.equalsIgnoreCase(fieldName)) {
                    emptyField = fieldName;
                }
            }
            groupSelectFields.add(emptyField);
        }
        totakDataSet = totakDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()]));
        return totakDataSet;
    }

    private DataSet mergeTotalDataSet(DataSet dataSet, DataSet totalDataSet) {
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        for (Row row : dataSet) {
            datasetBuilder.append(row);
        }
        for (Row row : totalDataSet) {
            datasetBuilder.append(row);
        }
        return datasetBuilder.build();
    }

    private DataSet mergeSubToDataSet(DataSet dataSet, DataSet subToDataSet, String countColumn) {
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        String prevRecordName = "";
        Row subToRecordRow = null;
        Row currGroupRecord = null;
        for (Row mainRecord : dataSet) {
            DataSet groupDataSet1 = subToDataSet.copy();
            DataSet groupDataSet2 = subToDataSet.copy();
            String currCountCol = mainRecord.getString(countColumn);
            for (Row groupRow : groupDataSet1) {
                String groupRowCountCol = groupRow.getString(countColumn);
                if (!Objects.equals(currCountCol, groupRowCountCol)) continue;
                currGroupRecord = groupRow;
                break;
            }
            if (null != currGroupRecord && "".equals(prevRecordName)) {
                prevRecordName = currGroupRecord.getString(countColumn);
            }
            if (prevRecordName == null || currCountCol == null || currGroupRecord == null) continue;
            if (Objects.equals(currCountCol, prevRecordName)) {
                datasetBuilder.append(mainRecord);
            } else {
                for (Row groupRow : groupDataSet2) {
                    String groupcountColumn = groupRow.getString(countColumn);
                    if (!prevRecordName.equals(groupcountColumn)) continue;
                    subToRecordRow = groupRow;
                    break;
                }
                datasetBuilder.append(subToRecordRow);
                datasetBuilder.append(mainRecord);
            }
            prevRecordName = currCountCol;
        }
        if (null != currGroupRecord) {
            datasetBuilder.append(currGroupRecord);
        }
        return datasetBuilder.build();
    }

    private DataSet buildSubtoDataSet(DataSet dataSet, String groupColumn, String countColumn, String sumColumn) {
        DataSet groupDataSet = dataSet.copy();
        groupDataSet = groupDataSet.groupBy(new String[]{groupColumn}).count(countColumn).finish();
        Field[] groupFields = groupDataSet.getRowMeta().getFields();
        HashSet groupFieldsSet = new HashSet();
        Stream.of(groupFields).forEach(record -> groupFieldsSet.add(record.getAlias()));
        Field[] reportAllFields = dataSet.getRowMeta().getFields();
        ArrayList<String> groupSelectFields = new ArrayList<String>(reportAllFields.length);
        for (Field field : reportAllFields) {
            String fieldName;
            String emptyField = fieldName = field.getAlias();
            if (!groupFieldsSet.contains(fieldName)) {
                emptyField = "null as " + fieldName;
                if (sumColumn.equalsIgnoreCase(fieldName)) {
                    emptyField = "'" + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AcctDetailDataListPlugin_3", (String)"tmc-am-report", (Object[])new Object[0]) + "'" + "as" + fieldName;
                }
                if ("summarytype".equalsIgnoreCase(fieldName)) {
                    emptyField = String.format("%s as %s", "2", fieldName);
                }
                if (groupColumn.equals(fieldName) || countColumn.equalsIgnoreCase(fieldName)) {
                    emptyField = fieldName;
                }
            }
            groupSelectFields.add(emptyField);
        }
        groupDataSet = groupDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()]));
        return groupDataSet;
    }

    private DataSet queryData(QFilter[] filter, String[] orderArr) {
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctDtl", (String)"bd_accountbanks", (String)this.getSelcetFileds(), (QFilter[])filter, null).orderBy(orderArr);
        return BankAcctHelper.updateAccountCurrency((QFilter[])filter, (DataSet)bankAcctSet, (String)"bankacctid", (String)"currencyname");
    }
}

