/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.enums.AcctStyleEnum;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class AcctSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private QFilter[] filter = null;
    private Long companyViewId = null;
    private static final String[] companygf = new String[]{"company", "bank_cate", "finorgtype"};
    private static final String[] companyof = new String[]{"number asc", "company desc", "finorgtype asc", "bank_cate asc"};
    private static final String[] openorggf = new String[]{"openorg", "bank_cate", "finorgtype"};
    private static final String[] openorgof = new String[]{"number asc", "openorg desc", "finorgtype asc", "bank_cate desc"};
    private static final String[] finorggf = new String[]{"bank_cate", "finorginfo", "finorgtype"};
    private static final String[] finorgof = new String[]{"number asc", "finorgtype asc", "bank_cate desc"};
    private static final String[] finorg_propgf = new String[]{"country", "province", "cityid", "city", "bank_cate", "finorgtype"};
    private static final String[] finorg_propof = new String[]{"countrynumber desc", "number desc", "citynumber desc", "finorgtype asc"};

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam param, Object info) throws Throwable {
        DataSet bizDs = null;
        Map paramMap = this.transQueryParam(param);
        String statdim = (String)paramMap.get("statdim");
        List orgIds = this.getQueryOrgIds(param);
        this.filter = QingRptFilterParamHelper.initBankAcctFilter(paramMap, orgIds);
        if ("orgview".equals(paramMap.get("filter_queryway"))) {
            this.companyViewId = ((DynamicObject)paramMap.get("filter_orgview")).getLong("id");
        }
        String[] groupField = null;
        String allTotalFieldName = null;
        String[] orderByField = null;
        String sumNameField = "";
        switch (statdim) {
            case "company": {
                bizDs = this.queryData_ByCompany(this.filter);
                allTotalFieldName = "company";
                groupField = companygf;
                orderByField = companyof;
                sumNameField = "bank_cate";
                break;
            }
            case "openorg": {
                bizDs = this.queryData_ByOpenOrg(this.filter);
                allTotalFieldName = "openorg";
                groupField = openorggf;
                orderByField = openorgof;
                sumNameField = "bank_cate";
                break;
            }
            case "finorg": {
                bizDs = this.queryData_ByFinOrgInfo(this.filter);
                allTotalFieldName = "bank_cate";
                groupField = finorggf;
                orderByField = finorgof;
                sumNameField = "bank_cate";
                break;
            }
            case "finorg_prop": {
                bizDs = this.queryData_ByFinOrgProp(this.filter);
                allTotalFieldName = "country";
                groupField = finorg_propgf;
                orderByField = finorg_propof;
                sumNameField = "province";
            }
        }
        DataSet dimenBizDs = this.addStatDimensionData(bizDs, groupField).orderBy(orderByField);
        DataSet mergeDs = null;
        if (Arrays.asList("company", "openorg").contains(statdim)) {
            List<String> gruopFields = Collections.singletonList("longnumber");
            mergeDs = dimenBizDs.orderBy(gruopFields.toArray(new String[gruopFields.size()]));
        } else {
            Field[] dimenDsFields;
            ArrayList<String> sumFields = new ArrayList<String>();
            sumFields.add("stat");
            HashSet<String> bizFieldSet = new HashSet<String>(10);
            if (bizDs != null) {
                Field[] bizDsFields;
                for (Field field : bizDsFields = bizDs.getRowMeta().getFields()) {
                    bizFieldSet.add(field.getName());
                }
            }
            for (Field field : dimenDsFields = dimenBizDs.getRowMeta().getFields()) {
                if (bizFieldSet.contains(field.getName())) continue;
                sumFields.add(field.getName());
            }
            List<String> gruopFields = Collections.singletonList("number");
            DataSet subTotalDs = this.addSubTotalDataSet(dimenBizDs, gruopFields, sumFields, sumNameField);
            bizDs = dimenBizDs.union(subTotalDs).orderBy(gruopFields.toArray(new String[gruopFields.size()]));
            DataSet totalDs = this.addAllTotalDataSet(bizDs, sumFields, allTotalFieldName);
            mergeDs = bizDs.union(totalDs);
            mergeDs = AcctDataListHelper.getBizDsUpOrgTree(mergeDs);
        }
        mergeDs = this.validationColumn(mergeDs);
        if (String.valueOf(paramMap.getOrDefault("filter_stat", "")).contains("group_bankinterface")) {
            mergeDs = mergeDs.addField("case when (bankinterface_true + bankinterface_false)=0 then 0 else (( bankinterface_true * 100 / (bankinterface_true + bankinterface_false) * 100 ) / 100) end", "bankinterface_rate");
        }
        return mergeDs;
    }

    private DataSet validationColumn(DataSet ds) {
        Field[] fields = ds.getRowMeta().getFields();
        HashSet<String> fieldSet = new HashSet<String>(fields.length);
        for (Field field : fields) {
            fieldSet.add(field.getName());
        }
        String selectFields = String.join((CharSequence)",", fieldSet.toArray(new String[0]));
        if (!fieldSet.contains("bankinterface_true")) {
            ds = ds.copy().select(selectFields + ",0 as bankinterface_true");
            selectFields = selectFields + ",bankinterface_true";
        }
        if (!fieldSet.contains("bankinterface_false")) {
            ds = ds.copy().select(selectFields + ",0 as bankinterface_false");
        }
        return ds;
    }

    protected DataSet queryData_ByCompany(QFilter[] filter) {
        String bankAcctSic = "company.id companyid,finorgtype,company.number number,company.name company, case when finorgtype='0' then bank.bank_cate.name else bank.name end as bank_cate, 0 sumlevel";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, null);
        List<String> bankAcctgb = Arrays.asList("number", "company", "finorgtype", "bank_cate", "companyid", "sumlevel");
        String stat = "stat";
        DataSet bizDs = bankAcctSet.groupBy(bankAcctgb.toArray(new String[0])).count("stat").finish().where("stat > 0");
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"am", (String)"am_acctsummaryrpt", (String)"47150e89000000ac");
        bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "companyid", Collections.singletonList("stat"), (Map<String, String>)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("number", "longnumber");
                this.put("company", "orgname");
                this.put("companyid", "rowid");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("finorgtype", "'-1'");
                this.put("bank_cate", "''");
            }
        }, this.companyViewId, orgIdList);
        bizDs = AcctDataListHelper.getSumDataSet(bizDs, Collections.singletonList("stat"), true, (AbstractTmcListDataPlugin)this);
        return bizDs;
    }

    protected DataSet queryData_ByOpenOrg(QFilter[] filter) {
        String bankAcctSic = "openorg.id openorgid,finorgtype,openorg.number number,openorg.name openorg, case when finorgtype='0' then bank.bank_cate.name else bank.name end as bank_cate, 0 sumlevel";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, null);
        List<String> bankAcctgb = Arrays.asList("number", "openorg", "openorgid", "finorgtype", "bank_cate", "sumlevel");
        String stat = "stat";
        DataSet bizDs = bankAcctSet.groupBy(bankAcctgb.toArray(new String[0])).count("stat").finish();
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"am", (String)"am_acctsummaryrpt", (String)"47150e89000000ac");
        bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "openorgid", Collections.singletonList("stat"), (Map<String, String>)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("number", "longnumber");
                this.put("openorg", "orgname");
                this.put("openorgid", "rowid");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("finorgtype", "'-1'");
                this.put("bank_cate", "''");
            }
        }, this.companyViewId, orgIdList);
        bizDs = AcctDataListHelper.getSumDataSet(bizDs, Collections.singletonList("stat"), true, (AbstractTmcListDataPlugin)this);
        return bizDs;
    }

    protected DataSet queryData_ByFinOrgInfo(QFilter[] filter) {
        String bankAcctSic = "finorgtype,case when finorgtype='0' then bank.bank_cate.id else bank.id end as number,bank.name finorginfo, case when finorgtype='0' then bank.bank_cate.name else bank.name end as bank_cate, 0 sumlevel";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, null);
        return bankAcctSet.groupBy(new String[]{"number", "finorgtype", "bank_cate", "finorginfo", "sumlevel"}).count("stat").finish();
    }

    protected DataSet queryData_ByFinOrgProp(QFilter[] filter) {
        String bankAcctSic = " bank.country.number countrynumber,finorgtype,bank.province.number number,bank.city.number citynumber,bank.country.name as country,bank.province.name province,bank.city.id cityid,bank.city.name city,case when finorgtype='0' then bank.bank_cate.name else bank.name end as bank_cate,case when finorgtype='0' then bank.bank_cate.id else bank.id end as bank_number, 0 sumlevel";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, null);
        DataSet bizDs = bankAcctSet.groupBy(new String[]{"countrynumber", "number", "citynumber", "country", "province", "cityid", "city", "bank_cate", "finorgtype", "sumlevel"}).count("stat").finish();
        return bizDs;
    }

    protected DataSet queryBankAcctStatField(QFilter[] filter) {
        String bankAcctSic = "acctproperty.id, acctproperty.number, acctproperty.name, acctstyle, accttype";
        return QueryServiceHelper.queryDataSet((String)"BankAcct", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, (String)"acctproperty.number");
    }

    private DataSet addStatDimensionData(DataSet bizDs, String[] groupField) {
        if (bizDs == null) {
            return bizDs;
        }
        String sicFields = "0 as sumlevel,finorgtype,company.name company, openorg.name openorg,bank.city.id cityid, case when finorgtype='0' then bank.bank_cate.name else bank.name end as bank_cate,bank.name finorginfo, bank.country.name country, bank.province.name province, bank.city.name city, acctproperty.id, acctproperty.number, acctstyle, accttype, issetbankinterface";
        DataSet dsOther = QueryServiceHelper.queryDataSet((String)"BankAcct", (String)"bd_accountbanks", (String)sicFields, (QFilter[])this.filter, null);
        ReportQueryParam param = this.getQueryParam();
        String stats = (String)param.getFilter().getFilterItem("filter_stat").getValue();
        ArrayList<String> sumList = new ArrayList<String>(0);
        for (String stat : stats.split(",")) {
            String dimField = null;
            String beginChangeField = null;
            if ("group_acctpurpose".equals(stat)) {
                dimField = "acctproperty.id";
                beginChangeField = "acctproperty_";
            } else if ("group_acctstyle".equals(stat)) {
                dimField = "acctstyle";
            } else if ("group_accttype".equals(stat)) {
                dimField = "accttype";
            } else if ("group_bankinterface".equals(stat)) {
                dimField = "issetbankinterface";
                beginChangeField = "bankinterface_";
            }
            if (EmptyUtil.isEmpty((String)beginChangeField)) {
                beginChangeField = dimField + "_";
            }
            DataSet ds = this.initStatdimensionDataSet(dsOther, groupField, dimField);
            if ((ds = this.ChangeRowToColDataSet(ds, dimField, String.join((CharSequence)",", groupField), beginChangeField)) == null) {
                return bizDs;
            }
            Field[] fields = ds.getRowMeta().getFields();
            StringBuilder sb = new StringBuilder();
            for (Field field : fields) {
                String fieldName = field.getName();
                sb.append(fieldName).append(',');
                if (!fieldName.startsWith(beginChangeField)) continue;
                sumList.add(fieldName);
            }
            String substring = sb.substring(0, sb.length() - 1);
            ds = ds.select(substring);
            Field[] fields1 = bizDs.getRowMeta().getFields();
            Field[] fieds2 = ds.getRowMeta().getFields();
            bizDs = this.mergeDataSet(bizDs, ds, groupField, groupField);
        }
        groupField[groupField.length - 1] = this.sumField;
        if (sumList.size() > 0 && Arrays.asList("company", "openorg").contains((String)param.getFilter().getFilterItem("statdim").getValue())) {
            bizDs = AcctDataListHelper.getSumDataSet(bizDs, sumList, false, (AbstractTmcListDataPlugin)this);
        }
        return bizDs;
    }

    private DataSet initStatdimensionDataSet(DataSet ds, String[] groupField, String dimGroupField) {
        DataSet temp = ds.copy();
        ArrayList<String> groupFieldList = new ArrayList<String>();
        Collections.addAll(groupFieldList, groupField);
        groupFieldList.add(dimGroupField);
        return temp.groupBy(groupFieldList.toArray(new String[groupFieldList.size()])).count("count").finish();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        LinkedHashMap<String, String> acctPurposeSet = new LinkedHashMap<String, String>();
        HashSet<String> acctStyleSet = new HashSet<String>();
        HashSet<String> acctTypeSet = new HashSet<String>();
        DataSet ds = this.queryBankAcctStatField(this.filter);
        while (ds.hasNext()) {
            Row row = ds.next();
            if (EmptyUtil.isNoEmpty((Object)row.get("acctproperty.id"))) {
                acctPurposeSet.put(row.getString("acctproperty.id"), row.getString("acctproperty.name"));
            }
            if (EmptyUtil.isNoEmpty((Object)row.get("acctstyle"))) {
                acctStyleSet.add(row.getString("acctstyle"));
            }
            if (!EmptyUtil.isNoEmpty((Object)row.get("accttype"))) continue;
            acctTypeSet.add(row.getString("accttype"));
        }
        ReportQueryParam param = this.getQueryParam();
        String stats = (String)param.getFilter().getFilterItem("filter_stat").getValue();
        for (String stat : stats.split(",")) {
            if ("group_acctpurpose".equals(stat)) {
                this.createAcctPurposeColumn(acctPurposeSet, columns);
                continue;
            }
            if ("group_acctstyle".equals(stat)) {
                this.createAcctStyleColumn(acctStyleSet, columns);
                continue;
            }
            if ("group_accttype".equals(stat)) {
                this.createAcctTypeColumn(acctTypeSet, columns);
                continue;
            }
            if (!"group_bankinterface".equals(stat)) continue;
            this.createBankInterfaceColumn(columns);
        }
        return columns;
    }

    private List<AbstractReportColumn> createAcctPurposeColumn(Map<String, String> acctPurposeSet, List<AbstractReportColumn> columns) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumnGroup) || !((ReportColumnGroup)column).getCaption().getLocaleValue().equals(ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"AcctSumDataListPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]))) continue;
            ((ReportColumnGroup)column).getChildren().clear();
            for (Map.Entry<String, String> entry : acctPurposeSet.entrySet()) {
                String number = entry.getKey();
                String key = "acctproperty_" + number;
                String value = entry.getValue();
                if (!EmptyUtil.isNoEmpty((String)number) || !fieldSet.add(key)) continue;
                ReportColumn col = new ReportColumn();
                col.setFieldKey(key);
                col.setFieldType("integer");
                col.setZeroShow(true);
                col.setCaption(new LocaleString(value));
                ((ReportColumnGroup)column).getChildren().add(col);
            }
            if (((ReportColumnGroup)column).getChildren().size() != 1) break;
            ((ReportColumnGroup)column).setCaption(((AbstractReportColumn)((ReportColumnGroup)column).getChildren().get(0)).getCaption());
            break;
        }
        return columns;
    }

    private List<AbstractReportColumn> createAcctStyleColumn(Set<String> acctStyleSet, List<AbstractReportColumn> columns) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumnGroup) || !((ReportColumnGroup)column).getCaption().getLocaleValue().equals(ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"AcctSumDataListPlugin_1", (String)"tmc-am-report", (Object[])new Object[0]))) continue;
            ((ReportColumnGroup)column).getChildren().clear();
            for (String number : acctStyleSet) {
                String key = "acctstyle_" + this.getHashCode(new HashSet(2), number);
                if (!EmptyUtil.isNoEmpty((String)number) || !fieldSet.add(key)) continue;
                ReportColumn col = new ReportColumn();
                col.setFieldKey(key);
                col.setFieldType("integer");
                col.setZeroShow(true);
                col.setCaption(new LocaleString(AcctStyleEnum.getName((String)number)));
                ((ReportColumnGroup)column).getChildren().add(col);
            }
            if (((ReportColumnGroup)column).getChildren().size() != 1) break;
            ((ReportColumnGroup)column).setCaption(((AbstractReportColumn)((ReportColumnGroup)column).getChildren().get(0)).getCaption());
            break;
        }
        return columns;
    }

    private List<AbstractReportColumn> createAcctTypeColumn(Set<String> acctTypeSet, List<AbstractReportColumn> columns) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumnGroup) || !((ReportColumnGroup)column).getCaption().getLocaleValue().equals(ResManager.loadKDString((String)"\u8d26\u6237\u6027\u8d28", (String)"AcctSumDataListPlugin_2", (String)"tmc-am-report", (Object[])new Object[0]))) continue;
            ((ReportColumnGroup)column).getChildren().clear();
            for (String number : acctTypeSet) {
                String key = "accttype_" + this.getHashCode(new HashSet(2), number);
                if (!EmptyUtil.isNoEmpty((String)number) || !fieldSet.add(key)) continue;
                ReportColumn col = new ReportColumn();
                col.setFieldKey(key);
                col.setFieldType("integer");
                col.setZeroShow(true);
                col.setCaption(new LocaleString(AcctTypeEnum.getName((String)number)));
                ((ReportColumnGroup)column).getChildren().add(col);
            }
            if (((ReportColumnGroup)column).getChildren().size() != 1) break;
            ((ReportColumnGroup)column).setCaption(((AbstractReportColumn)((ReportColumnGroup)column).getChildren().get(0)).getCaption());
            break;
        }
        return columns;
    }

    private List<AbstractReportColumn> createBankInterfaceColumn(List<AbstractReportColumn> columns) {
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumnGroup) || !((ReportColumnGroup)column).getCaption().getLocaleValue().equals(ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"AcctSumDataListPlugin_3", (String)"tmc-am-report", (Object[])new Object[0]))) continue;
            ReportColumn col = new ReportColumn();
            col.setFieldKey("bankinterface_true");
            col.setFieldType("integer");
            col.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f00\u901a", (String)"AcctSumDataListPlugin_4", (String)"tmc-am-report", (Object[])new Object[0])));
            col.setZeroShow(true);
            ((ReportColumnGroup)column).getChildren().add(col);
            ReportColumn col2 = new ReportColumn();
            col2.setFieldKey("bankinterface_false");
            col2.setFieldType("integer");
            col2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672a\u5f00\u901a", (String)"AcctSumDataListPlugin_5", (String)"tmc-am-report", (Object[])new Object[0])));
            col2.setZeroShow(true);
            ((ReportColumnGroup)column).getChildren().add(col2);
            ReportColumn col3 = new ReportColumn();
            col3.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f00\u901a\u7387\uff08%\uff09", (String)"AcctSumDataListPlugin_6", (String)"tmc-am-report", (Object[])new Object[0])));
            col3.setFieldType("integer");
            col3.setZeroShow(true);
            col3.setFieldKey("bankinterface_rate");
            ((ReportColumnGroup)column).getChildren().add(col3);
        }
        return columns;
    }
}

