/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.am.report.bankacct.data.AbstractAcctStrategy;
import kd.tmc.am.report.bankacct.data.usage.ConcreteStrategyDetail;
import kd.tmc.am.report.bankacct.data.usage.ConcreteStrategyJournal;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class AcctUsageDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Map<String, String> V_TREE_BASE_COMPANY_MAP = new HashMap<String, String>(3);
    private static final Map<String, String> V_TREE_BASE_OPEN_ORG_MAP = new HashMap<String, String>(3);

    public DataSet query(ReportQueryParam queryParam) {
        AbstractAcctStrategy detail;
        String[] flow;
        List flowList;
        Map commFilter = queryParam.getFilter().getCommFilter();
        Map paramMap = this.transQueryParam(queryParam);
        if (!EmptyUtil.isEmpty(paramMap.get("filter_flow")) && (flowList = Arrays.stream(flow = ((String)paramMap.get("filter_flow")).split(",")).filter(f -> !EmptyUtil.isEmpty((String)f)).collect(Collectors.toList())).size() == 1) {
            paramMap.put("filter_flow", flowList.get(0));
        }
        List orgIds = this.getQueryOrgIds(queryParam);
        QFilter[] filter = QingRptFilterParamHelper.initBankAcctFilter(paramMap, orgIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(commFilter.size());
        for (Map.Entry entry : commFilter.entrySet()) {
            filters.add((QFilter)entry.getValue());
        }
        filters.addAll(Arrays.asList(filter));
        filters.add(new QFilter("company.id", "in", (Object)orgIds));
        String statDimension = (String)paramMap.get("filter_statdim");
        DataSet dataSet = null;
        if ("bei_transdetail".equals(paramMap.get("filter_data_sources"))) {
            detail = new ConcreteStrategyDetail(filters, paramMap, statDimension);
            dataSet = detail.query().get();
        } else if ("cas_bankjournal".equals(paramMap.get("filter_data_sources"))) {
            detail = new ConcreteStrategyJournal(filters, paramMap, statDimension);
            dataSet = detail.query().get();
        }
        if (dataSet == null) {
            return null;
        }
        dataSet = this.exchangeRate(dataSet, (DynamicObject)paramMap.get("filter_statcurrency"), (DynamicObject)paramMap.get("filter_rate_table"));
        if ("org".equals(paramMap.get("filter_queryway"))) {
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"am", (String)"am_acctusagerpt", (String)"47150e89000000ac");
            dataSet = this.getTreeDataSet(dataSet, statDimension, null, orgIdList);
            dataSet = dataSet.orderBy(new String[]{"longnumber", "flow", "stroke_count desc", "amount desc"});
        } else if ("orgview".equals(paramMap.get("filter_queryway"))) {
            Long companyViewId = (Long)paramMap.get("companyviewnum");
            dataSet = this.getTreeDataSet(dataSet, statDimension, companyViewId, null);
            dataSet = dataSet.orderBy(new String[]{"longnumber", "flow", "stroke_count desc", "amount desc"});
        }
        return dataSet;
    }

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    private DataSet getTreeDataSet(DataSet dataSet, String statDimension, Long companyViewId, List<Long> orgIdList) {
        StringBuilder select = new StringBuilder("company,companyid,openorg,openorgid,bank,bank_id,bankcateid,bankaccountnumber,acctname,currency,report_currency,flow,amount,report_amount");
        List<String> statList = Collections.singletonList("stroke_count");
        ArrayList<String> bankAccountGroup = new ArrayList<String>(Arrays.asList(select.toString().split(",")));
        DataSet bizDs = dataSet.select(select.toString());
        GroupbyDataSet groupby = bizDs.groupBy(bankAccountGroup.toArray(new String[0]));
        groupby.count("stroke_count");
        bizDs = groupby.finish();
        if ("company".equals(statDimension)) {
            Map<String, String> vTreeBaseMap = V_TREE_BASE_COMPANY_MAP;
            Map<String, String> vbizBaseMap = AcctDataListHelper.getBizBaseMap(bizDs, statList, vTreeBaseMap);
            bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "companyid", statList, vTreeBaseMap, vbizBaseMap, companyViewId, orgIdList);
            bizDs = AcctDataListHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
        } else if ("openorg".equals(statDimension)) {
            Map<String, String> vTreeBaseMap = V_TREE_BASE_OPEN_ORG_MAP;
            Map<String, String> vbizBaseMap = AcctDataListHelper.getBizBaseMap(bizDs, statList, vTreeBaseMap);
            bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "openorgid", statList, vTreeBaseMap, vbizBaseMap, companyViewId, orgIdList);
            bizDs = AcctDataListHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
        }
        return bizDs;
    }

    private DataSet exchangeRate(DataSet dataSet, DynamicObject reportCurrency, DynamicObject rateTable) {
        DataSet currencyDataSet = dataSet.copy().select("currency").distinct();
        DataSet accountBalanceSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_exrate_tree", (String)"orgcur,excval", null, (String)"");
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(accountBalanceSet.getRowMeta());
        for (Row row : currencyDataSet) {
            Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)row.getLong("currency"), (Long)reportCurrency.getLong("id"), (Long)rateTable.getLong("id"), (Date)Calendar.getInstance().getTime());
            BigDecimal exchangeRate = BigDecimal.ONE.setScale(10);
            boolean quoteType = false;
            if (exchangeRateByRules.get("exchangeRate") != null) {
                exchangeRate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
            }
            if (exchangeRateByRules.get("quoteType") != null) {
                quoteType = (Boolean)exchangeRateByRules.get("quoteType");
            }
            BigDecimal rate = quoteType ? BigDecimal.ONE.divide(exchangeRate, 10, 0) : exchangeRate.setScale(10, 0);
            Object[] rowData = new Object[]{row.getLong("currency"), rate};
            datasetBuilder.append(rowData);
        }
        DataSet rateDataSet = datasetBuilder.build();
        String[] leftSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSet = dataSet.join(rateDataSet, JoinType.LEFT).on("currency", "orgcur").select(leftSelector, new String[]{"excval"}).finish();
        dataSet = dataSet.addField("amount * excval", "report_amount").addField(reportCurrency.getString("id"), "report_currency");
        return dataSet;
    }

    static {
        V_TREE_BASE_COMPANY_MAP.put("company", "orgname");
        V_TREE_BASE_COMPANY_MAP.put("companyid", "rowid");
        V_TREE_BASE_OPEN_ORG_MAP.put("openorg", "orgname");
        V_TREE_BASE_OPEN_ORG_MAP.put("openorgid", "rowid");
    }
}

