/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.am.extpoint.report.IDormantFormListFilter;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.am.report.bankacct.helper.DormantSettingFilterHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class DormantDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map<String, Object> paramMap = AcctDataListHelper.transQueryParam(queryParam);
        return this.getRptListDataSet(queryParam, paramMap);
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    private DataSet getRptListDataSet(ReportQueryParam queryParam, Map<String, Object> paramMap) {
        QFilter[] dailyFilters;
        FilterInfo filter = queryParam.getFilter();
        boolean isincludefinorg = filter.getBoolean("filter_isincludefinorg");
        String dataFrom = filter.getString("datafrom");
        Map<String, Object> settingFilterMap = DormantSettingFilterHelper.dormantSettingFilter();
        QFilter dailytimefilter = new QFilter("bizdate", ">=", settingFilterMap.get("queryStartDate")).and(new QFilter("bizdate", "<=", settingFilterMap.get("queryEndDate")));
        QFilter acctimefilter = new QFilter("opendate", "<=", settingFilterMap.get("queryStartDate"));
        List orgIds = this.getQueryOrgIds(queryParam);
        QFilter orgfilter = QingRptFilterParamHelper.initOrgFilter(paramMap, orgIds);
        QFilter finorgtypefilter = null;
        if (!isincludefinorg) {
            ArrayList<String> isfin = new ArrayList<String>();
            isfin.add(FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            isfin.add(FinOrgTypeEnum.FINCOMP.getValue());
            finorgtypefilter = new QFilter("finorgtype", "not in", isfin);
        }
        QFilter acctstatusfilter = new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
        QFilter[] acctfilters = new QFilter[]{acctimefilter, orgfilter, finorgtypefilter, acctstatusfilter};
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        this.setIFilters(qFilters, filter);
        qFilters.addAll(Arrays.asList(acctfilters));
        DataSet acctDataSet = QueryServiceHelper.queryDataSet((String)"dormantAcct", (String)"bd_accountbanks", (String)this.getAcctSelectedFieds(), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), null);
        QFilter acctFilter = null;
        DataSet acctDataCopy = acctDataSet.copy();
        DataSet acctIdDs = acctDataCopy.select("id");
        List<Long> acctIdList = this.getAcctId(acctIdDs);
        if (acctIdList.size() > 0) {
            acctFilter = new QFilter("accountbank", "in", (Object)acctIdList.toArray());
        }
        DataSet dailyAllDataSet = null;
        if ("bankjournal".equalsIgnoreCase(dataFrom)) {
            dailyFilters = new QFilter[]{dailytimefilter, acctFilter};
            dailyAllDataSet = this.queryBankJournal(dailyFilters);
        } else if ("transdetail".equalsIgnoreCase(dataFrom)) {
            dailyFilters = new QFilter[]{dailytimefilter, acctFilter};
            dailyAllDataSet = this.queryTransDetail(dailyFilters);
        } else if ("other".equalsIgnoreCase(dataFrom)) {
            Map<String, List<Long>> acctIdMap = this.getAcctIdMap(acctDataSet);
            List<Long> innerList = acctIdMap.get("inner");
            List<Long> normalList = acctIdMap.get("normal");
            QFilter innerAcctFilter = new QFilter("accountbank", "in", (Object)innerList.toArray());
            QFilter[] dailyFilters2 = new QFilter[]{dailytimefilter, innerAcctFilter};
            dailyAllDataSet = this.queryTransDetail(dailyFilters2);
            QFilter normalAcctFilter = new QFilter("accountbank", "in", (Object)normalList.toArray());
            dailyFilters2 = new QFilter[]{dailytimefilter, normalAcctFilter};
            dailyAllDataSet = dailyAllDataSet == null ? this.queryBankJournal(dailyFilters2) : dailyAllDataSet.union(this.queryBankJournal(dailyFilters2));
        }
        HashMap<String, Object> count = new HashMap<String, Object>();
        count.put("tradenumber", settingFilterMap.get("tradenumber"));
        DataSet allDataSet = acctDataSet.join(dailyAllDataSet, JoinType.LEFT).on("bankaccountnumber", "accountbank.bankaccountnumber").select(new String[]{"company as company_list", "openorg openorg_list", "bank bank_list", "bankaccountnumber bankaccountnumber_list", "name name_list", "acctname acctname_list", "currencyname currency_list", "defaultcurrency defaultcurrency_list", "opendate opendate_list", "acctstatus acctstatus_list", "acctstyle  acctstyle_list", "accttype  accttype_list", "acctproperty  acctproperty_list", "manager manager_list", "id as accountid"}, new String[]{"accountbank.bankaccountnumber", "tradecount tradecount_list", "debitamount", "creditamount"}).finish();
        DataSet dataSet = allDataSet.addField("debitamount + creditamount", "totalamount").filter("tradecount_list<tradenumber", count).select(new String[]{"company_list", "openorg_list", "bank_list", "bankaccountnumber_list", "name_list", "acctname_list", "currency_list", "defaultcurrency_list", "opendate_list", "acctstatus_list", "acctstyle_list", "acctproperty_list", "manager_list", "tradecount_list", "accttype_list", "totalamount as totalamount_list", "accountid"}).orderBy(new String[]{"company_list", "openorg_list", "tradecount_list"});
        return BankAcctHelper.updateAccountCurrency((QFilter[])qFilters.toArray(new QFilter[0]), (DataSet)dataSet, (String)"accountid", (String)"currency_list");
    }

    private Map<String, List<Long>> getAcctIdMap(DataSet acctDs) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(10);
        ArrayList initList = new ArrayList(10);
        map.put("inner", initList);
        map.put("normal", initList);
        DataSet acctDs0 = acctDs.copy();
        DataSet innerDs = acctDs0.filter("finorgtype = '1' or finorgtype = '3' or issetbankinterface = true ").select("id");
        map.put("inner", this.getAcctId(innerDs));
        DataSet acctDs1 = acctDs.copy();
        DataSet normalDs = acctDs1.filter("finorgtype <> '1' and finorgtype <> '3' and issetbankinterface = false ").select("id");
        map.put("normal", this.getAcctId(normalDs));
        return map;
    }

    private List<Long> getAcctId(DataSet ds) {
        ArrayList<Long> acctIdList = new ArrayList<Long>(10);
        for (Row row : ds) {
            acctIdList.add(row.getLong("id"));
        }
        return acctIdList;
    }

    private DataSet queryBankJournal(QFilter[] dailyFilters) {
        DataSet bankJournalAllDataSet = QueryServiceHelper.queryDataSet((String)"dormantAcct", (String)"cas_bankjournal", (String)this.getDailySelectedFieds(), (QFilter[])dailyFilters, null).groupBy(new String[]{"accountbank.bankaccountnumber"}).count("tradecount").sum("debitamount").sum("creditamount").finish();
        return bankJournalAllDataSet;
    }

    private DataSet queryTransDetail(QFilter[] dailyFilters) {
        DataSet transDetailAllDataSet = QueryServiceHelper.queryDataSet((String)"dormantAcct", (String)"bei_transdetail", (String)this.getTransDetailSelectedFieds(), (QFilter[])dailyFilters, null).groupBy(new String[]{"accountbank.bankaccountnumber"}).count("tradecount").sum("debitamount").sum("creditamount").finish();
        return transDetailAllDataSet;
    }

    private String getAcctSelectedFieds() {
        return "id,company,openorg,issetbankinterface,bank,bankaccountnumber,name,currencyname,defaultcurrency,opendate,acctstatus,acctstyle,accttype,acctproperty,manager,acctname,finorgtype";
    }

    private String getTransDetailSelectedFieds() {
        return "accountbank.bankaccountnumber,bizdate,createtime bookdate,debitamount,creditamount";
    }

    private String getDailySelectedFieds() {
        return "accountbank.bankaccountnumber,bizdate, bookdate,debitamount,creditamount";
    }

    private void setIFilters(List<QFilter> qFilters, FilterInfo filter) {
        PluginProxy pluginProxy = PluginProxy.create(IDormantFormListFilter.class, (String)"kd.sdk.tmc.am.extpoint.report.interest.IDormantFormListFilter");
        pluginProxy.callReplace(proxy -> {
            proxy.setIFilters(qFilters, filter);
            return null;
        });
    }
}

