/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class RestrictedFundsDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(RestrictedFundsDataListPlugin.class);
    private static final Map<String, String> V_TREE_BASE_COMPANY_MAP = new HashMap<String, String>(3);
    private static final String Add_SELECTEDFIELDS = "org.name orgname,org.id orgid,restrictedfoundstype.restrictedfundstype restrictedfundstype,bankacct.id bankacct,bankacct.acctname acctname,bankacct.bank.id bank,bankacct.acctproperty.id acctproperty,bankacct.accttype accttype,bankacct.issetbankinterface issetbankinterface,bankacct.finorgtype finorgtype,bankacct.acctstyle acctstyle,currency.id currencyid,%d reportcurrency,unrestrictedamt amount,unrestrictedamt reportcurrencyamt,actualliftdate,'' date,billno,isallrestricted";
    private static final String Lift_SELECTEDFIELDS = "org.name orgname,org.id orgid,bankacct.id bankacct,restrictedfoundstype.restrictedfundstype restrictedfundstype,bankacct.acctname acctname,bankacct.bank.id bank,bankacct.acctproperty.id acctproperty,bankacct.accttype accttype,bankacct.finorgtype finorgtype,bankacct.acctstyle acctstyle,currency.id currencyid,%d reportcurrency,thistimeunblockamt amount,thistimeunblockamt reportcurrencyamt,actualliftdate,'' date,srcbillno billno,isallrestricted";
    private List<String> srcBillNos = new ArrayList<String>();

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        DataSet bizDs = null;
        Map paramMap = this.transQueryParam(param);
        List allOrgIds = this.getQueryOrgIds(param);
        bizDs = this.getBizData(paramMap, allOrgIds);
        if ("org".equals(paramMap.get("filter_queryway"))) {
            bizDs = this.getTreeDataSet(bizDs, null, allOrgIds, paramMap);
        } else if ("orgview".equals(paramMap.get("filter_queryway"))) {
            DynamicObject compview = (DynamicObject)paramMap.get("filter_orgview");
            Long companyViewId = 0L;
            if (compview != null) {
                companyViewId = (Long)compview.getPkValue();
            }
            bizDs = this.getTreeDataSet(bizDs, companyViewId, null, paramMap);
        }
        bizDs = bizDs.orderBy(new String[]{"orgid", "bank"});
        return bizDs;
    }

    private DataSet getBizData(Map<String, Object> paramMap, List<Long> allOrgIds) {
        QFilter[] filters = this.getQFilters(paramMap, "1", null, Boolean.FALSE, allOrgIds);
        DataSet addFundsData = this.getRestrictedFundsData(paramMap, filters, Add_SELECTEDFIELDS, "1", Boolean.FALSE);
        filters = this.getQFilters(paramMap, "1", null, Boolean.TRUE, allOrgIds);
        DataSet allRestrictedData = this.getRestrictedFundsData(paramMap, filters, Add_SELECTEDFIELDS, "1", Boolean.TRUE);
        filters = this.getQFilters(paramMap, "2", this.srcBillNos, Boolean.FALSE, allOrgIds);
        DataSet liftFundsData = this.getRestrictedFundsData(paramMap, filters, Lift_SELECTEDFIELDS, "2", Boolean.FALSE);
        DataSet result = addFundsData.union(liftFundsData).union(allRestrictedData);
        DataSet bizDs = result.groupBy(new String[]{"orgid", "orgname", "bankacct", "acctname", "bank", "acctproperty", "currencyid", "date", "reportcurrency", "accttype", "acctstyle", "restrictedfundstype"}).sum("amount", "amount").sum("reportcurrencyamt", "reportcurrencyamt").finish();
        bizDs = this.dealRate(bizDs, paramMap);
        return bizDs;
    }

    public String getLimitFunds(Map<String, Object> paramMap, List<Long> allOrgIds) {
        HashMap<String, BigDecimal> limitFunds = new HashMap<String, BigDecimal>(16);
        try {
            DataSet dataSet = this.getBizData(paramMap, allOrgIds);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                BigDecimal limitFund = row.getBigDecimal("reportcurrencyamt");
                Long orgID = row.getLong("orgid");
                Long bankAcctID = row.getLong("bankacct");
                Long currencyID = row.getLong("currencyid");
                String lat = orgID + "_" + bankAcctID + "_" + currencyID;
                limitFunds.put(lat, limitFund);
            }
        }
        catch (Exception e) {
            logger.error("\u8d26\u6237\u7ba1\u7406\u5904\u7406\u53d7\u9650\u8d44\u91d1\u4f59\u989d\u5f02\u5e38:", (Throwable)e);
        }
        String result = JSONObject.toJSONString(limitFunds);
        return result;
    }

    private DataSet getTreeDataSet(DataSet dataSet, Long companyViewId, List<Long> orgIdList, Map<String, Object> paramMap) {
        DataSet bizDs = dataSet.copy();
        Date restrictedDate = (Date)paramMap.get("filter_date");
        String strRestrictedDate = new SimpleDateFormat("yyyy-MM-dd").format(restrictedDate);
        long reportCurrencyId = 0L;
        DynamicObject reportCurrencyDy = (DynamicObject)paramMap.get("filter_statcurrency");
        if (reportCurrencyDy != null) {
            reportCurrencyId = Long.parseLong(reportCurrencyDy.getPkValue().toString());
        }
        ArrayList<String> statList = new ArrayList<String>();
        statList.add("reportcurrencyamt");
        Map<String, String> vTreeBaseMap = V_TREE_BASE_COMPANY_MAP;
        Map<String, String> vbizBaseMap = AcctDataListHelper.getBizBaseMap(bizDs, statList, vTreeBaseMap);
        vbizBaseMap.put("date", "'" + strRestrictedDate + "'");
        vbizBaseMap.put("reportcurrency", String.valueOf(reportCurrencyId));
        bizDs = AcctDataListHelper.getBizDsWithOrgTree(bizDs, "rowid", "orgid", statList, vTreeBaseMap, vbizBaseMap, companyViewId, orgIdList);
        bizDs = AcctDataListHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
        return bizDs;
    }

    private DataSet getRestrictedFundsData(Map<String, Object> paramMap, QFilter[] filters, String vSelectFields, String type, Boolean isAllRestricted) {
        long reportCurrencyId = 0L;
        DynamicObject reportCurrencyDy = (DynamicObject)paramMap.get("filter_statcurrency");
        if (reportCurrencyDy != null) {
            reportCurrencyId = Long.parseLong(reportCurrencyDy.getPkValue().toString());
        }
        Date restrictedDate = (Date)paramMap.get("filter_date");
        String strRestrictedDate = new SimpleDateFormat("yyyy-MM-dd").format(restrictedDate);
        String calUnits = (String)paramMap.get("filter_currencyunit");
        String selectFields = String.format(vSelectFields, reportCurrencyId);
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"am_restrictedfundsmanager", (String)selectFields, (QFilter[])filters, null);
        DataSet copy = detailDataSet.copy();
        if (type.equalsIgnoreCase("1")) {
            DataSet bankInfoDs;
            List<Long> orgId;
            if (!isAllRestricted.booleanValue()) {
                this.srcBillNos = this.getStringProperty(detailDataSet);
            }
            if ((orgId = this.getLongProperty(bankInfoDs = detailDataSet.filter("isallrestricted = true").select("orgid,bank,bankacct,issetbankinterface,currencyid,finorgtype"), "orgid")) != null && orgId.size() > 0) {
                copy = this.addAllRestrictedData(copy, bankInfoDs, orgId, paramMap);
            }
        }
        DataSet bizDs = copy.groupBy(new String[]{"orgid", "orgname", "bankacct", "acctname", "bank", "acctproperty", "currencyid", "date", "reportcurrency", "accttype", "acctstyle", "restrictedfundstype"}).sum("amount", "amount").sum("reportcurrencyamt", "reportcurrencyamt").finish();
        bizDs = bizDs.updateField("amount", "amount/" + calUnits).updateField("reportcurrencyamt", "reportcurrencyamt/" + calUnits).updateField("date", "'" + strRestrictedDate + "'");
        return bizDs;
    }

    private DataSet addAllRestrictedData(DataSet copy, DataSet bankInfoDs, List<Long> orgIds, Map<String, Object> paramMap) {
        String dataSource = (String)paramMap.get("datasource");
        ArrayList<Long> beiList = new ArrayList<Long>();
        ArrayList<Long> casList = new ArrayList<Long>();
        switch (dataSource) {
            case "bankjournal": {
                DataSet bankCopy = bankInfoDs.copy();
                DataSet bankIdDs = bankCopy.groupBy(new String[]{"bankacct"}).finish();
                List<Long> bankIdLs = this.getLongProperty(bankIdDs, "bankacct");
                casList.addAll(bankIdLs);
                break;
            }
            case "bankbalance": {
                DataSet beiCopy = bankInfoDs.copy();
                DataSet beiBankIdDs = beiCopy.groupBy(new String[]{"bankacct"}).finish();
                List<Long> beiBankIdLs = this.getLongProperty(beiBankIdDs, "bankacct");
                beiList.addAll(beiBankIdLs);
                break;
            }
            case "directconnacct": {
                DataSet bankInfoCopy = bankInfoDs.copy();
                for (Row row1 : bankInfoCopy) {
                    boolean isSetBankInterface = row1.getBoolean("issetbankinterface");
                    String finOrgType = row1.getString("finorgtype");
                    long bankAcctId = row1.getLong("bankacct");
                    if (isSetBankInterface || "1".equals(finOrgType) || "3".equals(finOrgType)) {
                        beiList.add(bankAcctId);
                        continue;
                    }
                    casList.add(bankAcctId);
                }
                break;
            }
        }
        List<Long> currencyId = this.getLongProperty(bankInfoDs, "currencyid");
        Date endDate = (Date)paramMap.get("filter_date");
        endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        if (beiList.size() > 0) {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"bankService", (String)"getBalanceBatch", (Object[])new Object[]{orgIds, beiList, new ArrayList(), endDate});
            String msg = "orgId:" + orgIds + ";bankacct:" + beiList + ";date:" + endDate + ";result:" + result;
            logger.info(msg);
            copy = this.addNewRows(copy, result, beiList);
        }
        if (casList.size() > 0) {
            HashSet<Long> orgIdSet = new HashSet<Long>(orgIds);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"BalanceCountService", (String)"getJournalBalanceBatch", (Object[])new Object[]{orgIdSet, casList, new ArrayList(), endDate});
            String msg = "orgId:" + orgIds + ";bankacct:" + casList + ";cur:" + currencyId + ";date:" + endDate + ";result:" + result;
            logger.info(msg);
            copy = this.addNewRows(copy, result, casList);
        }
        return copy;
    }

    private DataSet addNewRows(DataSet copy, Map<String, BigDecimal> result, List<Long> acctBankIds) {
        if (result != null) {
            DataSet copyTemp = copy.copy();
            for (Map.Entry<String, BigDecimal> mapEntry : result.entrySet()) {
                String key = mapEntry.getKey();
                String[] propertyArr = key.split("-");
                if (!acctBankIds.contains(Long.parseLong(propertyArr[1]))) continue;
                String expr = "isallrestricted = true and amount = 0 and orgid = " + propertyArr[0] + " and bankacct = " + propertyArr[1];
                BigDecimal amount = mapEntry.getValue();
                String strAmount = mapEntry.getValue().toString();
                if (BigDecimal.ZERO.compareTo(amount) == 0) {
                    strAmount = "0";
                }
                DataSet newRow = copyTemp.filter(expr).limit(0, 1).updateField("amount", strAmount).updateField("reportcurrencyamt", strAmount).updateField("currencyid", propertyArr[2]);
                copy = copy.union(newRow);
            }
        }
        return copy;
    }

    private DataSet dealRate(DataSet dataSet, Map<String, Object> paramMap) {
        DataSet currencySet = dataSet.copy().groupBy(new String[]{"currencyid"}).sum("amount", "exchrate").finish();
        Long reportCurrencyId = ((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id");
        Long exchangeRateTableId = ((DynamicObject)paramMap.get("filter_exratetable")).getLong("id");
        BigDecimal tempRate = null;
        Object[] rowData = null;
        Row row = null;
        Long currency = null;
        Date restrictedDate = (Date)paramMap.get("filter_date");
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(currencySet.getRowMeta());
        while (currencySet.hasNext()) {
            rowData = new Object[2];
            row = currencySet.next();
            currency = row.getLong("currencyid");
            tempRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)currency, (Long)reportCurrencyId, (Date)restrictedDate);
            rowData[0] = currency;
            rowData[1] = EmptyUtil.isNoEmpty((BigDecimal)tempRate) ? tempRate : BigDecimal.ONE;
            datasetBuilder.append(rowData);
        }
        DataSet exchDataSet = datasetBuilder.build();
        exchDataSet = dataSet.copy().join(exchDataSet, JoinType.LEFT).on("currencyid", "currencyid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"exchrate"}).finish();
        exchDataSet = exchDataSet.select(StringUtils.replace((String)StringUtils.join((Object[])exchDataSet.getRowMeta().getFieldNames(), (char)','), (String)"reportcurrencyamt", (String)"reportcurrencyamt * exchrate reportcurrencyamt"));
        return exchDataSet;
    }

    private QFilter[] getQFilters(Map<String, Object> paramMap, String type, List<String> srcBillNos, Boolean isAllRestricted, List<Long> allOrgIds) {
        DynamicObjectCollection acctPropertyDc;
        QFilter qFilter;
        String accttype;
        String acctstyle;
        QFilter qFilter2;
        DynamicObjectCollection currencyDo;
        DynamicObjectCollection bankAcctDc;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter baseQfilter = new QFilter("billstatus", "=", (Object)"C");
        baseQfilter.and("businesstype", "=", (Object)type);
        filterList.add(baseQfilter);
        filterList.add(new QFilter("org.id", "in", allOrgIds));
        DynamicObjectCollection bankDc = (DynamicObjectCollection)paramMap.get("filter_bank");
        if (bankDc != null && bankDc.size() > 0) {
            List bankIdList = bankDc.stream().map(y -> Long.parseLong(y.getPkValue().toString())).collect(Collectors.toList());
            QFilter qFilter3 = new QFilter("bankacct.bank.id", "in", bankIdList);
            filterList.add(qFilter3);
        }
        if ((bankAcctDc = (DynamicObjectCollection)paramMap.get("filter_mulbankacct")) != null && bankAcctDc.size() > 0) {
            List bankAcctIdList = bankAcctDc.stream().map(y -> Long.parseLong(y.getPkValue().toString())).collect(Collectors.toList());
            QFilter qFilter4 = new QFilter("bankacct.id", "in", bankAcctIdList);
            filterList.add(qFilter4);
        }
        if ((currencyDo = (DynamicObjectCollection)paramMap.get("filter_currency")) != null) {
            List currencyId = currencyDo.stream().map(y -> Long.parseLong(y.getPkValue().toString())).collect(Collectors.toList());
            qFilter2 = new QFilter("currency.id", "in", currencyId);
            filterList.add(qFilter2);
        }
        Date restrictedDate = (Date)paramMap.get("filter_date");
        if ((restrictedDate = DateUtils.getDataFormat((Date)restrictedDate, (boolean)false)) != null) {
            if (type.equalsIgnoreCase("1")) {
                if (isAllRestricted.booleanValue()) {
                    QFilter dateFilter = new QFilter("actualliftdate", "is null", null);
                    dateFilter.or("actualliftdate", ">", (Object)restrictedDate);
                    QFilter qFilter5 = new QFilter("restricteddate", "<=", (Object)restrictedDate);
                    qFilter5.and("isallrestricted", "=", (Object)"1");
                    qFilter5.and(dateFilter);
                    filterList.add(qFilter5);
                } else {
                    qFilter2 = new QFilter("restricteddate", "<=", (Object)restrictedDate);
                    qFilter2.and("isallrestricted", "=", (Object)"0");
                    filterList.add(qFilter2);
                }
            } else if (type.equalsIgnoreCase("2")) {
                qFilter2 = new QFilter("liftdate", ">", (Object)restrictedDate);
                qFilter2.and("isallrestricted", "=", (Object)"0");
                filterList.add(qFilter2);
            }
        }
        String string = acctstyle = paramMap.get("filter_acctstyle") == null ? "" : paramMap.get("filter_acctstyle").toString();
        if (!acctstyle.isEmpty()) {
            String[] split = acctstyle.substring(1, acctstyle.length()).split(",");
            QFilter qFilter6 = new QFilter("bankacct.acctstyle", "in", (Object)split);
            filterList.add(qFilter6);
        }
        String string2 = accttype = paramMap.get("filter_accttype") == null ? "" : paramMap.get("filter_accttype").toString();
        if (!accttype.isEmpty()) {
            String[] split = accttype.substring(1, accttype.length()).split(",");
            qFilter = new QFilter("bankacct.accttype", "in", (Object)split);
            filterList.add(qFilter);
        }
        if ((acctPropertyDc = (DynamicObjectCollection)paramMap.get("filter_acctproperty")) != null && acctPropertyDc.size() > 0) {
            List acctPropertyIdList = acctPropertyDc.stream().map(y -> Long.parseLong(y.getPkValue().toString())).collect(Collectors.toList());
            QFilter qFilter7 = new QFilter("bankacct.acctproperty.id", "in", acctPropertyIdList);
            filterList.add(qFilter7);
        }
        if (type.equalsIgnoreCase("2")) {
            qFilter = new QFilter("srcbillno", "in", srcBillNos);
            filterList.add(qFilter);
        }
        QFilter[] filters = filterList.toArray(new QFilter[0]);
        return filters;
    }

    private List<String> getStringProperty(DataSet fundsData) {
        DataSet copy = fundsData.copy();
        ArrayList<String> srcBillNos = new ArrayList<String>();
        for (Row row : copy) {
            srcBillNos.add(row.getString("billno"));
        }
        return srcBillNos;
    }

    private List<Long> getLongProperty(DataSet fundsData, String propertyName) {
        DataSet copy = fundsData.copy();
        ArrayList<Long> bankIds = new ArrayList<Long>();
        for (Row row : copy) {
            bankIds.add(row.getLong(propertyName));
        }
        return bankIds;
    }

    static {
        V_TREE_BASE_COMPANY_MAP.put("orgname", "orgname");
        V_TREE_BASE_COMPANY_MAP.put("orgid", "rowid");
    }
}

