/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data.async;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.tmc.am.report.bankacct.data.async.AsyncComponent;

public abstract class AbstractThreadDecorator<T>
implements AsyncComponent<T> {
    private static final Log LOGGER = LogFactory.getLog(AbstractThreadDecorator.class);
    private List<AsyncComponent<T>> componentList;
    private static final ExecutorService EXECUTORSERVICE = ThreadPools.newCachedExecutorService((String)AbstractThreadDecorator.class.getName());
    protected LinkedBlockingQueue<T> linkedBlockingQueue = new LinkedBlockingQueue();
    protected List<CompletableFuture<T>> futureList = new ArrayList<CompletableFuture<T>>();
    private CyclicBarrier cyclicBarrier;
    private CountDownLatch countDownLatch;

    protected AbstractThreadDecorator(AsyncComponent<T> ... components) {
        this.componentList = Arrays.stream(components).collect(Collectors.toList());
        this.countDownLatch = new CountDownLatch(this.componentList.size());
        this.cyclicBarrier = new CyclicBarrier(this.componentList.size() + 1);
    }

    protected AbstractThreadDecorator(List<AsyncComponent<T>> componentList) {
        this.componentList = new ArrayList<AsyncComponent<T>>(componentList);
        this.countDownLatch = new CountDownLatch(this.componentList.size());
        this.cyclicBarrier = new CyclicBarrier(this.componentList.size() + 1);
    }

    @Override
    public T operation() {
        this.asyncWaitOperation();
        T t = null;
        try {
            this.countDownLatch.await();
            t = this.handle();
            this.cyclicBarrier.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("InterruptedException", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (BrokenBarrierException e) {
            LOGGER.error("BrokenBarrierException", (Throwable)e);
        }
        return t;
    }

    public CompletableFuture<T> asyncWaitOperation() {
        RequestContext requestContext = RequestContext.get();
        for (AsyncComponent<T> component : this.componentList) {
            this.futureList.add(CompletableFuture.supplyAsync(() -> {
                RequestContext.set((RequestContext)requestContext);
                Object t = component.operation();
                this.linkedBlockingQueue.add(t);
                this.countDownLatch.countDown();
                try {
                    this.cyclicBarrier.await();
                }
                catch (InterruptedException e) {
                    LOGGER.error("InterruptedException", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (BrokenBarrierException e) {
                    LOGGER.error("BrokenBarrierException", (Throwable)e);
                }
                return t;
            }, EXECUTORSERVICE));
        }
        return CompletableFuture.allOf(this.futureList.toArray(new CompletableFuture[0]));
    }

    public abstract T handle();
}

