/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data.async;

import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.am.report.bankacct.data.async.AbstractThreadDecorator;
import kd.tmc.am.report.bankacct.data.async.AsyncComponent;

public class DataSetThreadDecorator
extends AbstractThreadDecorator<DataSet> {
    private static final Log LOGGER = LogFactory.getLog(DataSetThreadDecorator.class);

    public DataSetThreadDecorator(AsyncComponent<DataSet> ... components) {
        super(components);
    }

    public DataSetThreadDecorator(List<AsyncComponent<DataSet>> componentList) {
        super(componentList);
    }

    @Override
    public DataSet handle() {
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder datasetBuilder = null;
        while (!this.linkedBlockingQueue.isEmpty()) {
            DataSet dataSet = null;
            try {
                dataSet = (DataSet)this.linkedBlockingQueue.take();
            }
            catch (InterruptedException e) {
                LOGGER.error("InterruptedException", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (datasetBuilder == null && dataSet != null) {
                datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
            }
            if (dataSet == null) continue;
            for (Row row : dataSet) {
                datasetBuilder.append(row);
            }
        }
        return datasetBuilder == null ? null : datasetBuilder.build();
    }
}

