/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.data.usage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.report.bankacct.data.AbstractAcctStrategy;
import kd.tmc.am.report.bankacct.data.AcctStrategy;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ConcreteStrategyJournal
extends AbstractAcctStrategy {
    public ConcreteStrategyJournal(List<QFilter> qFilterList, Map<String, Object> paramMap, String dimension) {
        super.setFilterList(qFilterList);
        this.paramMap = paramMap;
        super.setOrder(dimension);
    }

    @Override
    public AcctStrategy query() {
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"am_accountbank", (String)"am_accountbank", (String)"company.id as companyid,company.name as company,openorg.name as openorg,openorg.id as openorgid,id as bankacctid,bankaccountnumber,name,acctname,acctproperty.number as acctpropNumber, acctproperty.name as acctprop,acctproperty.id as acctpropid,acctstyle,accttype,acctstatus,finorgtype,bank.name as bank,bank.id as bank_id,case when finorgtype='0' then bank.bank_cate.name else bank.name end as bankcate,case when finorgtype='0' then bank.bank_cate.id else bank.id end as bankcateid", (QFilter[])super.getFilterList().toArray(new QFilter[0]), null);
        this.setFilter();
        String calUnits = "1";
        if (!EmptyUtil.isEmpty(this.paramMap.get("filter_currencyunit"))) {
            calUnits = (String)this.paramMap.get("filter_currencyunit");
        }
        DataSet detail = QueryServiceHelper.queryDataSet((String)"cas_bankjournal", (String)"cas_bankjournal", (String)("(case when debitamount <> 0 then debitamount else  creditamount end)/" + calUnits + " as amount,(case when debitamount <> 0 then 'in' else  'out' end) as flow,currency.id as currency,accountbank,bookdate as change_date"), (QFilter[])super.getFilterList().toArray(new QFilter[0]), null);
        String[] leftSelector = (String[])Arrays.stream(bankAcctSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] rightSelector = (String[])Arrays.stream(detail.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        this.dataSet = bankAcctSet.join(detail).on("bankacctid", "accountbank").select(leftSelector, rightSelector).finish().orderBy(this.order);
        return this.build(this);
    }

    @Override
    public void setFilter() {
        super.getFilterList().clear();
        String dateRange = String.valueOf(this.paramMap.get("filter_dateranges"));
        if (!EmptyUtil.isEmpty((String)dateRange)) {
            if (RptDateRangeEnum.CUSTOM.getValue().equals(dateRange)) {
                super.getFilterList().add(new QFilter("bookdate", ">=", this.paramMap.get("filter_dateranges_startdate")).and(new QFilter("bookdate", "<=", this.paramMap.get("filter_dateranges_enddate"))));
            } else {
                super.getFilterList().add(new QFilter("bookdate", ">=", (Object)this.explainStartDate(dateRange)).and(new QFilter("bookdate", "<=", (Object)this.explainEndDate(dateRange))));
            }
        }
        if (!EmptyUtil.isEmpty(this.paramMap.get("filter_flow"))) {
            String flow = String.valueOf(this.paramMap.get("filter_flow"));
            if ("out".equals(flow)) {
                super.getFilterList().add(new QFilter("creditamount", ">", (Object)0));
            } else if ("in".equals(flow)) {
                super.getFilterList().add(new QFilter("debitamount", ">", (Object)0));
            }
        }
        if (!EmptyUtil.isEmpty(this.paramMap.get("filter_currencies"))) {
            DynamicObjectCollection filterCurrencies = (DynamicObjectCollection)this.paramMap.get("filter_currencies");
            ArrayList<Long> filterCurrenciesIdList = new ArrayList<Long>();
            for (DynamicObject currency : filterCurrencies) {
                filterCurrenciesIdList.add(currency.getLong("id"));
            }
            if (!filterCurrenciesIdList.isEmpty()) {
                super.getFilterList().add(new QFilter("currency.id", "in", filterCurrenciesIdList));
            }
        }
    }
}

