/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AcctBankFunctionFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private Map<String, Object> paramMap = null;
    private static final String SYSTEM_TYPE = "tmc-am-report";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.defaultOrg();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"org".equals(queryWay), (String[])new String[]{"filter_org"});
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        RequestContext context = RequestContext.get();
        String appId = this.getView().getFormShowParameter().getAppId();
        BasedataEdit openOrg = (BasedataEdit)this.getControl("filter_openorg");
        List orgIdList = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        openOrg.setQFilter(new QFilter("id", "in", (Object)orgIdList));
    }

    public void beforeQuery(ReportQueryParam param) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Map commFilters = null;
        if (!EmptyUtil.isEmpty(customParams.get("commFilters"))) {
            commFilters = (Map)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get("commFilters")));
        }
        if (null != commFilters) {
            param.getFilter().setCommFilter(commFilters);
        }
        super.beforeQuery(param);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("filter_queryway".equals(name)) {
            String queryWay = (String)this.getModel().getValue("filter_queryway");
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"org".equals(queryWay), (String[])new String[]{"filter_org"});
        }
    }

    public boolean verifyQuery(ReportQueryParam param) {
        MulBasedataDynamicObjectCollection companys = (MulBasedataDynamicObjectCollection)this.getModel().getValue("filter_org");
        List orgList = companys.stream().map(d -> d.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        Map<String, Object> paramMap = this.getParamMap(param);
        String queryType = (String)paramMap.get("filter_queryway");
        if ("org".equals(queryType)) {
            if (orgList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff08\u7533\u8bf7\u516c\u53f8\uff09\u5fc5\u5f55\u3002", (String)"RestrictedFundsFormListPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        } else if ("orgview".equals(queryType)) {
            DynamicObject companyView = (DynamicObject)paramMap.get("filter_orgview");
            String companyViewNum = companyView.getString("number");
            param.getFilter().addFilterItem("companyviewnum", companyView.getPkValue());
            String orgRootId = AcctBankFunctionFormListPlugin.getOrgRootId(companyViewNum);
            if (EmptyUtil.isEmpty((String)orgRootId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe[%s]\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AcctChangeFormListPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[]{companyViewNum}));
                return false;
            }
            List allOrgIds = OrgUnitServiceHelper.getAllOrg((String)companyViewNum);
            if (EmptyUtil.isEmpty((Collection)allOrgIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ba1\u7406\u7ec4\u7ec7\u89c6\u56fe\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"AcctChangeFormListPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("bankaccountnumber".equals(fieldName)) {
            this.showForm(rowData.get("bankacctid"));
        } else if ("actualopendate".equals(fieldName)) {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            QFilter qFilter = new QFilter("bizdate", "=", rowData.get("actualopendate"));
            DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)rowData.getString("billinfo"), (String)"id", (QFilter[])new QFilter[]{qFilter});
            ArrayList<Long> ids = new ArrayList<Long>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                ids.add(dynamicObject.getLong("id"));
            }
            if (!CollectionUtils.isEmpty(ids)) {
                tuples.add(new Tuple((Object)rowData.getString("billinfo"), ids));
            }
            TmcBotpHelper.showTrackParameter(tuples, (IFormView)this.getView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        if (operationResult != null && operationResult.isSuccess() && StringUtils.equals((CharSequence)operateKey, (CharSequence)"modifyopendate")) {
            int[] selectedRows = reportList.getEntryState().getSelectedRows();
            if (selectedRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AcctBankFunctionFormListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            } else if (selectedRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u6267\u884c\u3002", (String)"AcctBankFunctionFormListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            } else {
                DynamicObject row = reportList.getReportModel().getRowData(selectedRows[0]);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setFormId("am_bankfunclist");
                formShowParameter.setCustomParam("pkid", (Object)row.getLong("bankacctid"));
                formShowParameter.setCustomParam("source", (Object)"report");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "am_bankfunclist"));
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().refresh();
    }

    private void showForm(Object pkId) {
        if (pkId != null) {
            IReportView view = this.getView();
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setPkId(pkId);
            parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("am_accountbank");
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(new AmBizResource().getTipDatalose());
        }
    }

    private static String getOrgRootId(String orgViewNumber) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(orgViewNumber);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode != null ? rootNode.getId() : null;
    }

    private Map<String, Object> getParamMap(ReportQueryParam param) {
        if (this.paramMap == null) {
            this.paramMap = AcctDataListHelper.transQueryParam(param);
        }
        return this.paramMap;
    }

    private void defaultOrg() {
        Long org = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        this.getModel().setValue("filter_orgview", null);
        if (authOrgIds != null && !authOrgIds.isEmpty()) {
            if (authOrgIds.contains(org)) {
                DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((Object)org, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                DynamicObjectCollection dynamicObjects1 = new DynamicObjectCollection();
                dynamicObjects1.add((Object)dynamicObjects);
                this.getModel().setValue("filter_org", (Object)dynamicObjects1);
            } else {
                DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle(authOrgIds.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObjects)) {
                    DynamicObjectCollection dynamicObjects1 = new DynamicObjectCollection();
                    dynamicObjects1.add((Object)dynamicObjects);
                    this.getModel().setValue("filter_org", (Object)dynamicObjects1);
                }
            }
        }
    }

    private void addF7Listener() {
        BasedataEdit filterOpenOrg = (BasedataEdit)this.getControl("filter_openorg");
        filterOpenOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            param.setCustomParam("range", (Object)authOrgIds);
        });
        BasedataEdit filterAccount = (BasedataEdit)this.getControl("filter_account");
        filterAccount.addBeforeF7SelectListener(evt -> {
            String queryType = (String)this.getModel().getValue("filter_queryway");
            List orgList = null;
            if ("org".equals(queryType)) {
                MulBasedataDynamicObjectCollection companys = (MulBasedataDynamicObjectCollection)this.getModel().getValue("filter_org");
                if (companys == null || companys.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u5f0f\u4e3a\u8d44\u91d1\u7ec4\u7ec7\u67e5\u8be2\u65f6\uff0c\u7533\u8bf7\u516c\u53f8\u4e3a\u5fc5\u9009\u3002", (String)"AcctBankFunctionFormListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                orgList = companys.stream().map(d -> d.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            } else if ("orgview".equals(queryType)) {
                DynamicObject companyView = (DynamicObject)this.getModel().getValue("filter_orgview");
                if (companyView == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u67e5\u8be2\u65b9\u5f0f\u4e3a\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u65f6\uff0c\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u4e3a\u5fc5\u9009\u3002", (String)"AcctBankFunctionFormListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                String companyViewNum = companyView.getString("number");
                orgList = OrgUnitServiceHelper.getAllOrg((String)companyViewNum);
                evt.addCustomQFilter(new QFilter("company", "in", (Object)orgList));
            }
            if (orgList != null && !orgList.isEmpty()) {
                evt.addCustomQFilter(new QFilter("company", "in", (Object)orgList));
            }
            evt.addCustomQFilter(new QFilter("issetbankinterface", "=", (Object)true));
        });
    }
}

