/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AcctChangeSumFormListPlugin
extends AbstractReportFormPlugin {
    private Map<String, Object> paramMap = null;
    private static final String SYSTEM_TYPE = "tmc-am-report";
    private static final Map<String, String> INIT_STAT_DIM = new HashMap<String, String>(5);
    private static String[] fields;

    private static String[] getCompanyFields() {
        AcctChangeSumFormListPlugin.fields[0] = ResManager.loadKDString((String)"\u7533\u8bf7\u516c\u53f8", (String)"AcctChangeFormListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        return fields;
    }

    private static String[] getOpenOrgFields() {
        AcctChangeSumFormListPlugin.fields[0] = ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8", (String)"AcctChangeFormListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        return fields;
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
        String statDimension = (String)this.getModel().getValue("filter_statdim");
        if (Arrays.asList("company", "openorg").contains(statDimension)) {
            event.setTreeExpandColId(statDimension);
        } else {
            event.setTreeExpandColId("number");
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        RequestContext context = RequestContext.get();
        String appId = this.getView().getFormShowParameter().getAppId();
        BasedataEdit openOrg = (BasedataEdit)this.getControl("filter_openorg");
        List orgIdList = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        openOrg.setQFilter(new QFilter("id", "in", (Object)orgIdList));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_dateranges": {
                if ("custom".equals(e.getChangeSet()[0])) break;
                this.getModel().setValue("filter_dateranges_startdate", null);
                this.getModel().setValue("filter_dateranges_enddate", null);
                break;
            }
            case "filter_statdim": {
                this.getView().refresh();
                break;
            }
            case "filter_queryway": {
                this.setOrgPropMustInput();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrgPropMustInput();
    }

    private void setOrgPropMustInput() {
        boolean isMustInput = ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"));
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"filter_org"});
    }

    public void beforeQuery(ReportQueryParam param) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Map commFilters = null;
        if (!EmptyUtil.isEmpty(customParams.get("commFilters"))) {
            commFilters = (Map)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get("commFilters")));
        }
        if (null != commFilters) {
            param.getFilter().setCommFilter(commFilters);
        }
        String statDimension = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("filter_statdim", (Object)statDimension);
        this.initQueryColumn(statDimension, param);
        super.beforeQuery(param);
    }

    public boolean verifyQuery(ReportQueryParam param) {
        Map<String, Object> paramMap = this.getParamMap(param);
        String stat = String.valueOf(this.getModel().getValue("filter_statdim"));
        if (!"company".equals(stat) && !"openorg".equals(stat)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u7ef4\u5ea6\u4e0d\u652f\u6301\u3002", (String)"AcctChangeFormListPlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String queryType = (String)paramMap.get("filter_queryway");
        if ("org".equals(queryType) && paramMap.get("filter_company_id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff08\u7533\u8bf7\u516c\u53f8\uff09\u5fc5\u5f55\u3002", (String)"RestrictedFundsFormListPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String dateRange = (String)paramMap.get("filter_dateranges");
        if (RptDateRangeEnum.CUSTOM.getValue().equals(dateRange)) {
            if (EmptyUtil.isEmpty((Object)paramMap.get("filter_dateranges_startdate")) || EmptyUtil.isEmpty((Object)paramMap.get("filter_dateranges_enddate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AcctUsageFormListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (((Date)paramMap.get("filter_dateranges_startdate")).after((Date)paramMap.get("filter_dateranges_startdate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AcctUsageFormListPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void initQueryColumn(String statDimension, ReportQueryParam param) {
        String[] fields;
        Map<String, Object> paramMap = this.getParamMap(param);
        String stat = (String)paramMap.get("filter_stat");
        switch (statDimension) {
            case "company": {
                fields = AcctChangeSumFormListPlugin.getCompanyFields();
                break;
            }
            case "openorg": {
                fields = AcctChangeSumFormListPlugin.getOpenOrgFields();
                break;
            }
            default: {
                fields = new String[]{};
            }
        }
        if (EmptyUtil.isNoEmpty((String)stat)) {
            ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fields));
            fieldList.add(1, INIT_STAT_DIM.get(stat));
            fields = fieldList.toArray(new String[0]);
        }
        this.rebuildColumn(fields);
    }

    private void rebuildColumn(String[] fields) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        AcctDataListHelper.rebuildColumn(fields, listTable);
    }

    private Map<String, Object> getParamMap(ReportQueryParam param) {
        if (this.paramMap == null) {
            this.paramMap = AcctDataListHelper.transQueryParam(param);
        }
        return this.paramMap;
    }

    static {
        INIT_STAT_DIM.put("acctprop", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"AcctSumFormListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        INIT_STAT_DIM.put("acctstyle", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"AcctSumFormListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        INIT_STAT_DIM.put("accttype", ResManager.loadKDString((String)"\u8d26\u6237\u6027\u8d28", (String)"AcctSumFormListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        fields = new String[]{null, ResManager.loadKDString((String)"\u671f\u521d\u8d26\u6237\u6570", (String)"AcctChangeSumFormListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u671f\u5f00\u6237\u6570", (String)"AcctChangeSumFormListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u671f\u9500\u6237\u6570", (String)"AcctChangeSumFormListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u671f\u53d8\u66f4\u6570", (String)"AcctChangeSumFormListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u671f\u51bb\u7ed3\u6570", (String)"AcctChangeSumFormListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u671f\u672b\u8d26\u6237\u6570", (String)"AcctChangeSumFormListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0])};
    }
}

